/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.api.AbstractTreeData;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.BlockNeighbors;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.FloodFill;
import ht.tuber.graph.FloodFillImpl;
import ht.tuber.graph.GraphUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LazyTreeData
extends AbstractTreeData {
    private final Level level;
    private final int chops;
    private final int maxNumLogs;
    private double mass = 0.0;
    private boolean overrideLeaves = false;
    private Set<BlockPos> logs = new HashSet<BlockPos>(){

        @Override
        public boolean add(BlockPos blockPos) {
            if (super.add(blockPos)) {
                LazyTreeData.this.mass += ChopUtil.getSupportFactor(LazyTreeData.this.level, blockPos);
                return true;
            }
            return false;
        }
    };
    private final Set<BlockPos> leaves = new HashSet<BlockPos>(){

        @Override
        public boolean add(BlockPos blockPos) {
            return super.add(blockPos);
        }
    };
    private FloodFill<BlockPos> generator;

    public LazyTreeData(Level level, Collection<BlockPos> base, DirectedGraph<BlockPos> logGraph, Predicate<BlockPos> logFilter, Predicate<BlockPos> leavesFilter, int maxNumLogs, int chops) {
        this.level = level;
        this.chops = chops;
        this.maxNumLogs = maxNumLogs;
        this.logs.addAll(base);
        DirectedGraph<BlockPos> world = GraphUtil.filter(logGraph, this::gatherLog, pos -> this.check((BlockPos)pos, logFilter, leavesFilter));
        this.generator = GraphUtil.flood(world, base, Vec3i::m_123342_);
    }

    private boolean gatherLog(BlockPos pos) {
        this.logs.add(pos);
        return true;
    }

    private boolean check(BlockPos pos, Predicate<BlockPos> logFilter, Predicate<BlockPos> leavesFilter) {
        if (leavesFilter.test(pos)) {
            this.leaves.add(pos);
        }
        return logFilter.test(pos);
    }

    @Override
    public boolean hasLeaves() {
        if (this.overrideLeaves || !this.leaves.isEmpty()) {
            return true;
        }
        return this.generator.fill().anyMatch(p -> !this.leaves.isEmpty() || this.overrideLeaves);
    }

    @Override
    public void setLogBlocks(Set<BlockPos> logBlocks) {
        this.logs = logBlocks;
        this.mass = ChopUtil.getSupportFactor(this.level, this.logs.stream()).orElse(1.0);
        this.generator = new FloodFillImpl<BlockPos>(List.of(), a -> Stream.empty(), a -> 0);
    }

    @Override
    public void setLeaves(boolean hasLeaves) {
        this.overrideLeaves = hasLeaves;
    }

    @Override
    public Stream<BlockPos> streamLogs() {
        return Stream.concat(this.logs.stream(), this.generator.fill()).limit(this.maxNumLogs);
    }

    @Override
    public Stream<BlockPos> streamLeaves() {
        this.streamLogs().forEach(a -> {});
        LinkedList<BlockPos> allLeaves = new LinkedList<BlockPos>();
        this.forEachLeaves(allLeaves, allLeaves::add);
        return allLeaves.stream();
    }

    private void forEachLeaves(List<BlockPos> firstLeaves, Consumer<BlockPos> forEach) {
        this.leaves.stream().filter(pos -> this.leavesHasExactDistance(this.level.m_8055_(pos), 1)).forEach(forEach);
        AtomicInteger distance = new AtomicInteger();
        DirectedGraph<BlockPos> distancedLeavesGraph = GraphUtil.filterNeighbors(BlockNeighbors.ADJACENTS::asStream, pos -> {
            BlockState state = this.level.m_8055_(pos);
            return ChopUtil.isBlockLeaves(state) && this.leavesHasAtLeastDistance(state, distance.get());
        });
        FloodFillImpl<BlockPos> flood = new FloodFillImpl<BlockPos>(firstLeaves, distancedLeavesGraph, a -> 0);
        int maxDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        for (int i = 2; i < maxDistance; ++i) {
            distance.set(i);
            flood.fillOnce(forEach);
        }
    }

    @Override
    public boolean readyToFell(int numChops) {
        if (!ChopUtil.enoughChopsToFell(numChops, this.mass)) {
            return false;
        }
        return this.generator.fill().allMatch(ignored -> ChopUtil.enoughChopsToFell(numChops, this.mass));
    }

    @Override
    public int getChops() {
        return this.chops;
    }

    public Level getLevel() {
        return this.level;
    }

    public Collection<BlockPos> getIncompleteLogs() {
        return this.logs;
    }

    public Collection<BlockPos> getIncompleteLeaves() {
        return this.leaves;
    }

    private boolean leavesHasExactDistance(BlockState state, int distance) {
        return state.m_61145_((Property)LeavesBlock.f_54419_).orElse(true) != false ? true : state.m_61145_((Property)LeavesBlock.f_54418_).orElse(distance) == distance;
    }

    private boolean leavesHasAtLeastDistance(BlockState state, int distance) {
        return state.m_61145_((Property)LeavesBlock.f_54419_).orElse(true) != false ? true : state.m_61145_((Property)LeavesBlock.f_54418_).orElse(distance) >= distance;
    }
}

