/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TreeCache {
    private final SingleBlockCache<TreeData> singleBlockCache = new SingleBlockCache();

    public TreeData getTree(Level level, BlockPos pos) {
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        return this.getTree(level, pos, maxNumTreeBlocks);
    }

    public void invalidate() {
        this.singleBlockCache.invalidate();
    }

    public TreeData getTree(Level level, BlockPos pos, int maxNumTreeBlocks) {
        TreeData tree = this.singleBlockCache.get((BlockGetter)level, pos);
        if (tree == null) {
            tree = ChopUtil.getTree(level, pos, maxNumTreeBlocks);
            this.singleBlockCache.put((BlockGetter)level, pos, tree);
        }
        return tree;
    }

    private static class SingleBlockCache<T> {
        private T value;
        private BlockGetter level;
        private BlockState blockState;
        private BlockPos pos;
        private BlockEntity entity;

        private SingleBlockCache() {
        }

        public T get(BlockGetter level, BlockPos pos) {
            if (level == this.level && pos.equals((Object)this.pos) && Objects.equals(level.m_8055_(pos), this.blockState) && Objects.equals(level.m_7702_(pos), this.entity)) {
                return this.value;
            }
            return null;
        }

        public void put(BlockGetter level, BlockPos pos, T value) {
            this.value = value;
            this.level = level;
            this.pos = pos;
            this.blockState = level.m_8055_(pos);
            this.entity = level.m_7702_(pos);
        }

        public void invalidate() {
            this.level = null;
            this.value = null;
            this.blockState = Blocks.f_50016_.m_49966_();
            this.entity = null;
        }
    }
}

