/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.ChopEvent;
import ht.treechop.api.TreeData;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.compat.MushroomCapDetection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeMushroomCapDetection
extends MushroomCapDetection {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ConfigHandler.COMMON.compatForMushroomStems.get().booleanValue()) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onDetectTree(ChopEvent.DetectTreeEvent event) {
            event.getTreeData().ifPresent(tree -> {
                TreeData newTree = MushroomCapDetection.detectHugeShrooms(event.getLevel(), event.getChoppedBlockPos(), tree);
                event.setTreeData(newTree);
            });
        }
    }
}

