/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets;

import com.cozary.nameless_trinkets.capability.NewCapabilities;
import com.cozary.nameless_trinkets.config.TrinketConfiguration;
import com.cozary.nameless_trinkets.init.ModCodec;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.utils.ConfigurationHandler;
import com.cozary.nameless_trinkets.utils.MaxHealthFix;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="nameless_trinkets")
public class NamelessTrinkets {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "nameless_trinkets";
    public static CreativeModeTab GROUP;

    public NamelessTrinkets() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::registerTabs);
        modBus.addListener(EventPriority.LOWEST, this::setup);
        modBus.addListener(this::enqueueIMC);
        ModCodec.LOOT_MODIFIER_SERIALIZERS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigurationHandler.SPAWN_SPEC, "nameless_trinkets-base.toml");
        MinecraftForge.EVENT_BUS.register((Object)new NewCapabilities.CapabilityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new MaxHealthFix());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerTabs(CreativeModeTabEvent.Register event) {
        GROUP = event.registerCreativeModeTab(new ResourceLocation(MOD_ID, "tab"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)ModItems.MYSTERIOUS_TRINKET.get())).m_257941_((Component)Component.m_237115_((String)"tabs.nameless_trinkets.tab")).m_257501_((featureFlagSet, tabOutput) -> ModItems.getItemsRegistered().forEach(registryObject -> tabOutput.m_246342_(new ItemStack((ItemLike)registryObject)))));
    }

    private void setup(FMLCommonSetupEvent event) {
        TrinketConfiguration.setupEverything();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("trinkets").icon(InventoryMenu.f_39697_).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("back").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("body").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("bracelet").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("hands").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("head").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("necklace").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charm").build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("extra").build());
    }
}

