/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.ConfigurationHandler;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class CrackedCrown
extends TrinketItem<Stats>
implements ICurioItem {
    public static CrackedCrown INSTANCE;
    private final MutablePair<String, UUID> Cracked_Crown_Attack_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_damage", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Armor_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_armor", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Attack_Speed_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_speed", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Armor_Thougness_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_armor_thougness", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Attack_Knockback_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_knockback", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Knockback_Resistance_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_knockback_resistance", (Object)UUID.randomUUID());

    public CrackedCrown() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void onFOVUpdate(ComputeFovModifierEvent event) {
        Optional stack1;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        Player player = event.getPlayer();
        if (player != null && (stack1 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.CRACKED_CROWN.get())).isPresent() && !((Boolean)ConfigurationHandler.SPAWN.disable.get()).booleanValue()) {
            event.setNewFovModifier(1.0f);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.CRACKED_CROWN.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.cracked_crown_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                if ((config.percentageExtraArmor + config.percentageExtraArmorThougness + config.percentageExtraAttack + config.percentageExtraAttackKnockback + config.percentageExtraAttackSpeed + config.percentageExtraKnockbackResistance) / 6.0 == 50.0) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.cracked_crown_1").m_130940_(ChatFormatting.GOLD));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.cracked_crown_2").m_130940_(ChatFormatting.GOLD));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        AttributeInstance attribAttack = livingEntity.m_21051_(Attributes.f_22281_);
        AttributeInstance attribSpeed = livingEntity.m_21051_(Attributes.f_22279_);
        AttributeInstance attribArmor = livingEntity.m_21051_(Attributes.f_22284_);
        AttributeInstance attribAttackSpeed = livingEntity.m_21051_(Attributes.f_22283_);
        AttributeInstance attribArmorThougness = livingEntity.m_21051_(Attributes.f_22285_);
        AttributeInstance attribAttackKnockback = livingEntity.m_21051_(Attributes.f_22282_);
        AttributeInstance attribKnockbackResistance = livingEntity.m_21051_(Attributes.f_22278_);
        AttributeInstance attribLuck = livingEntity.m_21051_(Attributes.f_22286_);
        AttributeInstance attribMaxHealth = livingEntity.m_21051_(Attributes.f_22276_);
        AttributeModifier attackModifier = new AttributeModifier((UUID)this.Cracked_Crown_Attack_MOD.getRight(), (String)this.Cracked_Crown_Attack_MOD.getLeft(), config.percentageExtraAttack / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier armorModifier = new AttributeModifier((UUID)this.Cracked_Crown_Armor_MOD.getRight(), (String)this.Cracked_Crown_Armor_MOD.getLeft(), config.percentageExtraArmor / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier attackSpeedModifier = new AttributeModifier((UUID)this.Cracked_Crown_Attack_Speed_MOD.getRight(), (String)this.Cracked_Crown_Attack_Speed_MOD.getLeft(), config.percentageExtraAttackSpeed / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier armorThoughnessModifier = new AttributeModifier((UUID)this.Cracked_Crown_Armor_Thougness_MOD.getRight(), (String)this.Cracked_Crown_Armor_Thougness_MOD.getLeft(), config.percentageExtraArmorThougness / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier attackKnockbackModifier = new AttributeModifier((UUID)this.Cracked_Crown_Attack_Knockback_MOD.getRight(), (String)this.Cracked_Crown_Attack_Knockback_MOD.getLeft(), config.percentageExtraAttackKnockback / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier knockbackResistanceModifier = new AttributeModifier((UUID)this.Cracked_Crown_Knockback_Resistance_MOD.getRight(), (String)this.Cracked_Crown_Knockback_Resistance_MOD.getLeft(), config.percentageExtraKnockbackResistance / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        assert (attribAttack != null);
        EntityUtils.applyAttributeModifier(attribAttack, attackModifier);
        assert (attribArmor != null);
        EntityUtils.applyAttributeModifier(attribArmor, armorModifier);
        assert (attribAttackSpeed != null);
        EntityUtils.applyAttributeModifier(attribAttackSpeed, attackSpeedModifier);
        assert (attribArmorThougness != null);
        EntityUtils.applyAttributeModifier(attribArmorThougness, armorThoughnessModifier);
        assert (attribAttackKnockback != null);
        EntityUtils.applyAttributeModifier(attribAttackKnockback, attackKnockbackModifier);
        assert (attribKnockbackResistance != null);
        EntityUtils.applyAttributeModifier(attribKnockbackResistance, knockbackResistanceModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_(Attributes.f_22281_)), new AttributeModifier((UUID)this.Cracked_Crown_Attack_MOD.getRight(), (String)this.Cracked_Crown_Attack_MOD.getLeft(), config.percentageExtraAttack / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_(Attributes.f_22284_)), new AttributeModifier((UUID)this.Cracked_Crown_Armor_MOD.getRight(), (String)this.Cracked_Crown_Armor_MOD.getLeft(), config.percentageExtraArmor / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_(Attributes.f_22283_)), new AttributeModifier((UUID)this.Cracked_Crown_Attack_Speed_MOD.getRight(), (String)this.Cracked_Crown_Attack_Speed_MOD.getLeft(), config.percentageExtraAttackSpeed / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_(Attributes.f_22285_)), new AttributeModifier((UUID)this.Cracked_Crown_Armor_Thougness_MOD.getRight(), (String)this.Cracked_Crown_Armor_Thougness_MOD.getLeft(), config.percentageExtraArmorThougness / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_(Attributes.f_22282_)), new AttributeModifier((UUID)this.Cracked_Crown_Attack_Knockback_MOD.getRight(), (String)this.Cracked_Crown_Attack_Knockback_MOD.getLeft(), config.percentageExtraAttackKnockback / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_(Attributes.f_22278_)), new AttributeModifier((UUID)this.Cracked_Crown_Knockback_Resistance_MOD.getRight(), (String)this.Cracked_Crown_Knockback_Resistance_MOD.getLeft(), config.percentageExtraKnockbackResistance / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public static class Stats
    extends TrinketsStats {
        public double percentageExtraAttack = 50.0;
        public double percentageExtraArmor = 50.0;
        public double percentageExtraAttackSpeed = 50.0;
        public double percentageExtraArmorThougness = 50.0;
        public double percentageExtraAttackKnockback = 50.0;
        public double percentageExtraKnockbackResistance = 50.0;
        public boolean isEnable = true;
    }
}

