/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class FragileCloud
extends TrinketItem<Stats>
implements ICurioItem {
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABB");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    public static FragileCloud INSTANCE;

    public FragileCloud() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void function(TickEvent.PlayerTickEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (event.player != null) {
            Player player = event.player;
            if (!player.f_19853_.f_46443_ && !player.m_5833_()) {
                Optional stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.FRAGILE_CLOUD.get());
                Optional stack1 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.MOON_STONE.get());
                AttributeInstance gravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                if (stack0.isPresent() && stack1.isEmpty()) {
                    if (!(player.m_21255_() || player.m_20096_() || player.m_20069_())) {
                        assert (gravity != null);
                        if (!gravity.m_22109_(SLOW_FALLING) && player.m_20184_().f_82480_ < -0.3) {
                            gravity.m_22125_(SLOW_FALLING);
                        }
                        player.m_183634_();
                        if (gravity.m_22109_(SLOW_FALLING)) {
                            double particleX = player.m_20185_() + (double)(player.m_217043_().m_188499_() ? -1 : 1) * Math.pow(player.m_217043_().m_188501_(), 1.0) * 1.0;
                            double particleY = player.m_20186_() + (double)(player.m_217043_().m_188501_() * 1.0f) - 2.0;
                            double particleZ = player.m_20189_() + (double)(player.m_217043_().m_188499_() ? -1 : 1) * Math.pow(player.m_217043_().m_188501_(), 1.0) * 1.0;
                            ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, particleX, particleY, particleZ, 1, 1.0, 1.0, 1.0, 0.1);
                        }
                    } else {
                        assert (gravity != null);
                        if (gravity.m_22109_(SLOW_FALLING)) {
                            gravity.m_22130_(SLOW_FALLING);
                        }
                    }
                } else {
                    assert (gravity != null);
                    if (gravity.m_22109_(SLOW_FALLING)) {
                        gravity.m_22130_(SLOW_FALLING);
                    }
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.FRAGILE_CLOUD.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.fragile_cloud_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.fragile_cloud_1").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public boolean isEnable = true;
    }
}

