/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.ConfigurationHandler;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class GodsCrown
extends TrinketItem<Stats>
implements ICurioItem {
    public static GodsCrown INSTANCE;
    private final MutablePair<String, UUID> Cracked_Crown_Attack_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_damage", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Speed_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_movement_speed", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Attack_Speed_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_speed", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Attack_Knockback_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_knockback", (Object)UUID.randomUUID());
    private final MutablePair<String, UUID> Cracked_Crown_Max_Health_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_max_health", (Object)UUID.randomUUID());

    public GodsCrown() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void onFOVUpdate(ComputeFovModifierEvent event) {
        Optional stack2;
        Player player = event.getPlayer();
        if (player != null && (stack2 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.STABLE_CROWN.get())).isPresent() && !((Boolean)ConfigurationHandler.SPAWN.disable.get()).booleanValue()) {
            event.setNewFovModifier(1.0f);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.STABLE_CROWN.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.gods_crown_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                if ((config.percentageExtraAttack + config.percentageExtraAttackKnockback + config.percentageExtraAttackSpeed + config.percentageExtraMaxHealth + config.percentageExtraSpeed) / 5.0 == 120.0) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.gods_crown_1").m_130940_(ChatFormatting.GOLD));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.gods_crown_2").m_130940_(ChatFormatting.GOLD));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        AttributeInstance attribAttack = livingEntity.m_21051_(Attributes.f_22281_);
        AttributeInstance attribSpeed = livingEntity.m_21051_(Attributes.f_22279_);
        AttributeInstance attribArmor = livingEntity.m_21051_(Attributes.f_22284_);
        AttributeInstance attribAttackSpeed = livingEntity.m_21051_(Attributes.f_22283_);
        AttributeInstance attribArmorThougness = livingEntity.m_21051_(Attributes.f_22285_);
        AttributeInstance attribAttackKnockback = livingEntity.m_21051_(Attributes.f_22282_);
        AttributeInstance attribKnockbackResistance = livingEntity.m_21051_(Attributes.f_22278_);
        AttributeInstance attribLuck = livingEntity.m_21051_(Attributes.f_22286_);
        AttributeInstance attribMaxHealth = livingEntity.m_21051_(Attributes.f_22276_);
        AttributeModifier attackModifier = new AttributeModifier((UUID)this.Cracked_Crown_Attack_MOD.getRight(), (String)this.Cracked_Crown_Attack_MOD.getLeft(), config.percentageExtraAttack / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier speedModifier = new AttributeModifier((UUID)this.Cracked_Crown_Speed_MOD.getRight(), (String)this.Cracked_Crown_Speed_MOD.getLeft(), config.percentageExtraSpeed / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier attackSpeedModifier = new AttributeModifier((UUID)this.Cracked_Crown_Attack_Speed_MOD.getRight(), (String)this.Cracked_Crown_Attack_Speed_MOD.getLeft(), config.percentageExtraAttackSpeed / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier attackKnockbackModifier = new AttributeModifier((UUID)this.Cracked_Crown_Attack_Knockback_MOD.getRight(), (String)this.Cracked_Crown_Attack_Knockback_MOD.getLeft(), config.percentageExtraAttackKnockback / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier maxHealthModifier = new AttributeModifier((UUID)this.Cracked_Crown_Max_Health_MOD.getRight(), (String)this.Cracked_Crown_Max_Health_MOD.getLeft(), config.percentageExtraMaxHealth / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        assert (attribAttack != null);
        EntityUtils.applyAttributeModifier(attribAttack, attackModifier);
        assert (attribSpeed != null);
        EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
        assert (attribAttackSpeed != null);
        EntityUtils.applyAttributeModifier(attribAttackSpeed, attackSpeedModifier);
        assert (attribAttackKnockback != null);
        EntityUtils.applyAttributeModifier(attribAttackKnockback, attackKnockbackModifier);
        assert (attribKnockbackResistance != null);
        assert (attribMaxHealth != null);
        EntityUtils.applyAttributeModifier(attribMaxHealth, maxHealthModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_(Attributes.f_22281_)), new AttributeModifier((UUID)this.Cracked_Crown_Attack_MOD.getRight(), (String)this.Cracked_Crown_Attack_MOD.getLeft(), ((Stats)this.config).percentageExtraAttack / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_(Attributes.f_22279_)), new AttributeModifier((UUID)this.Cracked_Crown_Speed_MOD.getRight(), (String)this.Cracked_Crown_Speed_MOD.getLeft(), ((Stats)this.config).percentageExtraSpeed / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_(Attributes.f_22283_)), new AttributeModifier((UUID)this.Cracked_Crown_Attack_Speed_MOD.getRight(), (String)this.Cracked_Crown_Attack_Speed_MOD.getLeft(), ((Stats)this.config).percentageExtraAttackSpeed / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_(Attributes.f_22282_)), new AttributeModifier((UUID)this.Cracked_Crown_Attack_Knockback_MOD.getRight(), (String)this.Cracked_Crown_Attack_Knockback_MOD.getLeft(), ((Stats)this.config).percentageExtraAttackKnockback / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_(Attributes.f_22276_)), new AttributeModifier((UUID)this.Cracked_Crown_Max_Health_MOD.getRight(), (String)this.Cracked_Crown_Max_Health_MOD.getLeft(), ((Stats)this.config).percentageExtraMaxHealth / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public static class Stats
    extends TrinketsStats {
        public double percentageExtraAttack = 120.0;
        public double percentageExtraSpeed = 120.0;
        public double percentageExtraAttackSpeed = 120.0;
        public double percentageExtraAttackKnockback = 120.0;
        public double percentageExtraMaxHealth = 120.0;
        public boolean isEnable = true;
    }
}

