/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.capability.NewCapabilities;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class VampireBlood
extends TrinketItem<Stats>
implements ICurioItem {
    public static VampireBlood INSTANCE;
    private final MutablePair<String, UUID> VampireBlood_MOD = new MutablePair((Object)"nameless_trinkets:vampire_blood_attack_damage", (Object)UUID.randomUUID());

    public VampireBlood() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void function(LivingDeathEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.VAMPIRE_BLOOD.get());
            if (stack0.isPresent() && !player.f_19853_.f_46443_) {
                ((ServerLevel)event.getEntity().m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123763_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                player.m_5634_(event.getEntity().m_21233_() * (config.healingPercentage / 100.0f));
            }
        }
    }

    @SubscribeEvent
    public static void VampireWeak(TickEvent.PlayerTickEvent event) {
        Optional stack0;
        Player player;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && (player = event.player) != null && !player.m_5833_() && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.VAMPIRE_BLOOD.get())).isPresent() && player instanceof ServerPlayer) {
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (player.f_19853_.m_46461_()) {
                    if (!player.f_19853_.m_45527_(player.m_20183_()) && trinketsData.getTickVampirePause() != 0.0f) {
                        trinketsData.setTickVampirePause(0.0f);
                    } else if (trinketsData.getTickVampirePause() == 200.0f && !player.f_19853_.f_46443_) {
                        ((ServerLevel)event.player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                        player.m_6469_(player.m_269291_().m_269549_(), (float)config.sunDamage);
                        trinketsData.setTickVampirePause(0.0f);
                    } else if (player.f_19853_.m_45527_(player.m_20183_()) && trinketsData.getTickVampirePause() >= 0.0f) {
                        trinketsData.setTickVampirePause(trinketsData.getTickVampirePause() + 1.0f);
                    }
                }
            });
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.VAMPIRE_BLOOD.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.vampire_blood_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.vampire_blood_1", (Object[])new Object[]{config.damageMultiplierPercentage + "%"}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.vampire_blood_2", (Object[])new Object[]{config.healingPercentage + "%"}).m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.vampire_blood_3").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        AttributeInstance attribSpeed = livingEntity.m_21051_(Attributes.f_22281_);
        AttributeModifier speedModifier = new AttributeModifier((UUID)this.VampireBlood_MOD.getRight(), (String)this.VampireBlood_MOD.getLeft(), config.damageMultiplierPercentage / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        assert (attribSpeed != null);
        EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_(Attributes.f_22281_)), new AttributeModifier((UUID)this.VampireBlood_MOD.getRight(), (String)this.VampireBlood_MOD.getLeft(), ((Stats)this.config).damageMultiplierPercentage / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public static class Stats
    extends TrinketsStats {
        public double damageMultiplierPercentage = 150.0;
        public float healingPercentage = 10.0f;
        public double sunDamage = 2.0;
        public boolean isEnable = true;
    }
}

