/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.platforms.client.gui.Textures;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.network.NetworkHandler;
import shetiphian.platforms.common.network.PacketPlatformSelect;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

@OnlyIn(value=Dist.CLIENT)
public class GuiPlatformSelect
extends Screen {
    private final String TEXT_BACK = I18n.m_118938_((String)"gui.platforms.wrench.select.back", (Object[])new Object[0]);
    private final String TEXT_NEXT = I18n.m_118938_((String)"gui.platforms.wrench.select.next", (Object[])new Object[0]);
    private final String TEXT_FIRST = I18n.m_118938_((String)"gui.platforms.wrench.select.first", (Object[])new Object[0]);
    private final String TEXT_SAVE = I18n.m_118938_((String)"gui.platforms.wrench.select.save", (Object[])new Object[0]);
    private final Player player;
    private final Level world;
    private final BlockPos pos;
    private EntityGuiItem displayItem = null;
    private final List<ItemStack> types;
    private int start;
    private int index;
    private final int listSize;
    private final int xSize = 182;
    private final int ySize = 110;
    private int guiLeft;
    private int guiTop;
    private final long debounce = System.currentTimeMillis();

    public GuiPlatformSelect(Player player, Level world, BlockPos pos, EnumPlatformType platformType, TileEntityPlatformBase tile) {
        super((Component)Component.m_237119_());
        this.player = player;
        this.world = world;
        this.pos = pos;
        Collection<EnumSubType> subTypes = null;
        Block block = tile.m_58900_().m_60734_();
        EnumSubType subType = null;
        if (block instanceof BlockPlatformBase) {
            subTypes = ((BlockPlatformBase)block).getAllowedValues();
            subType = BlockPlatformBase.getPlatformSubType(tile.m_58900_());
        }
        if (subTypes == null) {
            throw new Error("Unexpected Platform");
        }
        this.start = 0;
        int index = 0;
        for (EnumSubType type : subTypes) {
            if (type == subType) {
                this.start = index;
                break;
            }
            ++index;
        }
        this.index = this.start;
        ItemStack basePlatform = ItemBlockPlatform.createStack(platformType, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        this.types = new ArrayList<ItemStack>();
        for (EnumSubType type : subTypes) {
            ItemStack stack = basePlatform.m_41777_();
            ItemBlockPlatform.setSubType(stack, type);
            this.types.add(stack);
        }
        this.listSize = this.types.size();
        this.updateDisplayItem();
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
    }

    private void updateDisplayItem() {
        this.displayItem = new EntityGuiItem(this.world, 0.0, 0.0, 0.0, this.types.get(this.index));
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int count;
        this.m_7333_(matrixStack);
        GuiHelper.setRenderSystem((ResourceLocation)Textures.WRENCH_SELECT.get());
        GuiPlatformSelect.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)182, (int)110);
        GuiHelper.resetRenderSystem();
        int centerX = this.guiLeft + this.xSize / 2;
        int centerY = this.guiTop + this.ySize / 2;
        GuiPlatformSelect.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)(this.index + 1 + " / " + this.listSize), (int)centerX, (int)(centerY + 5), (int)-30720);
        GuiPlatformSelect.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.TEXT_BACK, (int)centerX, (int)(centerY + 14), (int)-7631989);
        GuiPlatformSelect.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.TEXT_NEXT, (int)centerX, (int)(centerY + 22), (int)-7631989);
        GuiPlatformSelect.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.TEXT_FIRST, (int)centerX, (int)(centerY + 30), (int)-7631989);
        GuiPlatformSelect.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.TEXT_SAVE, (int)centerX, (int)(centerY + 38), (int)-7631989);
        if (this.displayItem != null) {
            this.displayItem.render(this.getMinecraft(), true, 130.0f, 0.0f, 0.0f, (float)(this.guiLeft + 91), (float)(this.guiTop + 52), 50.0f, -90.0f, 90.0f, 90.0f);
        }
        if ((count = this.types.size()) > 1) {
            this.f_96542_.m_274369_(matrixStack, this.types.get(this.getOffsetIndex(-1)), this.guiLeft + 52, this.guiTop + 34);
            this.f_96542_.m_274369_(matrixStack, this.types.get(this.getOffsetIndex(1)), this.guiLeft + 114, this.guiTop + 34);
        }
        if (count > 4) {
            this.f_96542_.m_274369_(matrixStack, this.types.get(this.getOffsetIndex(-2)), this.guiLeft + 34, this.guiTop + 34);
            this.f_96542_.m_274369_(matrixStack, this.types.get(this.getOffsetIndex(2)), this.guiLeft + 132, this.guiTop + 34);
        }
        if (count > 6) {
            this.f_96542_.m_274369_(matrixStack, this.types.get(this.getOffsetIndex(-3)), this.guiLeft + 16, this.guiTop + 34);
            this.f_96542_.m_274369_(matrixStack, this.types.get(this.getOffsetIndex(3)), this.guiLeft + 150, this.guiTop + 34);
        }
    }

    private int getOffsetIndex(int offset) {
        int value = this.index + offset;
        int max = this.listSize - 1;
        return value < 0 ? max : (value > max ? 0 : value);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.index = this.getOffsetIndex(1);
            this.updateDisplayItem();
        } else if (scroll > 0.0) {
            this.index = this.getOffsetIndex(-1);
            this.updateDisplayItem();
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && System.currentTimeMillis() > this.debounce + 25L) {
            this.setPlatform();
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                this.setPlatform();
                return true;
            }
            case 263: 
            case 264: {
                this.index = this.getOffsetIndex(-1);
                this.updateDisplayItem();
                return true;
            }
            case 262: 
            case 265: {
                this.index = this.getOffsetIndex(1);
                this.updateDisplayItem();
                return true;
            }
            case 32: {
                this.index = this.start;
                this.updateDisplayItem();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void setPlatform() {
        if (this.index != this.start) {
            NetworkHandler.sendToServer(new PacketPlatformSelect(ItemBlockPlatform.getSubType(this.types.get(this.index)).ordinal(), this.pos));
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = this.player.m_21120_(hand);
            if (!ToolHelper.isWrench((ItemStack)stack)) continue;
            this.player.m_6674_(hand);
            break;
        }
        this.getMinecraft().f_91074_.m_6915_();
    }

    public boolean m_7043_() {
        return false;
    }
}

