/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.buffer.IndexedVertexData;
import me.jellysquid.mods.sodium.client.gl.util.ElementRange;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.BakedChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import net.minecraft.client.renderer.RenderType;
import org.lwjgl.system.MemoryUtil;

public class ChunkBuildBuffers {
    private final ChunkModelBuilder[] delegates;
    private final ChunkVertexBufferBuilder[] vertexBuffers;
    private final IndexBufferBuilder[][] indexBuffers;
    private final ChunkVertexType vertexType;
    private final BlockRenderPassManager renderPassManager;

    public ChunkBuildBuffers(ChunkVertexType vertexType, BlockRenderPassManager renderPassManager) {
        this.vertexType = vertexType;
        this.renderPassManager = renderPassManager;
        this.delegates = new ChunkModelBuilder[BlockRenderPass.COUNT];
        this.vertexBuffers = new ChunkVertexBufferBuilder[BlockRenderPass.COUNT];
        this.indexBuffers = new IndexBufferBuilder[BlockRenderPass.COUNT][ModelQuadFacing.COUNT];
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            IndexBufferBuilder[] indexBuffers = this.indexBuffers[pass.ordinal()];
            for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
                indexBuffers[facing] = new IndexBufferBuilder(1024);
            }
            this.vertexBuffers[pass.ordinal()] = new ChunkVertexBufferBuilder(this.vertexType, pass.getLayer().m_110507_());
        }
    }

    public void init(ChunkRenderData.Builder renderData, int chunkId) {
        for (ChunkVertexBufferBuilder vertexBuffer : this.vertexBuffers) {
            vertexBuffer.start(chunkId);
        }
        ChunkVertexBufferBuilder[] chunkVertexBufferBuilderArray = this.indexBuffers;
        int n = chunkVertexBufferBuilderArray.length;
        for (int i = 0; i < n; ++i) {
            ChunkVertexBufferBuilder indexBuffers;
            for (ChunkVertexBufferBuilder indexBuffer : indexBuffers = chunkVertexBufferBuilderArray[i]) {
                ((IndexBufferBuilder)((Object)indexBuffer)).start();
            }
        }
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i] = new BakedChunkModelBuilder(this.vertexBuffers[i], this.indexBuffers[i], renderData);
        }
    }

    public ChunkModelBuilder get(RenderType layer) {
        return this.delegates[this.renderPassManager.getRenderPassId(layer)];
    }

    public ChunkMeshData createMesh(BlockRenderPass pass) {
        NativeBuffer vertexBuffer = this.vertexBuffers[pass.ordinal()].pop();
        if (vertexBuffer == null) {
            return null;
        }
        IntArrayList[] indexBuffers = (IntArrayList[])Arrays.stream(this.indexBuffers[pass.ordinal()]).map(IndexBufferBuilder::pop).toArray(IntArrayList[]::new);
        NativeBuffer indexBuffer = new NativeBuffer(Arrays.stream(indexBuffers).mapToInt(array -> array.size() * 4).sum());
        int indexPointer = 0;
        EnumMap<ModelQuadFacing, ElementRange> ranges = new EnumMap<ModelQuadFacing, ElementRange>(ModelQuadFacing.class);
        for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
            IntArrayList indices = indexBuffers[facing.ordinal()];
            if (indices.isEmpty()) continue;
            ranges.put(facing, new ElementRange(indexPointer, indices.size()));
            ChunkBuildBuffers.copyToIntBuffer(MemoryUtil.memAddress((ByteBuffer)indexBuffer.getDirectBuffer(), (int)indexPointer), indices);
            indexPointer += indices.size() * 4;
        }
        IndexedVertexData vertexData = new IndexedVertexData(this.vertexType.getVertexFormat(), vertexBuffer, indexBuffer);
        return new ChunkMeshData(vertexData, ranges);
    }

    private static void copyToIntBuffer(long ptr, IntArrayList list) {
        IntListIterator intListIterator = list.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            MemoryUtil.memPutInt((long)ptr, (int)i);
            ptr += 4L;
        }
    }

    public void destroy() {
        for (ChunkVertexBufferBuilder builder : this.vertexBuffers) {
            builder.destroy();
        }
    }
}

