/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import java.util.List;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;

public class BlockRenderer {
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final ColorBlender colorBlender;
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;

    public BlockRenderer(Minecraft client, LightPipelineProvider lighters, ColorBlender colorBlender) {
        this.blockColors = (BlockColorsExtended)client.m_91298_();
        this.colorBlender = colorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.m_91086_();
    }

    public boolean renderModel(BlockRenderContext ctx, ChunkModelBuilder buffers) {
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(ctx.state(), ctx.model(), ctx.world(), ctx.pos()));
        Vec3 renderOffset = ctx.state().m_60824_((BlockGetter)ctx.world(), ctx.pos());
        boolean rendered = false;
        for (Direction face : DirectionUtil.ALL_DIRECTIONS) {
            List<BakedQuad> quads = this.getGeometry(ctx, face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, face)) continue;
            this.renderQuadList(ctx, lighter, renderOffset, buffers, quads, face);
            rendered = true;
        }
        List<BakedQuad> all = this.getGeometry(ctx, null);
        if (!all.isEmpty()) {
            this.renderQuadList(ctx, lighter, renderOffset, buffers, all, null);
            rendered = true;
        }
        return rendered;
    }

    private List<BakedQuad> getGeometry(BlockRenderContext ctx, Direction face) {
        RandomSource random = this.random;
        random.m_188584_(ctx.seed());
        return ctx.model().getQuads(ctx.state(), face, random, ctx.data(), ctx.layer());
    }

    private boolean isFaceVisible(BlockRenderContext ctx, Direction face) {
        return this.occlusionCache.shouldDrawSide(ctx.state(), (BlockGetter)ctx.world(), ctx.pos(), face);
    }

    private void renderQuadList(BlockRenderContext ctx, LightPipeline lighter, Vec3 offset, ChunkModelBuilder builder, List<BakedQuad> quads, Direction cullFace) {
        ModelQuadFacing facing = cullFace == null ? ModelQuadFacing.UNASSIGNED : ModelQuadFacing.fromDirection(cullFace);
        ColorSampler<BlockState> colorizer = null;
        ChunkVertexBufferBuilder vertexBuffer = builder.getVertexBuffer();
        IndexBufferBuilder indexBuffer = builder.getIndexBuffer(facing);
        QuadLightData lightData = this.cachedQuadLightData;
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuad quad = quads.get(i);
            ModelQuadView quadView = (ModelQuadView)quad;
            lighter.calculate(quadView, ctx.pos(), lightData, cullFace, quad.m_111306_(), quad.m_111307_());
            int[] colors = null;
            if (quad.m_111304_()) {
                if (colorizer == null) {
                    colorizer = this.blockColors.getColorProvider(ctx.state());
                }
                colors = this.colorBlender.getColors(ctx.world(), ctx.pos(), quadView, colorizer, ctx.state());
            }
            this.writeGeometry(ctx, vertexBuffer, indexBuffer, offset, quadView, colors, lightData.br, lightData.lm);
            TextureAtlasSprite sprite = quad.m_173410_();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkVertexBufferBuilder vertexBuffer, IndexBufferBuilder indexBuffer, Vec3 offset, ModelQuadView quad, int[] colors, float[] brightness, int[] lightmap) {
        ModelQuadOrientation orientation = ModelQuadOrientation.orientByBrightness(brightness);
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + (float)offset.m_7096_();
            out.y = ctx.origin().y() + quad.getY(srcIndex) + (float)offset.m_7098_();
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + (float)offset.m_7094_();
            out.color = ColorABGR.mul(colors != null ? colors[srcIndex] : quad.getColor(srcIndex), brightness[srcIndex]);
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = lightmap[srcIndex];
        }
        indexBuffer.add(vertexBuffer.push(vertices), ModelQuadWinding.CLOCKWISE);
    }

    private LightMode getLightingMode(BlockState state, BakedModel model, BlockAndTintGetter world, BlockPos pos) {
        if (this.useAmbientOcclusion && model.m_7541_() && state.getLightEmission((BlockGetter)world, pos) == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

