/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.dynresources;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.ModelLocationCache;
import org.jetbrains.annotations.Nullable;

public class ModelBakeEventHelper {
    private static final Set<String> INCOMPATIBLE_MODS = ImmutableSet.of((Object)"industrialforegoing");
    private final Map<ResourceLocation, BakedModel> modelRegistry;
    private final Set<ResourceLocation> topLevelModelLocations;
    private final MutableGraph<String> dependencyGraph;

    public ModelBakeEventHelper(Map<ResourceLocation, BakedModel> modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.topLevelModelLocations = new HashSet<ResourceLocation>(modelRegistry.keySet());
        for (Block block : ForgeRegistries.BLOCKS) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                this.topLevelModelLocations.add((ResourceLocation)ModelLocationCache.get(state));
            }
        }
        for (Item item : ForgeRegistries.ITEMS) {
            this.topLevelModelLocations.add((ResourceLocation)ModelLocationCache.get(item));
        }
        this.dependencyGraph = GraphBuilder.undirected().build();
        ModList.get().forEachModContainer((id, mc) -> {
            this.dependencyGraph.addNode(id);
            for (IModInfo.ModVersion version : mc.getModInfo().getDependencies()) {
                this.dependencyGraph.addNode((Object)version.getModId());
            }
        });
        for (String id2 : this.dependencyGraph.nodes()) {
            Optional mContainer = ModList.get().getModContainerById(id2);
            if (!mContainer.isPresent()) continue;
            for (IModInfo.ModVersion version : ((ModContainer)mContainer.get()).getModInfo().getDependencies()) {
                if (Objects.equals(id2, version.getModId())) continue;
                this.dependencyGraph.putEdge((Object)id2, (Object)version.getModId());
            }
        }
    }

    public Map<ResourceLocation, BakedModel> wrapRegistry(String modId) {
        final HashSet<String> modIdsToInclude = new HashSet<String>();
        modIdsToInclude.add(modId);
        try {
            modIdsToInclude.addAll(this.dependencyGraph.adjacentNodes((Object)modId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modIdsToInclude.remove("minecraft");
        if (modIdsToInclude.stream().noneMatch(INCOMPATIBLE_MODS::contains)) {
            return this.modelRegistry;
        }
        final Set ourModelLocations = Sets.filter(this.topLevelModelLocations, loc -> modIdsToInclude.contains(loc.m_135827_()));
        final BakedModel missingModel = this.modelRegistry.get(ModelBakery.f_119230_);
        return new ForwardingMap<ResourceLocation, BakedModel>(){

            protected Map<ResourceLocation, BakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            public BakedModel get(@Nullable Object key) {
                BakedModel model = (BakedModel)super.get(key);
                if (model == null && key != null && modIdsToInclude.contains(((ResourceLocation)key).m_135827_())) {
                    ModernFix.LOGGER.warn("Model {} is missing, but was requested in model bake event. Returning missing model", key);
                    return missingModel;
                }
                return model;
            }

            public Set<ResourceLocation> keySet() {
                return ourModelLocations;
            }

            public boolean containsKey(@Nullable Object key) {
                return ourModelLocations.contains(key) || super.containsKey(key);
            }
        };
    }
}

