/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.resourcepacks;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.forge.load.ModResourcePackPathFixer;
import org.embeddedt.modernfix.resources.ICachingResourcePack;
import org.embeddedt.modernfix.resources.NewResourcePackAdapter;
import org.embeddedt.modernfix.resources.PackResourcesCacheEngine;
import org.embeddedt.modernfix.util.PackTypeHelper;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PathPackResources.class})
public abstract class ForgePathPackResourcesMixin
implements ICachingResourcePack {
    private PackResourcesCacheEngine cacheEngine;
    private IModFile mfix$resolveFileOverride;

    @Shadow(remap=false)
    protected abstract Path resolve(String ... var1);

    @Shadow(remap=false)
    @NotNull
    protected abstract Set<String> getNamespacesFromDisk(PackType var1);

    @Shadow(remap=false)
    private static String[] getPathFromLocation(PackType type, ResourceLocation location) {
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void cacheResources(String packId, boolean isBuiltin, Path source, CallbackInfo ci) {
        if (this.getClass() == PathPackResources.class) {
            this.mfix$resolveFileOverride = ModResourcePackPathFixer.getModFileByRootPath(source);
        }
        if (this.mfix$resolveFileOverride != null) {
            ModernFix.LOGGER.warn("PathResourcePack base class instantiated with root path of mod file {}. This probably means a mod should be calling ResourcePackLoader.createPackForMod instead. Applying workaround.", (Object)this.mfix$resolveFileOverride.getFileName());
        }
        this.invalidateCache();
        PackResourcesCacheEngine.track(this);
    }

    @Inject(method={"resolve"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void resolveViaModFile(String[] paths, CallbackInfoReturnable<Path> cir) {
        if (this.mfix$resolveFileOverride != null) {
            cir.setReturnValue((Object)this.mfix$resolveFileOverride.findResource(paths));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackResourcesCacheEngine generateResourceCache() {
        ForgePathPackResourcesMixin forgePathPackResourcesMixin = this;
        synchronized (forgePathPackResourcesMixin) {
            PackResourcesCacheEngine engine = this.cacheEngine;
            if (engine != null) {
                return engine;
            }
            this.cacheEngine = engine = new PackResourcesCacheEngine(this::getNamespacesFromDisk, (type, namespace) -> this.resolve(type.m_10305_(), (String)namespace));
            return engine;
        }
    }

    @Override
    public void invalidateCache() {
        this.cacheEngine = null;
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCacheForNamespaces(PackType type, CallbackInfoReturnable<Set<String>> cir) {
        Set<String> namespaces;
        PackResourcesCacheEngine engine = this.cacheEngine;
        if (engine != null && (namespaces = engine.getNamespaces(type)) != null) {
            cir.setReturnValue(namespaces);
        }
    }

    @Redirect(method={"getRootResource"}, at=@At(value="INVOKE", target="Ljava/nio/file/Files;exists(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z"))
    private boolean useCacheForExistence(Path path, LinkOption[] options, String[] originalPaths) {
        if (originalPaths.length < 3) {
            return Files.exists(path, options);
        }
        return this.generateResourceCache().hasResource(originalPaths);
    }

    @Inject(method={"listResources"}, at={@At(value="HEAD")}, cancellable=true)
    private void fastGetResources(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput, CallbackInfo ci) {
        if (!PackTypeHelper.isVanillaPackType(type)) {
            return;
        }
        ci.cancel();
        Collection<ResourceLocation> allPossibleResources = this.generateResourceCache().getResources(type, namespace, path, Integer.MAX_VALUE, p -> true);
        NewResourcePackAdapter.sendToOutput(location -> {
            Path target = this.resolve(ForgePathPackResourcesMixin.getPathFromLocation(location.m_135815_().startsWith("lang/") ? PackType.CLIENT_RESOURCES : type, location));
            return () -> Files.newInputStream(target, new OpenOption[0]);
        }, resourceOutput, allPossibleResources);
    }
}

