/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.PacketReturnInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetInfo {
    private ResourceKey<Level> dim;
    private BlockPos pos;
    private ProbeMode mode;
    private Direction sideHit;
    private Vec3 hitVec;
    @Nonnull
    private ItemStack pickBlock;

    public PacketGetInfo(FriendlyByteBuf buf) {
        this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        this.pos = buf.m_130135_();
        this.mode = ProbeMode.values()[buf.readByte()];
        byte sideByte = buf.readByte();
        this.sideHit = sideByte == 127 ? null : Direction.values()[sideByte];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        this.pickBlock = buf.m_130267_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.dim.m_135782_());
        buf.m_130064_(this.pos);
        buf.writeByte(this.mode.ordinal());
        buf.writeByte(this.sideHit == null ? 127 : this.sideHit.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.f_82479_);
            buf.writeDouble(this.hitVec.f_82480_);
            buf.writeDouble(this.hitVec.f_82481_);
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130055_(this.pickBlock);
        if (buffer.writerIndex() <= (Integer)Config.maxPacketToServer.get()) {
            buf.writeBytes((ByteBuf)buffer);
        } else {
            ItemStack copy = new ItemStack((ItemLike)this.pickBlock.m_41720_(), this.pickBlock.m_41613_());
            buf.m_130055_(copy);
        }
    }

    public PacketGetInfo() {
    }

    public PacketGetInfo(ResourceKey<Level> dim, BlockPos pos, ProbeMode mode, HitResult mouseOver, @Nonnull ItemStack pickBlock) {
        this.dim = dim;
        this.pos = pos;
        this.mode = mode;
        this.sideHit = ((BlockHitResult)mouseOver).m_82434_();
        this.hitVec = mouseOver.m_82450_();
        this.pickBlock = pickBlock;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerLevel world = ((NetworkEvent.Context)ctx.get()).getSender().f_8924_.m_129880_(this.dim);
            if (world != null) {
                ProbeInfo probeInfo = PacketGetInfo.getProbeInfo((Player)((NetworkEvent.Context)ctx.get()).getSender(), this.mode, (Level)world, this.pos, this.sideHit, this.hitVec, this.pickBlock);
                PacketHandler.INSTANCE.sendTo((Object)new PacketReturnInfo(this.dim, this.pos, probeInfo), ((NetworkEvent.Context)ctx.get()).getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ProbeInfo getProbeInfo(Player player, ProbeMode mode, Level world, BlockPos blockPos, Direction sideHit, Vec3 hitVec, @Nonnull ItemStack pickBlock) {
        if ((Integer)Config.needsProbe.get() == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if ((Integer)Config.needsProbe.get() == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        if (world.m_46805_(blockPos)) {
            BlockState state = world.m_8055_(blockPos);
            ProbeHitData data = new ProbeHitData(blockPos, hitVec, sideHit, pickBlock);
            IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
            List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
            for (IProbeConfigProvider configProvider : configProviders) {
                configProvider.getProbeConfig(probeConfig, player, world, state, data);
            }
            Config.setRealConfig(probeConfig);
            List<IProbeInfoProvider> providers = TheOneProbe.theOneProbeImp.getProviders();
            for (IProbeInfoProvider provider : providers) {
                try {
                    provider.addProbeInfo(mode, probeInfo, player, world, state, data);
                }
                catch (Throwable e) {
                    ThrowableIdentity.registerThrowable(e);
                    probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text(provider.getID().toString()));
                }
            }
        } else {
            probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Error: ").style(TextStyleClass.ERROR).text("Chunk not loaded!"));
        }
        return probeInfo;
    }
}

