/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void renderEntity(Entity entity, PoseStack matrixStack, int xPos, int yPos, float scale) {
        matrixStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_252880_((float)(xPos + 8), (float)(yPos + 24), 50.0f);
        matrixStack.m_85841_(-scale, scale, scale);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(135.0f));
        Lighting.m_166384_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(rot));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
        if (!(entity instanceof Player)) {
            entity.m_146926_(0.0f);
            entity.f_19860_ = 0.0f;
            entity.m_146922_(0.0f);
            entity.f_19859_ = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.f_20884_ = 0.0f;
                livingEntity.f_20883_ = 0.0f;
                livingEntity.f_20885_ = 0.0f;
                livingEntity.f_20886_ = 0.0f;
            }
        }
        float ridingOffset = entity.m_20202_() == null ? 0.0f : (float)entity.m_6049_();
        matrixStack.m_252880_(0.0f, ridingOffset + (entity instanceof HangingEntity ? 0.5f : 0.0f), 0.0f);
        RenderSystem.m_157182_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        try {
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            dispatcher.m_114468_(false);
            dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
            buffer.m_109911_();
        }
        catch (Exception e) {
            TheOneProbe.logger.error("Error rendering entity!", (Throwable)e);
        }
        dispatcher.m_114468_(true);
        Lighting.m_84931_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void drawHorizontalLine(PoseStack matrixStack, int x1, int y1, int x2, int color) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(PoseStack matrixStack, int x1, int y1, int y2, int color) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawThickBeveledBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        float zLevel = 0.01f;
        float f = 1.0f / (float)twidth;
        float f1 = 1.0f / (float)theight;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * f, (float)(v + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * f, (float)v * f1).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * f, (float)v * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * f, (float)(v + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * f, (float)v * f1).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * f, (float)v * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, TextureAtlasSprite sprite, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        float u2 = sprite.m_118410_();
        float v2 = sprite.m_118412_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_(u1, v1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_(u1, v2).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_(u2, v2).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_(u2, v1).m_5752_();
        tessellator.m_85914_();
    }

    public static boolean renderItemStack(Minecraft mc, ItemRenderer itemRender, ItemStack itm, PoseStack matrixStack, int x, int y, String txt) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = true;
        if (!itm.m_41619_() && itm.m_41720_() != null) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 32.0f);
            RenderSystem.m_157182_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int short1 = 240;
            int short2 = 240;
            Lighting.m_84931_();
            try {
                itemRender.m_274369_(matrixStack, itm, x, y);
                RenderHelper.renderItemStackOverlay(matrixStack, mc.f_91062_, itm, x, y, txt, txt.length() - 2);
            }
            catch (Exception e) {
                ThrowableIdentity.registerThrowable(e);
                rc = false;
            }
            matrixStack.m_85849_();
            RenderSystem.m_157182_();
        }
        return rc;
    }

    public static void renderItemStackOverlay(PoseStack matrixStack, Font fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (!stack.m_41619_()) {
            LocalPlayer playerEntitysp;
            float f;
            if (stack.m_41613_() != 1 || text != null) {
                Object s;
                Object object = s = text == null ? String.valueOf(stack.m_41613_()) : text;
                if (text == null && stack.m_41613_() < 1) {
                    s = ChatFormatting.RED + String.valueOf(stack.m_41613_());
                }
                matrixStack.m_85837_(0.0, 0.0, 200.0);
                RenderSystem.m_69465_();
                RenderSystem.m_69461_();
                if (scaled >= 2) {
                    matrixStack.m_85836_();
                    matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                    fr.m_92750_(matrixStack, (String)s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.m_92895_((String)s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    matrixStack.m_85849_();
                } else if (scaled == 1) {
                    matrixStack.m_85836_();
                    matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
                    fr.m_92750_(matrixStack, (String)s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.m_92895_((String)s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    matrixStack.m_85849_();
                } else {
                    fr.m_92750_(matrixStack, (String)s, (float)(xPosition + 19 - 2 - fr.m_92895_((String)s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                RenderSystem.m_69482_();
                RenderSystem.m_69478_();
            }
            if (stack.m_41720_().m_142522_(stack)) {
                double health = stack.m_41720_().m_142158_(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.m_41720_().m_142159_(stack);
                RenderSystem.m_69465_();
                RenderSystem.m_69461_();
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder vertexbuffer = tessellator.m_85915_();
                Matrix4f matrix = matrixStack.m_85850_().m_252922_();
                RenderHelper.draw(vertexbuffer, matrix, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(vertexbuffer, matrix, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(vertexbuffer, matrix, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69482_();
            }
            float f2 = f = (playerEntitysp = Minecraft.m_91087_().f_91074_) == null ? 0.0f : playerEntitysp.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f > 0.0f) {
                RenderSystem.m_69465_();
                Tesselator tessellator1 = Tesselator.m_85913_();
                BufferBuilder vertexbuffer1 = tessellator1.m_85915_();
                RenderHelper.draw(vertexbuffer1, matrixStack.m_85850_().m_252922_(), xPosition, yPosition + (int)Math.floor(16.0f * (1.0f - f)), 16, (int)Math.ceil(16.0f * f), 255, 255, 255, 127);
                RenderSystem.m_69482_();
            }
        }
    }

    private static void draw(BufferBuilder renderer, Matrix4f matrix, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_252986_(matrix, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static int renderText(Minecraft mc, PoseStack matrixStack, int x, int y, String txt) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, 32.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.m_84931_();
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        int width = mc.f_91062_.m_92895_(txt);
        mc.f_91062_.m_92750_(matrixStack, txt, (float)x, (float)y, 0xFFFFFF);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        matrixStack.m_85849_();
        return width;
    }

    public static int renderText(Minecraft mc, PoseStack stack, int x, int y, Component text) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 32.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.m_84931_();
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        int width = mc.f_91062_.m_92724_(text.m_7532_());
        mc.f_91062_.m_92744_(stack, text.m_7532_(), (float)x, (float)y, 0xFFFFFF);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        stack.m_85849_();
        return width;
    }

    private static Vector cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public record Vector(float x, float y, float z) {
        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

