/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.events;

import de.cadentem.cave_dweller.CaveDweller;
import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cave_dweller", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    private static final ConcurrentHashMap<Integer, Integer> HIT_COUNTER = new ConcurrentHashMap();

    @SubscribeEvent
    public static void handleHurt(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof CaveDwellerEntity) {
            CaveDwellerEntity caveDweller = (CaveDwellerEntity)entity;
            if (event.getSource().m_276093_(DamageTypes.f_268722_) || event.getSource().m_276093_(DamageTypes.f_268724_) || event.getSource().m_276093_(DamageTypes.f_268612_)) {
                HIT_COUNTER.merge(caveDweller.m_19879_(), 1, Integer::sum);
                if (HIT_COUNTER.get(caveDweller.m_19879_()) > 5) {
                    HIT_COUNTER.remove(caveDweller.m_19879_());
                    boolean couldTeleport = caveDweller.teleportToTarget();
                    if (!couldTeleport) {
                        String key = caveDweller.f_19853_.m_46472_().m_135782_().toString();
                        if (ServerConfig.isValidDimension(key)) {
                            int spawnDelta = (int)((double)((Integer)ServerConfig.CAN_SPAWN_MIN.get()).intValue() * 0.3);
                            int noiseDelta = (int)((double)((Integer)ServerConfig.RESET_NOISE_MIN.get()).intValue() * 0.3);
                            CaveDweller.speedUpTimers(key, spawnDelta, noiseDelta);
                        }
                        caveDweller.disappear();
                    }
                }
                event.setCanceled(true);
            } else if (event.getSource().m_276093_(DamageTypes.f_268671_)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleDimensionChange(EntityTravelToDimensionEvent event) {
        CaveDweller.RELOAD_MISSING = true;
    }

    @SubscribeEvent
    public static void handleKnockback(LivingKnockBackEvent event) {
        CaveDwellerEntity caveDweller;
        LivingEntity entity = event.getEntity();
        if (entity instanceof CaveDwellerEntity && (caveDweller = (CaveDwellerEntity)entity).isClimbing()) {
            event.setCanceled(true);
        }
    }
}

