/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.grindenc.mixin;

import com.dplayend.grindenc.handler.HandlerConfigCommon;
import com.dplayend.grindenc.handler.HandlerGrindstoneMenu;
import com.dplayend.grindenc.handler.HandlerTaxFreeLevels;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GrindstoneMenu.class})
public abstract class MixGrindstoneMenu
extends AbstractContainerMenu
implements HandlerGrindstoneMenu {
    @Shadow
    @Final
    Container f_39560_;
    @Shadow
    @Final
    private Container f_39559_;
    @Unique
    private Player this$player;

    protected MixGrindstoneMenu(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    private void onReturnConstructor(int syncId, Inventory playerInventory, ContainerLevelAccess container, CallbackInfo info) {
        this.this$player = playerInventory.f_35978_;
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void createResult(CallbackInfo info) {
        ItemStack itemStack1 = this.f_39560_.m_8020_(0);
        ItemStack itemStack2 = this.f_39560_.m_8020_(1);
        boolean mayPickUp = this.this$mayPickUp(itemStack1);
        if (itemStack2.m_150930_(Items.f_42517_) && !itemStack2.m_41793_() && itemStack1.m_41613_() == 1) {
            info.cancel();
            if (mayPickUp) {
                this.f_39559_.m_6836_(0, this.this$transferEnchantmentToBook(itemStack1, 0));
            } else {
                this.f_39559_.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public ItemStack this$transferEnchantmentToBook(ItemStack source, int row) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)source);
        Enchantment enchantment = (Enchantment)enchantmentMap.keySet().stream().toList().get(row);
        int level = (Integer)enchantmentMap.get(enchantment);
        if (!this.this$hasCurse(source, row)) {
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        } else {
            stack = ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public boolean this$mayPickUp(ItemStack source) {
        if (source.m_41793_() || source.m_150930_(Items.f_42690_) && EnchantmentHelper.m_44831_((ItemStack)source).size() > 1) {
            if (this.this$player.m_7500_() || ((HandlerConfigCommon.costType)((Object)HandlerConfigCommon.xpCostType.get())).equals((Object)HandlerConfigCommon.costType.NO_COST)) {
                return true;
            }
            if (this.this$getXpCost(source, 0) > 0) {
                return this.this$player.f_36078_ >= this.this$getXpCost(source, 0);
            }
        }
        return false;
    }

    @Override
    public boolean this$hasCurse(ItemStack source, int row) {
        if (((Boolean)HandlerConfigCommon.allowCurses.get()).booleanValue()) {
            return (Boolean)HandlerConfigCommon.allowCurses.get() == false;
        }
        if (EnchantmentHelper.m_44831_((ItemStack)source).size() > row) {
            return ((Enchantment)EnchantmentHelper.m_44831_((ItemStack)source).keySet().stream().toList().get(row)).m_6589_();
        }
        return false;
    }

    @Override
    public int this$getXpCost(ItemStack source, int row) {
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)source);
        if (!enchantmentMap.isEmpty()) {
            if (source.m_150930_(Items.f_42690_) && enchantmentMap.size() < 2 || this.this$hasCurse(source, row)) {
                return 0;
            }
            if (((HandlerConfigCommon.costType)((Object)HandlerConfigCommon.xpCostType.get())).equals((Object)HandlerConfigCommon.costType.SPECIFIC_COST)) {
                return (Integer)HandlerConfigCommon.specificCostValue.get();
            }
            Enchantment enchantment = (Enchantment)enchantmentMap.keySet().stream().toList().get(row);
            int level = (Integer)enchantmentMap.get(enchantment);
            int k3 = switch (enchantment.m_44699_()) {
                default -> throw new IncompatibleClassChangeError();
                case Enchantment.Rarity.COMMON -> 1;
                case Enchantment.Rarity.UNCOMMON -> 2;
                case Enchantment.Rarity.RARE -> 4;
                case Enchantment.Rarity.VERY_RARE -> 8;
            };
            k3 = Math.max(1, k3 / 2);
            return k3 * level;
        }
        return 0;
    }

    @Mixin(targets={"net/minecraft/world/inventory/GrindstoneMenu$2"})
    public static abstract class Mix2
    extends Slot {
        public Mix2(Container inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return true;
        }
    }

    @Mixin(targets={"net/minecraft/world/inventory/GrindstoneMenu$3"})
    public static abstract class Mix3
    extends Slot {
        public Mix3(Container inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return true;
        }
    }

    @Mixin(targets={"net/minecraft/world/inventory/GrindstoneMenu$4"})
    public static abstract class Mix4
    extends Slot {
        public Mix4(Container inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
        public void onTake(Player player, ItemStack stack, CallbackInfo info) {
            ItemStack itemStack1 = player.f_36096_.m_38853_(0).m_7993_();
            ItemStack itemStack2 = player.f_36096_.m_38853_(1).m_7993_();
            Slot result = player.f_36096_.m_38853_(2);
            int xpCost = ((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(itemStack1, 0);
            if (itemStack2.m_150930_(Items.f_42517_) && !itemStack2.m_41793_() && itemStack1.m_41613_() == 1) {
                info.cancel();
                if (this.this$mayPickUp(player, itemStack1)) {
                    this.this$onTakeSoundEffect(player.f_19853_, player.m_20183_());
                    int repairCost = itemStack1.m_41784_().m_128451_("RepairCost");
                    if (repairCost > 1) {
                        itemStack1.m_41784_().m_128405_("RepairCost", repairCost - (repairCost + 1) / 2);
                    } else {
                        itemStack1.m_41749_("RepairCost");
                    }
                    if (itemStack2.m_41613_() > 0) {
                        if (itemStack1.m_41793_() && itemStack1.m_41784_().m_128437_("Enchantments", 10).size() > 1) {
                            result.m_5852_(((HandlerGrindstoneMenu)player.f_36096_).this$transferEnchantmentToBook(itemStack1, 1));
                            if (!player.m_7500_() && player.f_36078_ - ((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(itemStack1, 1) < ((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(itemStack1, 0)) {
                                result.m_5852_(ItemStack.f_41583_);
                            }
                            itemStack1.m_41784_().m_128437_("Enchantments", 10).remove(0);
                        } else if (itemStack1.m_41793_()) {
                            player.f_36096_.m_38853_(0).m_5852_(this.this$blankItem(itemStack1));
                        }
                        if (itemStack1.m_150930_(Items.f_42690_) && itemStack1.m_41784_().m_128437_("StoredEnchantments", 10).size() > 1) {
                            result.m_5852_(((HandlerGrindstoneMenu)player.f_36096_).this$transferEnchantmentToBook(itemStack1, 1));
                            if (!player.m_7500_() && player.f_36078_ - ((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(itemStack1, 1) < ((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(itemStack1, 0) || itemStack1.m_41784_().m_128437_("StoredEnchantments", 10).size() == 2) {
                                result.m_5852_(ItemStack.f_41583_);
                            }
                            itemStack1.m_41784_().m_128437_("StoredEnchantments", 10).remove(0);
                        }
                        itemStack2.m_41764_(itemStack2.m_41613_() - 1);
                        if (itemStack2.m_41613_() == 0) {
                            if (itemStack1.m_41793_()) {
                                result.m_5852_(this.this$blankItem(itemStack1));
                            }
                            if (itemStack1.m_150930_(Items.f_42690_)) {
                                result.m_5852_(new ItemStack((ItemLike)Items.f_42517_));
                            }
                        }
                    } else {
                        player.f_36096_.m_38853_(1).m_5852_(ItemStack.f_41583_);
                    }
                    if ((Integer)HandlerConfigCommon.damagePercentValue.get() > 0) {
                        double damage = (double)itemStack1.m_41776_() / 100.0 * (double)((Integer)HandlerConfigCommon.damagePercentValue.get()).intValue();
                        itemStack1.m_41721_((int)((double)itemStack1.m_41773_() + damage));
                        if (itemStack1.m_41773_() > itemStack1.m_41776_() || (Integer)HandlerConfigCommon.damagePercentValue.get() == 100) {
                            player.f_36096_.m_38853_(0).m_5852_(ItemStack.f_41583_);
                        }
                    }
                    if (!((HandlerConfigCommon.costType)((Object)HandlerConfigCommon.xpCostType.get())).equals((Object)HandlerConfigCommon.costType.NO_COST) && !player.m_7500_()) {
                        if (HandlerTaxFreeLevels.isModLoaded() && ((Boolean)HandlerConfigCommon.taxFreeLevelsCompatibility.get()).booleanValue()) {
                            player.m_6756_(-HandlerTaxFreeLevels.getPointsFromLevel(xpCost));
                        } else {
                            player.m_6749_(-xpCost);
                        }
                    }
                } else {
                    result.m_5852_(ItemStack.f_41583_);
                }
            }
        }

        @Unique
        public boolean this$mayPickUp(Player player, ItemStack source) {
            if (source.m_41793_() || source.m_150930_(Items.f_42690_) && EnchantmentHelper.m_44831_((ItemStack)source).size() > 1) {
                if (player.m_7500_() || ((HandlerConfigCommon.costType)((Object)HandlerConfigCommon.xpCostType.get())).equals((Object)HandlerConfigCommon.costType.NO_COST)) {
                    return true;
                }
                if (((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(source, 0) > 0) {
                    return player.f_36078_ >= ((HandlerGrindstoneMenu)player.f_36096_).this$getXpCost(source, 0);
                }
            }
            return false;
        }

        @Unique
        private ItemStack this$blankItem(ItemStack source) {
            ItemStack stack = source.m_41777_();
            stack.m_41785_().clear();
            return stack;
        }

        @Unique
        private void this$onTakeSoundEffect(Level level, BlockPos pos) {
            if (!level.f_46443_) {
                level.m_5594_(null, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 4.0f, 1.0f);
            }
        }
    }
}

