/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class Fertilizer
extends TrinketItem<Stats>
implements ICurioItem {
    public static Fertilizer INSTANCE;

    public Fertilizer() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void function(TickEvent.PlayerTickEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            Optional stack0;
            Player player = event.player;
            Level world = player.f_19853_;
            Random random = new Random();
            float rx = random.nextFloat() * 5.0f - 3.0f;
            float rz = random.nextFloat() * 5.0f - 3.0f;
            float ry = random.nextFloat() * 2.0f - 2.0f;
            float ry0 = random.nextFloat() * 2.0f;
            if (player instanceof ServerPlayer && !player.m_5833_() && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.FERTILIZER.get())).isPresent() && !player.f_19853_.f_46443_) {
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.5, 1.0, 0.5, 0.1);
                BlockPos posBelow = player.m_20183_().m_7495_();
                BlockState blockStateBelow = player.f_19853_.m_8055_(posBelow);
                Block below = blockStateBelow.m_60734_();
                if (below == Blocks.f_50440_) {
                    BonemealableBlock igrowable;
                    Block block;
                    BlockState blockstate;
                    BlockPos pos = new BlockPos((int)((float)player.m_20183_().m_123341_() + rx), (int)((float)player.m_20183_().m_123342_() + ry), (int)((float)player.m_20183_().m_123343_() + rz));
                    int hook = Fertilizer.onApplyBonemeal(player, world, pos, blockstate = world.m_8055_(pos), ((SlotResult)stack0.get()).stack());
                    if (hook == 0 && (block = blockstate.m_60734_()) instanceof BonemealableBlock && (igrowable = (BonemealableBlock)block).m_7370_((LevelReader)world, pos, blockstate, world.f_46443_) && world instanceof ServerLevel && igrowable.m_214167_(world, world.f_46441_, pos, blockstate)) {
                        igrowable.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                    }
                } else {
                    BonemealableBlock igrowable;
                    Block block;
                    BlockState blockstate;
                    BlockPos pos = new BlockPos((int)((float)player.m_20183_().m_123341_() + rx), (int)((float)player.m_20183_().m_123342_() + ry0), (int)((float)player.m_20183_().m_123343_() + rz));
                    int hook = Fertilizer.onApplyBonemeal(player, world, pos, blockstate = world.m_8055_(pos), ((SlotResult)stack0.get()).stack());
                    if (hook == 0 && (block = blockstate.m_60734_()) instanceof BonemealableBlock && (igrowable = (BonemealableBlock)block).m_7370_((LevelReader)world, pos, blockstate, world.f_46443_) && world instanceof ServerLevel && igrowable.m_214167_(world, world.f_46441_, pos, blockstate)) {
                        igrowable.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                    }
                }
            }
        }
    }

    public static int onApplyBonemeal(@Nonnull Player player, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ItemStack stack) {
        BonemealEvent event = new BonemealEvent(player, level, pos, state, stack);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return 1;
        }
        return 0;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.FERTILIZER.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.fertilizer_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.fertilizer_1").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public boolean isEnable = true;
    }
}

