/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.other;

import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.LogicModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;

public class LogicSlotGame
extends LogicModule {
    public int wheelSTOP;
    public float[] wheelPos = new float[3];
    public boolean[] lines = new boolean[5];
    public int[] lights = new int[5];
    public float[] speed = new float[3];
    public final int[] multi = new int[6];
    private int lightUp = 0;
    private final float speedUP = 0.7f;
    private final float speedDOWN = 1.2f;
    private final float speedMAX = 16.0f;
    private int pullTimer = 0;

    public LogicSlotGame(int tableID, Item module) {
        super(tableID, 9, 3);
        this.scoreLives = 1;
        this.createSlotWheels(this.moduleToInt(module) % 16, this.moduleToInt(module) / 16 + 1);
        this.wheelPos[0] = 0.0f;
        this.wheelPos[1] = 0.0f;
        this.wheelPos[2] = 0.0f;
        this.multi[0] = 1;
        this.multi[1] = 10;
        this.multi[2] = 15;
        this.multi[3] = 20;
        this.multi[4] = 45;
        this.multi[5] = 77;
    }

    @Override
    public void start2() {
        this.setJingle(7);
        this.scoreLevel = 1;
        this.scoreLives = 1;
        this.wheelSTOP = -1;
        this.lines[0] = false;
        this.lines[1] = false;
        this.lines[2] = false;
        this.lines[3] = false;
        this.lines[4] = false;
        this.lights[0] = 1;
        this.lights[1] = 0;
        this.lights[2] = 0;
        this.lights[3] = 0;
        this.lights[4] = 0;
        this.speed[0] = 0.0f;
        this.speed[1] = 0.0f;
        this.speed[2] = 0.0f;
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            if (this.scoreLevel < 5) {
                this.setJingle(12);
                ++this.scoreLevel;
                this.lights[1] = this.scoreLevel >= 2 ? 1 : 0;
                this.lights[2] = this.scoreLevel >= 3 ? 1 : 0;
                this.lights[3] = this.scoreLevel >= 4 ? 1 : 0;
                this.lights[4] = this.scoreLevel >= 5 ? 1 : 0;
            } else {
                this.setJingle(6);
                this.lightUp = 15;
                this.lights[0] = 2;
                this.lights[3] = 2;
                this.lights[4] = 2;
            }
        }
        if (action == 1) {
            if (this.turnstate == 2) {
                this.turnstate = 3;
                this.setJingle(8);
                this.pull();
            } else if (this.turnstate == 3) {
                this.spin();
                this.setJingle(8);
            }
        }
    }

    @Override
    public void updateLogic() {
        if (this.wheelSTOP == -1 && this.speed[2] >= 4.0f) {
            this.wheelSTOP = 0;
        }
        if (this.wheelSTOP == 3 && this.turnstate == 3 && this.wheelPos[0] % 48.0f == 0.0f && this.wheelPos[1] % 48.0f == 0.0f && this.wheelPos[2] % 48.0f == 0.0f) {
            this.result();
        }
    }

    @Override
    public void updateMotion() {
        if (this.lightUp > 0) {
            --this.lightUp;
            this.lights[0] = this.lights[0] == 1 ? 2 : 1;
            this.lights[1] = this.lights[1] == 1 ? 2 : 1;
            this.lights[2] = this.lights[2] == 1 ? 2 : 1;
            this.lights[3] = this.lights[3] == 1 ? 2 : 1;
            int n = this.lights[4] = this.lights[4] == 1 ? 2 : 1;
            if (this.lightUp == 0) {
                this.lights[0] = 1;
                this.lights[1] = 1;
                this.lights[2] = 1;
                this.lights[3] = 1;
                this.lights[4] = 1;
            }
        }
        if (this.turnstate == 3) {
            if (this.wheelSTOP <= 0 && this.speed[0] < 16.0f) {
                this.speed[0] = this.speed[0] + 0.7f;
                if (this.speed[0] >= 16.0f) {
                    this.speed[0] = 16.0f;
                }
            }
            if (this.wheelSTOP > 0 && this.speed[0] > 1.0f) {
                this.speed[0] = this.speed[0] - 1.2f;
                if (this.speed[0] <= 1.0f) {
                    this.speed[0] = 1.0f;
                }
            }
            if (this.wheelSTOP < 1 && this.speed[1] < 16.0f && this.speed[0] >= 4.0f) {
                this.speed[1] = this.speed[1] + 0.7f;
                if (this.speed[1] >= 16.0f) {
                    this.speed[1] = 16.0f;
                }
            }
            if (this.wheelSTOP > 1 && this.speed[1] > 1.0f) {
                this.speed[1] = this.speed[1] - 1.2f;
                if (this.speed[1] <= 1.0f) {
                    this.speed[1] = 1.0f;
                }
            }
            if (this.wheelSTOP < 2 && this.speed[2] < 16.0f && this.speed[1] >= 4.0f) {
                this.speed[2] = this.speed[2] + 0.7f;
                if (this.speed[2] >= 16.0f) {
                    this.speed[2] = 16.0f;
                }
            }
            if (this.wheelSTOP > 2 && this.speed[2] > 1.0f) {
                this.speed[2] = this.speed[2] - 1.2f;
                if (this.speed[2] <= 1.0f) {
                    this.speed[2] = 1.0f;
                }
            }
        }
        this.wheelPos[0] = (this.wheelPos[0] + (float)((int)this.speed[0])) % 432.0f;
        this.wheelPos[1] = (this.wheelPos[1] + (float)((int)this.speed[1])) % 432.0f;
        this.wheelPos[2] = (this.wheelPos[2] + (float)((int)this.speed[2])) % 432.0f;
        if (this.wheelSTOP > 0 && (int)this.wheelPos[0] % 48 == 0) {
            this.wheelPos[0] = (int)this.wheelPos[0];
            this.speed[0] = 0.0f;
        }
        if (this.wheelSTOP > 1 && (int)this.wheelPos[1] % 48 == 0) {
            this.wheelPos[1] = (int)this.wheelPos[1];
            this.speed[1] = 0.0f;
        }
        if (this.wheelSTOP > 2 && (int)this.wheelPos[2] % 48 == 0) {
            this.wheelPos[2] = (int)this.wheelPos[2];
            this.speed[2] = 0.0f;
        }
        if (this.pullTimer > 0) {
            --this.pullTimer;
            if (this.pullTimer <= 0) {
                this.scoreLives = 1;
            }
        }
    }

    @Override
    public void load2(CompoundTag compound) {
        this.wheelSTOP = compound.m_128451_("wheelstop");
        this.wheelPos[0] = compound.m_128451_("wheelpos0");
        this.wheelPos[1] = compound.m_128451_("wheelpos1");
        this.wheelPos[2] = compound.m_128451_("wheelpos2");
        this.lines[0] = compound.m_128471_("lines0");
        this.lines[1] = compound.m_128471_("lines1");
        this.lines[2] = compound.m_128471_("lines2");
        this.lines[3] = compound.m_128471_("lines3");
        this.lines[4] = compound.m_128471_("lines4");
        this.lights[0] = this.scoreLevel >= 1 ? 1 : 0;
        this.lights[1] = this.scoreLevel >= 2 ? 1 : 0;
        this.lights[2] = this.scoreLevel >= 3 ? 1 : 0;
        this.lights[3] = this.scoreLevel >= 4 ? 1 : 0;
        this.lights[4] = this.scoreLevel >= 5 ? 1 : 0;
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        compound.m_128405_("wheelstop", this.wheelSTOP);
        compound.m_128350_("wheelpos0", this.wheelPos[0]);
        compound.m_128350_("wheelpos1", this.wheelPos[1]);
        compound.m_128350_("wheelpos2", this.wheelPos[2]);
        compound.m_128379_("lines0", this.lines[0]);
        compound.m_128379_("lines1", this.lines[1]);
        compound.m_128379_("lines2", this.lines[2]);
        compound.m_128379_("lines3", this.lines[3]);
        compound.m_128379_("lines4", this.lines[4]);
        return compound;
    }

    private void spin() {
        if (this.wheelSTOP >= 0 && this.wheelSTOP < 3) {
            ++this.wheelSTOP;
            this.pull();
        }
    }

    private void pull() {
        this.pullTimer = 6;
        this.scoreLives = 2;
    }

    private void result() {
        this.lights[0] = 0;
        this.lights[1] = 0;
        this.lights[2] = 0;
        this.lights[3] = 0;
        this.lights[4] = 0;
        int pos0 = (int)this.wheelPos[0] / 48;
        int pos1 = (int)this.wheelPos[1] / 48;
        int pos2 = (int)this.wheelPos[2] / 48;
        if (this.scoreLevel >= 1) {
            this.checkWheel(this.grid[(pos0 + 9) % 9][0], this.grid[(pos1 + 9) % 9][1], this.grid[(pos2 + 9) % 9][2], 0);
        }
        if (this.scoreLevel >= 2) {
            this.checkWheel(this.grid[(pos0 + 8) % 9][0], this.grid[(pos1 + 8) % 9][1], this.grid[(pos2 + 8) % 9][2], 1);
        }
        if (this.scoreLevel >= 3) {
            this.checkWheel(this.grid[(pos0 + 10) % 9][0], this.grid[(pos1 + 10) % 9][1], this.grid[(pos2 + 10) % 9][2], 2);
        }
        if (this.scoreLevel >= 4) {
            this.checkWheel(this.grid[(pos0 + 8) % 9][0], this.grid[(pos1 + 9) % 9][1], this.grid[(pos2 + 10) % 9][2], 3);
        }
        if (this.scoreLevel >= 5) {
            this.checkWheel(this.grid[(pos0 + 10) % 9][0], this.grid[(pos1 + 9) % 9][1], this.grid[(pos2 + 8) % 9][2], 4);
        }
        this.turnstate = 4;
        if (this.reward[0] >= 2) {
            this.jingle = 10;
        }
    }

    private void checkWheel(int wheel0, int wheel1, int wheel2, int index) {
        boolean found = false;
        if (wheel0 == 0) {
            this.reward[0] = this.reward[0] + this.multi[0];
            found = true;
        }
        if (wheel1 == 0) {
            this.reward[0] = this.reward[0] + this.multi[0];
            found = true;
        }
        if (wheel2 == 0) {
            this.reward[0] = this.reward[0] + this.multi[0];
            found = true;
        }
        if (wheel0 == 2 && wheel1 == 2 && wheel2 == 2) {
            this.reward[0] = this.reward[0] + this.multi[1];
            found = true;
        }
        if (wheel0 == 3 && wheel1 == 3 && wheel2 == 3) {
            this.reward[0] = this.reward[0] + this.multi[2];
            found = true;
        }
        if (wheel0 == 4 && wheel1 == 4 && wheel2 == 4) {
            this.reward[0] = this.reward[0] + this.multi[3];
            found = true;
        }
        if (wheel0 == 5 && wheel1 == 5 && wheel2 == 5) {
            this.reward[0] = this.reward[0] + this.multi[4];
            found = true;
        }
        if (wheel0 == 1 && wheel1 == 1 && wheel2 == 1) {
            this.reward[0] = this.reward[0] + this.multi[5];
            found = true;
        }
        if (found) {
            this.lines[index] = true;
            this.lights[index] = 2;
        }
    }

    private void createSlotWheels(int index, int mod) {
        for (int y = 0; y < 3; ++y) {
            int mod2 = y == 1 ? mod * 2 : (y == 2 ? -(mod * 2) : 0);
            int[] temp = this.getWheel((index + mod2 + 16) % 16);
            for (int x = 0; x < 9; ++x) {
                this.grid[x][y] = temp[x];
            }
        }
    }

    private int[] getWheel(int index) {
        this.scoreLives = 1;
        if (index == 0) {
            return new int[]{5, 4, 0, 1, 2, 3, 1, 2, 0};
        }
        if (index == 1) {
            return new int[]{5, 0, 4, 1, 2, 1, 3, 2, 0};
        }
        if (index == 2) {
            return new int[]{5, 0, 1, 4, 2, 1, 2, 3, 0};
        }
        if (index == 3) {
            return new int[]{5, 0, 1, 2, 4, 1, 2, 0, 3};
        }
        if (index == 4) {
            return new int[]{5, 3, 1, 2, 0, 4, 2, 0, 1};
        }
        if (index == 5) {
            return new int[]{5, 1, 3, 2, 0, 2, 4, 0, 1};
        }
        if (index == 6) {
            return new int[]{5, 1, 2, 3, 0, 2, 0, 4, 1};
        }
        if (index == 7) {
            return new int[]{5, 1, 2, 0, 3, 2, 0, 1, 4};
        }
        if (index == 8) {
            return new int[]{5, 3, 2, 0, 1, 4, 0, 1, 2};
        }
        if (index == 9) {
            return new int[]{5, 2, 3, 0, 1, 0, 4, 1, 2};
        }
        if (index == 10) {
            return new int[]{5, 2, 0, 3, 1, 0, 1, 4, 2};
        }
        if (index == 11) {
            return new int[]{5, 2, 0, 1, 3, 0, 1, 2, 4};
        }
        if (index == 12) {
            return new int[]{5, 4, 0, 1, 2, 3, 1, 2, 0};
        }
        if (index == 13) {
            return new int[]{5, 0, 4, 1, 2, 1, 3, 2, 0};
        }
        if (index == 14) {
            return new int[]{5, 0, 1, 4, 2, 1, 2, 3, 0};
        }
        if (index == 15) {
            return new int[]{5, 0, 1, 2, 4, 1, 2, 0, 3};
        }
        this.scoreLives = 0;
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private int moduleToInt(Item module) {
        if (module == CasinoKeeper.MODULE_CARD_WHITE.get()) {
            return 0;
        }
        if (module == CasinoKeeper.MODULE_CARD_ORANGE.get()) {
            return 1;
        }
        if (module == CasinoKeeper.MODULE_CARD_MAGENTA.get()) {
            return 2;
        }
        if (module == CasinoKeeper.MODULE_CARD_LIGHT_BLUE.get()) {
            return 3;
        }
        if (module == CasinoKeeper.MODULE_CARD_YELLOW.get()) {
            return 4;
        }
        if (module == CasinoKeeper.MODULE_CARD_LIME.get()) {
            return 5;
        }
        if (module == CasinoKeeper.MODULE_CARD_PINK.get()) {
            return 6;
        }
        if (module == CasinoKeeper.MODULE_CARD_GRAY.get()) {
            return 7;
        }
        if (module == CasinoKeeper.MODULE_CARD_LIGHT_GRAY.get()) {
            return 8;
        }
        if (module == CasinoKeeper.MODULE_CARD_CYAN.get()) {
            return 9;
        }
        if (module == CasinoKeeper.MODULE_CARD_PURPLE.get()) {
            return 10;
        }
        if (module == CasinoKeeper.MODULE_CARD_BLUE.get()) {
            return 11;
        }
        if (module == CasinoKeeper.MODULE_CARD_BROWN.get()) {
            return 12;
        }
        if (module == CasinoKeeper.MODULE_CARD_GREEN.get()) {
            return 13;
        }
        if (module == CasinoKeeper.MODULE_CARD_RED.get()) {
            return 14;
        }
        if (module == CasinoKeeper.MODULE_CARD_BLACK.get()) {
            return 15;
        }
        if (module == CasinoKeeper.MODULE_MINO_WHITE.get()) {
            return 16;
        }
        if (module == CasinoKeeper.MODULE_MINO_ORANGE.get()) {
            return 17;
        }
        if (module == CasinoKeeper.MODULE_MINO_MAGENTA.get()) {
            return 18;
        }
        if (module == CasinoKeeper.MODULE_MINO_LIGHT_BLUE.get()) {
            return 19;
        }
        if (module == CasinoKeeper.MODULE_MINO_YELLOW.get()) {
            return 20;
        }
        if (module == CasinoKeeper.MODULE_MINO_LIME.get()) {
            return 21;
        }
        if (module == CasinoKeeper.MODULE_MINO_PINK.get()) {
            return 22;
        }
        if (module == CasinoKeeper.MODULE_MINO_GRAY.get()) {
            return 23;
        }
        if (module == CasinoKeeper.MODULE_MINO_LIGHT_GRAY.get()) {
            return 24;
        }
        if (module == CasinoKeeper.MODULE_MINO_CYAN.get()) {
            return 25;
        }
        if (module == CasinoKeeper.MODULE_MINO_PURPLE.get()) {
            return 26;
        }
        if (module == CasinoKeeper.MODULE_MINO_BLUE.get()) {
            return 27;
        }
        if (module == CasinoKeeper.MODULE_MINO_BROWN.get()) {
            return 28;
        }
        if (module == CasinoKeeper.MODULE_MINO_GREEN.get()) {
            return 29;
        }
        if (module == CasinoKeeper.MODULE_MINO_RED.get()) {
            return 30;
        }
        if (module == CasinoKeeper.MODULE_MINO_BLACK.get()) {
            return 31;
        }
        if (module == CasinoKeeper.MODULE_CHIP_WHITE.get()) {
            return 32;
        }
        if (module == CasinoKeeper.MODULE_CHIP_ORANGE.get()) {
            return 33;
        }
        if (module == CasinoKeeper.MODULE_CHIP_MAGENTA.get()) {
            return 34;
        }
        if (module == CasinoKeeper.MODULE_CHIP_LIGHT_BLUE.get()) {
            return 35;
        }
        if (module == CasinoKeeper.MODULE_CHIP_YELLOW.get()) {
            return 36;
        }
        if (module == CasinoKeeper.MODULE_CHIP_LIME.get()) {
            return 37;
        }
        if (module == CasinoKeeper.MODULE_CHIP_PINK.get()) {
            return 38;
        }
        if (module == CasinoKeeper.MODULE_CHIP_GRAY.get()) {
            return 39;
        }
        if (module == CasinoKeeper.MODULE_CHIP_LIGHT_GRAY.get()) {
            return 40;
        }
        if (module == CasinoKeeper.MODULE_CHIP_CYAN.get()) {
            return 41;
        }
        if (module == CasinoKeeper.MODULE_CHIP_PURPLE.get()) {
            return 42;
        }
        if (module == CasinoKeeper.MODULE_CHIP_BLUE.get()) {
            return 43;
        }
        if (module == CasinoKeeper.MODULE_CHIP_BROWN.get()) {
            return 44;
        }
        if (module == CasinoKeeper.MODULE_CHIP_GREEN.get()) {
            return 45;
        }
        if (module == CasinoKeeper.MODULE_CHIP_RED.get()) {
            return 46;
        }
        if (module == CasinoKeeper.MODULE_CHIP_BLACK.get()) {
            return 47;
        }
        return 0;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 49;
    }
}

