/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.Config;
import mod.casinocraft.menu.MenuMachine;
import mod.casinocraft.network.MessageSettingServer;
import mod.casinocraft.network.MessageStateServer;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.lucky77.menu.MenuBase;
import mod.lucky77.screen.ScreenBase;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public class ScreenMachine
extends ScreenBase<MenuMachine> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("casinocraft:textures/gui/inventory.png");
    private int page = 0;
    private int activeInput = 0;
    private String input = "";
    private boolean hasReset = false;
    private int highlightIndex = 0;
    private int highlightTimer = 0;
    private int blinking = 0;

    public ScreenMachine(MenuMachine container, Inventory player, Component name) {
        super((MenuBase)container, player, name, 176, 178);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        this.keyTyped(keyCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        boolean handled = this.m_97805_(keyCode, scanCode);
        if (this.f_97734_ != null && this.f_97734_.m_6657_()) {
            if (this.f_96541_.f_91066_.f_92097_.isActiveAndMatches(mouseKey)) {
                this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, 0, ClickType.CLONE);
                handled = true;
            } else if (this.f_96541_.f_91066_.f_92094_.isActiveAndMatches(mouseKey)) {
                this.m_6597_(this.f_97734_, this.f_97734_.f_40219_, ScreenMachine.m_96637_() ? 1 : 0, ClickType.THROW);
                handled = true;
            }
        } else if (this.f_96541_.f_91066_.f_92094_.isActiveAndMatches(mouseKey)) {
            handled = true;
        }
        return handled;
    }

    private void keyTyped(int keyCode) {
        if (this.activeInput > 0) {
            if (keyCode == 257) {
                if (this.input.length() == 0) {
                    this.input = "0";
                }
                int temp = Integer.parseInt(this.input);
                this.commandSetScore(this.activeInput - 1, temp);
                this.activeInput = 0;
                this.page = 2;
            }
            if (keyCode == 259) {
                if (this.input.length() == 1) {
                    this.input = "";
                } else if (this.input.length() > 1) {
                    this.input = this.input.substring(0, this.input.length() - 1);
                }
            }
            if (keyCode == 49) {
                this.input = this.input + "1";
            }
            if (keyCode == 50) {
                this.input = this.input + "2";
            }
            if (keyCode == 51) {
                this.input = this.input + "3";
            }
            if (keyCode == 52) {
                this.input = this.input + "4";
            }
            if (keyCode == 53) {
                this.input = this.input + "5";
            }
            if (keyCode == 54) {
                this.input = this.input + "6";
            }
            if (keyCode == 55) {
                this.input = this.input + "7";
            }
            if (keyCode == 56) {
                this.input = this.input + "8";
            }
            if (keyCode == 57) {
                this.input = this.input + "9";
            }
            if (keyCode == 48) {
                this.input = this.input + "0";
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.hasKey() && this.activeInput == 0) {
            if (this.mouseRect(2, -19, 56, 24, mouseX, mouseY)) {
                this.highlight(18);
                this.commandChangePage(0);
            }
            if (this.mouseRect(58, -19, 56, 24, mouseX, mouseY) && ((MenuMachine)this.f_97732_).hasKey()) {
                this.highlight(19);
                this.commandChangePage(1);
            }
            if (this.mouseRect(114, -19, 56, 24, mouseX, mouseY) && this.hasHighscore()) {
                this.highlight(20);
                this.commandChangePage(2);
            }
            if (this.page == 0) {
                if (this.mouseRect(4, 10, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(0);
                }
                if (this.mouseRect(4, 23, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(1);
                }
                if (this.mouseRect(4, 36, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(2);
                }
                if (this.mouseRect(4, 49, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(3);
                }
                if (this.mouseRect(4, 63, 12, 12, mouseX, mouseY)) {
                    this.commandResetGameState();
                }
                if (this.mouseRect(4, 76, 12, 12, mouseX, mouseY)) {
                    this.commandToggleSettings(4);
                }
            }
            if (this.page == 1) {
                if (this.mouseRect(5, 11, 40, 20, mouseX, mouseY)) {
                    this.highlight(14);
                    this.commandTransfer(true, true);
                }
                if (this.mouseRect(122, 11, 40, 20, mouseX, mouseY)) {
                    this.highlight(15);
                    this.commandTransfer(true, false);
                }
            }
            if (this.page == 1 && ((MenuMachine)this.f_97732_).hasToken()) {
                if (this.mouseRect(137, 53, 16, 16, mouseX, mouseY)) {
                    this.highlight(1);
                    this.commandChangeBet(-1, false);
                }
                if (this.mouseRect(155, 53, 16, 16, mouseX, mouseY)) {
                    this.highlight(2);
                    this.commandChangeBet(1, false);
                }
                if (this.mouseRect(137, 71, 16, 16, mouseX, mouseY)) {
                    this.highlight(3);
                    this.commandChangeBet(-1, true);
                }
                if (this.mouseRect(155, 71, 16, 16, mouseX, mouseY)) {
                    this.highlight(4);
                    this.commandChangeBet(1, true);
                }
            }
            if (this.page == 2) {
                if (this.mouseRect(5, 11, 40, 20, mouseX, mouseY)) {
                    this.highlight(14);
                    this.commandTransfer(false, true);
                }
                if (this.mouseRect(122, 11, 40, 20, mouseX, mouseY)) {
                    this.highlight(15);
                    this.commandTransfer(false, false);
                }
            }
            if (this.page == 2 && ((MenuMachine)this.f_97732_).hasReward()) {
                if (this.mouseRect(137, 35, 16, 16, mouseX, mouseY)) {
                    this.highlight(5);
                    this.commandChangeReward(-1, 0);
                }
                if (this.mouseRect(155, 35, 16, 16, mouseX, mouseY)) {
                    this.highlight(6);
                    this.commandChangeReward(1, 0);
                }
                if (this.mouseRect(137, 53, 16, 16, mouseX, mouseY)) {
                    this.highlight(7);
                    this.commandChangeReward(-1, 1);
                }
                if (this.mouseRect(155, 53, 16, 16, mouseX, mouseY)) {
                    this.highlight(8);
                    this.commandChangeReward(1, 1);
                }
                if (this.mouseRect(137, 71, 16, 16, mouseX, mouseY)) {
                    this.highlight(9);
                    this.commandChangeReward(-1, 2);
                }
                if (this.mouseRect(155, 71, 16, 16, mouseX, mouseY)) {
                    this.highlight(10);
                    this.commandChangeReward(1, 2);
                }
                if (this.mouseRect(23, 35, 16, 16, mouseX, mouseY)) {
                    this.page = 3;
                    this.input = "";
                    this.activeInput = 1;
                }
                if (this.mouseRect(23, 53, 16, 16, mouseX, mouseY)) {
                    this.page = 3;
                    this.input = "";
                    this.activeInput = 2;
                }
                if (this.mouseRect(23, 71, 16, 16, mouseX, mouseY)) {
                    this.page = 3;
                    this.input = "";
                    this.activeInput = 3;
                }
                if (this.mouseRect(5, 35, 16, 16, mouseX, mouseY)) {
                    this.commandTogglePrize(0);
                }
                if (this.mouseRect(5, 53, 16, 16, mouseX, mouseY)) {
                    this.commandTogglePrize(1);
                }
                if (this.mouseRect(5, 71, 16, 16, mouseX, mouseY)) {
                    this.commandTogglePrize(2);
                }
            }
        }
        return false;
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        String text;
        if (!(this.page != 2 || ((MenuMachine)this.f_97732_).hasKey() && this.hasHighscore())) {
            this.page = 0;
        }
        if (!(this.page != 1 || ((MenuMachine)this.f_97732_).hasKey() && ((MenuMachine)this.f_97732_).hasModule())) {
            this.page = 0;
        }
        this.blinking = (this.blinking + 1) % 32;
        if (this.page == 0 && !((MenuMachine)this.f_97732_).hasKey()) {
            this.drawFontCenter(matrix, "VISIT MODPAGE FOR INSTRUCTIONS", 88, 16);
            if (this.blinking / 16 == 1) {
                this.drawFontCenter(matrix, "MISSING  KEY  ITEM  ", 88, 74);
            }
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey()) {
            if (((Boolean)Config.ConfigMachine.config_creative_token.get()).booleanValue() && this.isOP()) {
                this.drawFont(matrix, "INFINITE TOKEN STORAGE", 18, 13);
            }
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey()) {
            if (((Boolean)Config.ConfigMachine.config_creative_reward.get()).booleanValue() && this.isOP()) {
                this.drawFont(matrix, "INFINITE REWARD STORAGE", 18, 26);
            }
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey()) {
            this.drawFont(matrix, "DROP ITEMS ON BREAK", 18, 39);
            this.drawFont(matrix, "INDESTRUCTABLE BLOCK", 18, 52);
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey() && !((MenuMachine)this.f_97732_).hasModule() && this.blinking / 16 == 1) {
            this.drawFontCenter(matrix, "MISSING  MODULE  ITEM  ", 88, 74);
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey() && ((MenuMachine)this.f_97732_).hasModule()) {
            this.drawFont(matrix, "RESET GAME", 18, 66);
            this.drawFont(matrix, "ALTERNATE COLOR VARIANT", 18, 79);
        }
        if (this.page == 1) {
            text = ((MenuMachine)this.f_97732_).getStorageToken() == 0 ? "EMPTY" : (((MenuMachine)this.f_97732_).getSettingInfiniteToken() ? "x(INFINITE)" : "x " + ((MenuMachine)this.f_97732_).getStorageToken());
            this.f_96542_.m_274569_(matrix, ((MenuMachine)this.f_97732_).getItemToken(), 51, 13);
            this.f_96547_.m_92883_(matrix, text, 69.0f, 17.0f, 0x404040);
        }
        if (this.page == 1 && ((MenuMachine)this.f_97732_).hasToken() && !this.hasGambling()) {
            this.drawFontInvert(matrix, "AMOUNT", 102, 57);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getBettingLow(), 108.0f, 57.0f, 0x404040);
        }
        if (this.page == 1 && ((MenuMachine)this.f_97732_).hasToken() && this.hasGambling()) {
            this.drawFontInvert(matrix, "MINIMUM", 102, 57);
            this.drawFontInvert(matrix, "MAXIMUM", 102, 75);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getBettingLow(), 108.0f, 57.0f, 0x404040);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getBettingHigh(), 108.0f, 75.0f, 0x404040);
        }
        if (this.page == 2) {
            text = ((MenuMachine)this.f_97732_).getStoragePrize() == 0 ? "EMPTY" : (((MenuMachine)this.f_97732_).getSettingInfinitePrize() ? "x(INFINITE)" : "x " + ((MenuMachine)this.f_97732_).getStoragePrize());
            this.f_96542_.m_274569_(matrix, ((MenuMachine)this.f_97732_).getItemPrize(), 51, 13);
            this.f_96547_.m_92883_(matrix, text, 69.0f, 17.0f, 0x404040);
        }
        if (this.page == 2 && ((MenuMachine)this.f_97732_).hasReward()) {
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getPrizeScore1(), 52.0f, 39.0f, 0x404040);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getPrizeScore2(), 52.0f, 57.0f, 0x404040);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getPrizeScore3(), 52.0f, 75.0f, 0x404040);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getPrizeCount1(), 108.0f, 39.0f, 0x404040);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getPrizeCount2(), 108.0f, 57.0f, 0x404040);
            this.f_96547_.m_92883_(matrix, "" + ((MenuMachine)this.f_97732_).getPrizeCount3(), 108.0f, 75.0f, 0x404040);
        }
        if (this.page == 3) {
            text = this.input.length() == 0 ? "0" : this.input;
            int w = this.f_96547_.m_92895_(text) / 2;
            this.drawFontCenter(matrix, "INPUT NUMBER", 88, 16);
            this.drawFontCenter(matrix, "PRESS ENTER TO SUBMIT", 88, 32);
            this.f_96547_.m_92883_(matrix, text, (float)(88 - w), 71.0f, 0x404040);
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int posX = (this.f_96543_ - this.f_97726_) / 2;
        int posY = (this.f_96544_ - this.f_97727_ + 12) / 2;
        ScreenMachine.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)0, (int)0, (int)176, (int)178);
        ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX - 56), (int)(posY - 1), (int)0, (int)180, (int)54, (int)28);
        ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX - 56), (int)(posY + 29), (int)0, (int)180, (int)54, (int)28);
        ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX - 56), (int)(posY + 59), (int)0, (int)180, (int)54, (int)28);
        ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 2), (int)(posY - 26), (int)200, (int)216, (int)56, (int)24);
        ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 60), (int)(posY - 26), (int)200, (int)216, (int)56, (int)24);
        ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 118), (int)(posY - 26), (int)200, (int)216, (int)56, (int)24);
        if (this.page < 3 && this.activeInput == 0) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX - 56), (int)(posY - 1), (int)0, (int)208, (int)54, (int)28);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX - 56), (int)(posY + 29), (int)54, (int)208, (int)54, (int)28);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && ((MenuMachine)this.f_97732_).hasModule()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX - 56), (int)(posY + 59), (int)108, (int)208, (int)54, (int)28);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && this.page == 0) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 2), (int)(posY - 26), (int)200, (int)(this.highlightIndex == 18 ? 48 : 24), (int)56, (int)24);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && this.page != 0) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 2), (int)(posY - 26), (int)200, (int)0, (int)56, (int)24);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && this.page == 1 && ((MenuMachine)this.f_97732_).hasModule()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 60), (int)(posY - 26), (int)200, (int)(this.highlightIndex == 19 ? 120 : 96), (int)56, (int)24);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && this.page != 1 && ((MenuMachine)this.f_97732_).hasModule()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 60), (int)(posY - 26), (int)200, (int)72, (int)56, (int)24);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && this.page == 2 && this.hasHighscore()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 118), (int)(posY - 26), (int)200, (int)(this.highlightIndex == 20 ? 192 : 168), (int)56, (int)24);
        }
        if (this.page < 3 && ((MenuMachine)this.f_97732_).hasKey() && this.page != 2 && this.hasHighscore()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 118), (int)(posY - 26), (int)200, (int)144, (int)56, (int)24);
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 4), (int)188, (int)72, (int)12, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 17), (int)188, (int)72, (int)12, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 30), (int)188, (int)(((MenuMachine)this.f_97732_).getSettingDropOnBreak() ? 60 : 24), (int)12, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 43), (int)188, (int)(((MenuMachine)this.f_97732_).getSettingIndestructable() ? 60 : 24), (int)12, (int)12);
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey()) {
            if (((Boolean)Config.ConfigMachine.config_creative_token.get()).booleanValue() && this.isOP()) {
                ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 4), (int)188, (int)(((MenuMachine)this.f_97732_).getSettingInfiniteToken() ? 60 : 24), (int)12, (int)12);
            }
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey()) {
            if (((Boolean)Config.ConfigMachine.config_creative_reward.get()).booleanValue() && this.isOP()) {
                ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 17), (int)188, (int)(((MenuMachine)this.f_97732_).getSettingInfinitePrize() ? 60 : 24), (int)12, (int)12);
            }
        }
        if (this.page == 0 && ((MenuMachine)this.f_97732_).hasKey() && ((MenuMachine)this.f_97732_).hasModule()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 57), (int)188, (int)(this.hasReset ? 12 : 0), (int)12, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 4), (int)(posY + 70), (int)176, (int)(((MenuMachine)this.f_97732_).getSettingAlternateColor() * 12), (int)12, (int)12);
        }
        if (this.page == 1) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 49), (int)(posY + 5), (int)55, (int)187, (int)78, (int)20);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 5), (int)(posY + 5), (int)(this.highlightIndex == 14 ? 40 : 0), (int)236, (int)40, (int)20);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 131), (int)(posY + 5), (int)(this.highlightIndex == 15 ? 120 : 80), (int)236, (int)40, (int)20);
        }
        if (this.page == 1 && ((MenuMachine)this.f_97732_).hasToken()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 104), (int)(posY + 49), (int)135, (int)181, (int)24, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 137), (int)(posY + 47), (int)(this.highlightIndex == 1 ? 176 : 160), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 155), (int)(posY + 47), (int)(this.highlightIndex == 2 ? 208 : 192), (int)240, (int)16, (int)16);
        }
        if (this.page == 1 && ((MenuMachine)this.f_97732_).hasToken() && this.hasGambling()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 104), (int)(posY + 67), (int)135, (int)181, (int)24, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 137), (int)(posY + 65), (int)(this.highlightIndex == 3 ? 176 : 160), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 155), (int)(posY + 65), (int)(this.highlightIndex == 4 ? 208 : 192), (int)240, (int)16, (int)16);
        }
        if (this.page == 2) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 49), (int)(posY + 5), (int)55, (int)187, (int)78, (int)20);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 5), (int)(posY + 5), (int)(this.highlightIndex == 14 ? 40 : 0), (int)236, (int)40, (int)20);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 131), (int)(posY + 5), (int)(this.highlightIndex == 15 ? 120 : 80), (int)236, (int)40, (int)20);
        }
        if (this.page == 2 && ((MenuMachine)this.f_97732_).hasReward()) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 48), (int)(posY + 31), (int)135, (int)195, (int)48, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 48), (int)(posY + 49), (int)135, (int)195, (int)48, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 48), (int)(posY + 67), (int)135, (int)195, (int)48, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 104), (int)(posY + 31), (int)135, (int)181, (int)24, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 104), (int)(posY + 49), (int)135, (int)181, (int)24, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 104), (int)(posY + 67), (int)135, (int)181, (int)24, (int)12);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 137), (int)(posY + 29), (int)(this.highlightIndex == 5 ? 176 : 160), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 155), (int)(posY + 29), (int)(this.highlightIndex == 6 ? 208 : 192), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 137), (int)(posY + 47), (int)(this.highlightIndex == 7 ? 176 : 160), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 155), (int)(posY + 47), (int)(this.highlightIndex == 8 ? 208 : 192), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 137), (int)(posY + 65), (int)(this.highlightIndex == 9 ? 176 : 160), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 155), (int)(posY + 65), (int)(this.highlightIndex == 10 ? 208 : 192), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 23), (int)(posY + 29), (int)(this.highlightIndex == 11 ? 240 : 224), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 23), (int)(posY + 47), (int)(this.highlightIndex == 12 ? 240 : 224), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 23), (int)(posY + 65), (int)(this.highlightIndex == 13 ? 240 : 224), (int)240, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 5), (int)(posY + 29), (int)(((MenuMachine)this.f_97732_).getPrizeMode1() ? 178 : 162), (int)208, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 5), (int)(posY + 47), (int)(((MenuMachine)this.f_97732_).getPrizeMode2() ? 178 : 162), (int)208, (int)16, (int)16);
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 5), (int)(posY + 65), (int)(((MenuMachine)this.f_97732_).getPrizeMode3() ? 178 : 162), (int)208, (int)16, (int)16);
        }
        if (this.page == 3) {
            ScreenMachine.m_93228_((PoseStack)matrix, (int)(posX + 49), (int)(posY + 57), (int)55, (int)187, (int)78, (int)20);
        }
        if (this.highlightTimer > 0) {
            --this.highlightTimer;
            if (this.highlightTimer == 0) {
                if (this.highlightIndex == 11 || this.highlightIndex == 12) {
                    this.commandTranferOFF();
                }
                this.highlightIndex = 0;
            }
        }
    }

    public void commandChangeBet(int value, boolean isMaxBet) {
        boolean send = false;
        if (isMaxBet) {
            ((MenuMachine)this.f_97732_).setBettingHigh(((MenuMachine)this.f_97732_).getBettingHigh() + value);
            if (((MenuMachine)this.f_97732_).getBettingLow() > ((MenuMachine)this.f_97732_).getBettingHigh()) {
                ((MenuMachine)this.f_97732_).setBettingLow(((MenuMachine)this.f_97732_).getBettingHigh());
            }
            send = true;
        } else if (value > 0 || ((MenuMachine)this.f_97732_).getBettingLow() > 0) {
            ((MenuMachine)this.f_97732_).setBettingLow(((MenuMachine)this.f_97732_).getBettingLow() + value);
            if (((MenuMachine)this.f_97732_).getBettingHigh() < ((MenuMachine)this.f_97732_).getBettingLow() || !this.hasGambling()) {
                ((MenuMachine)this.f_97732_).setBettingHigh(((MenuMachine)this.f_97732_).getBettingLow());
            }
            send = true;
        }
        if (send) {
            this.sendPacket();
        }
    }

    public void commandChangeReward(int value, int index) {
        boolean send = false;
        if (index == 0 && (value > 0 || ((MenuMachine)this.f_97732_).getPrizeCount1() > 0)) {
            ((MenuMachine)this.f_97732_).setPrizeCount1(((MenuMachine)this.f_97732_).getPrizeCount1() + value);
            send = true;
        }
        if (index == 1 && (value > 0 || ((MenuMachine)this.f_97732_).getPrizeCount2() > 0)) {
            ((MenuMachine)this.f_97732_).setPrizeCount2(((MenuMachine)this.f_97732_).getPrizeCount2() + value);
            send = true;
        }
        if (index == 2 && (value > 0 || ((MenuMachine)this.f_97732_).getPrizeCount3() > 0)) {
            ((MenuMachine)this.f_97732_).setPrizeCount3(((MenuMachine)this.f_97732_).getPrizeCount3() + value);
            send = true;
        }
        if (send) {
            this.sendPacket();
        }
    }

    public void commandTransfer(boolean isToken, boolean isIN) {
        if (isToken && isIN) {
            ((MenuMachine)this.f_97732_).setTransferTokenIN(true);
            ((MenuMachine)this.f_97732_).setTransferTokenOUT(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeIN(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeOUT(false);
        }
        if (isToken && !isIN) {
            ((MenuMachine)this.f_97732_).setTransferTokenIN(false);
            ((MenuMachine)this.f_97732_).setTransferTokenOUT(true);
            ((MenuMachine)this.f_97732_).setTransferPrizeIN(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeOUT(false);
        }
        if (!isToken && isIN) {
            ((MenuMachine)this.f_97732_).setTransferTokenIN(false);
            ((MenuMachine)this.f_97732_).setTransferTokenOUT(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeIN(true);
            ((MenuMachine)this.f_97732_).setTransferPrizeOUT(false);
        }
        if (!isToken && !isIN) {
            ((MenuMachine)this.f_97732_).setTransferTokenIN(false);
            ((MenuMachine)this.f_97732_).setTransferTokenOUT(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeIN(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeOUT(true);
        }
        this.sendPacket();
    }

    private void commandTranferOFF() {
        ((MenuMachine)this.f_97732_).setTransferTokenIN(false);
        ((MenuMachine)this.f_97732_).setTransferTokenOUT(false);
        ((MenuMachine)this.f_97732_).setTransferPrizeIN(false);
        ((MenuMachine)this.f_97732_).setTransferPrizeOUT(false);
        this.sendPacket();
    }

    public void commandToggleSettings(int settingID) {
        if (settingID == 0) {
            if (((Boolean)Config.ConfigMachine.config_creative_token.get()).booleanValue() && this.isOP()) {
                ((MenuMachine)this.f_97732_).setSettingInfiniteToken(!((MenuMachine)this.f_97732_).getSettingInfiniteToken());
            }
        }
        if (settingID == 1) {
            if (((Boolean)Config.ConfigMachine.config_creative_reward.get()).booleanValue() && this.isOP()) {
                ((MenuMachine)this.f_97732_).setSettingInfinitePrize(!((MenuMachine)this.f_97732_).getSettingInfinitePrize());
            }
        }
        if (settingID == 2) {
            ((MenuMachine)this.f_97732_).setSettingDropOnBreak(!((MenuMachine)this.f_97732_).getSettingDropOnBreak());
        }
        if (settingID == 3) {
            ((MenuMachine)this.f_97732_).setSettingIndestructable(!((MenuMachine)this.f_97732_).getSettingIndestructable());
        }
        if (settingID == 4) {
            ((MenuMachine)this.f_97732_).setSettingAlternateColor((((MenuMachine)this.f_97732_).getSettingAlternateColor() + 1) % 6);
        }
        this.sendPacket();
    }

    public void commandChangePage(int index) {
        if (((MenuMachine)this.f_97732_).getTransferTokenIN() || ((MenuMachine)this.f_97732_).getTransferTokenOUT() || ((MenuMachine)this.f_97732_).getTransferPrizeIN() || ((MenuMachine)this.f_97732_).getTransferPrizeOUT()) {
            ((MenuMachine)this.f_97732_).setTransferTokenIN(false);
            ((MenuMachine)this.f_97732_).setTransferTokenOUT(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeIN(false);
            ((MenuMachine)this.f_97732_).setTransferPrizeOUT(false);
            this.sendPacket();
        }
        this.page = index;
    }

    public void commandResetGameState() {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, -2, ((MenuMachine)this.f_97732_).pos()));
        this.hasReset = true;
    }

    public void commandSetScore(int index, int score) {
        if (index == 0) {
            ((MenuMachine)this.f_97732_).setPrizeScore1(score);
        }
        if (index == 1) {
            ((MenuMachine)this.f_97732_).setPrizeScore2(score);
        }
        if (index == 2) {
            ((MenuMachine)this.f_97732_).setPrizeScore3(score);
        }
        this.sendPacket();
    }

    public void commandTogglePrize(int index) {
        if (index == 0) {
            ((MenuMachine)this.f_97732_).setPrizeMode1(!((MenuMachine)this.f_97732_).getPrizeMode1());
        }
        if (index == 1) {
            ((MenuMachine)this.f_97732_).setPrizeMode2(!((MenuMachine)this.f_97732_).getPrizeMode2());
        }
        if (index == 2) {
            ((MenuMachine)this.f_97732_).setPrizeMode3(!((MenuMachine)this.f_97732_).getPrizeMode3());
        }
    }

    protected void drawFont(PoseStack matrix, String text, int x, int y) {
        this.f_96547_.m_92883_(matrix, text, (float)x, (float)y, 0);
    }

    protected void drawFontInvert(PoseStack matrix, String text, int x, int y) {
        int w = this.f_96547_.m_92895_(text);
        this.f_96547_.m_92883_(matrix, text, (float)(x - w), (float)y, 0);
    }

    protected void drawFontCenter(PoseStack matrix, String text, int x, int y) {
        int w = this.f_96547_.m_92895_(text) / 2;
        this.f_96547_.m_92883_(matrix, text, (float)(x - w), (float)y, 0);
    }

    protected void highlight(int index) {
        this.highlightTimer = 10;
        this.highlightIndex = index;
    }

    private boolean isOP() {
        return (Boolean)Config.ConfigMachine.config_creative_oponly.get() == false || this.f_96541_.f_91074_.m_8088_() > 0;
    }

    protected void sendPacket() {
        CasinoPacketHandler.sendToServer(new MessageSettingServer(((MenuMachine)this.f_97732_).pos(), new int[]{((MenuMachine)this.f_97732_).getBettingLow(), ((MenuMachine)this.f_97732_).getBettingHigh(), ((MenuMachine)this.f_97732_).getPrizeScore1(), ((MenuMachine)this.f_97732_).getPrizeScore2(), ((MenuMachine)this.f_97732_).getPrizeScore3(), ((MenuMachine)this.f_97732_).getPrizeCount1(), ((MenuMachine)this.f_97732_).getPrizeCount2(), ((MenuMachine)this.f_97732_).getPrizeCount3(), ((MenuMachine)this.f_97732_).getPrizeMode1() ? 1 : 0, ((MenuMachine)this.f_97732_).getPrizeMode2() ? 1 : 0, ((MenuMachine)this.f_97732_).getPrizeMode3() ? 1 : 0, ((MenuMachine)this.f_97732_).getTransferTokenIN() ? 1 : 0, ((MenuMachine)this.f_97732_).getTransferTokenOUT() ? 1 : 0, ((MenuMachine)this.f_97732_).getTransferPrizeIN() ? 1 : 0, ((MenuMachine)this.f_97732_).getTransferPrizeOUT() ? 1 : 0, ((MenuMachine)this.f_97732_).getSettingInfiniteToken() ? 1 : 0, ((MenuMachine)this.f_97732_).getSettingInfinitePrize() ? 1 : 0, ((MenuMachine)this.f_97732_).getSettingDropOnBreak() ? 1 : 0, ((MenuMachine)this.f_97732_).getSettingIndestructable() ? 1 : 0, ((MenuMachine)this.f_97732_).getSettingAlternateColor()}));
    }

    private boolean hasHighscore() {
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_LIME.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_LIGHT_GRAY.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_LIGHT_BLUE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_GRAY.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_CYAN.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_BLUE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CHIP_PINK.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CHIP_ORANGE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CHIP_LIGHT_GRAY.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CHIP_LIGHT_BLUE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CHIP_CYAN.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CHIP_BLUE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_PURPLE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_MAGENTA.get()) {
            return true;
        }
        return ((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_LIGHT_BLUE.get();
    }

    private boolean hasGambling() {
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_YELLOW.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_RED.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_PINK.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_MINO_ORANGE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_YELLOW.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_WHITE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_RED.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_ORANGE.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_LIGHT_GRAY.get()) {
            return true;
        }
        if (((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_GRAY.get()) {
            return true;
        }
        return ((ItemStack)((MenuMachine)this.f_97732_).m_38927_().get(1)).m_41720_() == CasinoKeeper.MODULE_CARD_BLACK.get();
    }

    protected boolean hasKey() {
        return ((MenuMachine)this.f_97732_).hasKey();
    }
}

