/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.card;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.Config;
import mod.casinocraft.logic.card.LogicCardGreen;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import mod.casinocraft.util.Card;
import mod.lucky77.util.Vector2;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ScreenCardGreen
extends ScreenCasino {
    int playerPos;

    public ScreenCardGreen(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicCardGreen logic() {
        return (LogicCardGreen)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "maumau";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_BOT_MIDDLE, ButtonMap.DRAW, () -> this.isActivePlayer() && this.logic().turnstate == 3 && (this.logic().forcedAction == 0 || this.logic().forcedAction == 2), () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_BOT_MIDDLE, ButtonMap.WAIT, () -> this.isActivePlayer() && this.logic().turnstate == 3 && this.logic().forcedAction == 1, () -> this.action(-1));
        this.buttonSet.addButton(new Vector2(50, 237), ButtonMap.COLOR_RED, 2, () -> this.isActivePlayer() && this.logic().turnstate == 3 && this.logic().forcedAction == 3, () -> this.action(-5));
        this.buttonSet.addButton(new Vector2(89, 237), ButtonMap.COLOR_YELLOW, 2, () -> this.isActivePlayer() && this.logic().turnstate == 3 && this.logic().forcedAction == 3, () -> this.action(-4));
        this.buttonSet.addButton(new Vector2(128, 237), ButtonMap.COLOR_BLUE, 2, () -> this.isActivePlayer() && this.logic().turnstate == 3 && this.logic().forcedAction == 3, () -> this.action(-3));
        this.buttonSet.addButton(new Vector2(167, 237), ButtonMap.COLOR_GREEN, 2, () -> this.isActivePlayer() && this.logic().turnstate == 3 && this.logic().forcedAction == 3, () -> this.action(-2));
        this.playerPos = -2;
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 3 && this.logic().forcedAction == 0) {
            int x = this.logic().getFirstFreePlayerSlot() < 5 ? 128 : 48;
            int playerPos = this.getPlayerPosition();
            for (int i = 0; i < this.logic().getCards(playerPos).size(); ++i) {
                if (!this.mouseRect(x - this.logic().getCards(playerPos).size() * 16 + 32 * i, 188, 32, 48, mouseX, mouseY)) continue;
                this.action(i);
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        if (this.logic().turnstate == 2) {
            this.drawFontCenter(matrix, "Waiting for Players", 128, 88);
        }
        if (this.logic().turnstate == 3 && !this.isActivePlayer()) {
            this.drawFontCenter(matrix, "...", 128, 88);
        }
        if (this.logic().turnstate == 3 && this.isActivePlayer() && this.logic().forcedAction == 0) {
            this.drawFontCenter(matrix, "Choose a Card to play ...", 128, 88);
        }
        if (this.logic().turnstate == 3 && this.isActivePlayer() && this.logic().forcedAction == 1) {
            this.drawFontCenter(matrix, "You are forced to wait ...", 128, 88);
        }
        if (this.logic().turnstate == 3 && this.isActivePlayer() && this.logic().forcedAction == 2) {
            this.drawFontCenter(matrix, "Draw 2 Cards ...", 128, 88);
        }
        if (this.logic().turnstate == 3 && this.isActivePlayer() && this.logic().forcedAction == 3) {
            this.drawFontCenter(matrix, "Choose a color ...", 128, 88);
        }
        if (this.logic().turnstate >= 4) {
            this.drawFontCenter(matrix, this.logic().hand, 128, 88);
        }
        this.drawTimer(matrix);
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.playerPos > -2 && this.logic().turnstate == 2) {
            this.playerPos = -2;
        }
        if (this.playerPos == -2 && this.logic().turnstate == 3) {
            this.playerPos = this.getPlayerPosition();
        }
        this.drawCard(matrix, 112, 104, this.logic().placed[1]);
        this.drawCard(matrix, 112, 104, this.logic().placed[0]);
        switch (this.logic().chosenColor) {
            case 0: {
                this.drawCardBack(matrix, 112, 104, 8);
                break;
            }
            case 1: {
                this.drawCardBack(matrix, 112, 104, 10);
                break;
            }
            case 2: {
                this.drawCardBack(matrix, 112, 104, 9);
                break;
            }
            case 3: {
                this.drawCardBack(matrix, 112, 104, 11);
            }
        }
        int left = this.tableID == 1 ? 7 : -89;
        int right = this.tableID == 1 ? 217 : 313;
        switch (this.logic().playerCount) {
            case 1: {
                this.drawCard2(matrix, 128, 193, false, this.playerPos, 0);
                break;
            }
            case 2: {
                this.drawCard2(matrix, 128, 193, false, this.playerPos, this.playerPos);
                this.drawCard2(matrix, 128, 7, false, this.playerPos, (this.playerPos + 1) % 2);
                break;
            }
            case 3: {
                this.drawCard2(matrix, 128, 193, false, this.playerPos, this.playerPos);
                this.drawCard2(matrix, left, 128, true, this.playerPos, (this.playerPos + 1) % 3);
                this.drawCard2(matrix, right, 128, true, this.playerPos, (this.playerPos + 2) % 3);
                break;
            }
            case 4: {
                this.drawCard2(matrix, 128, 193, false, this.playerPos, this.playerPos);
                this.drawCard2(matrix, left, 128, true, this.playerPos, (this.playerPos + 1) % 4);
                this.drawCard2(matrix, 128, 7, false, this.playerPos, (this.playerPos + 2) % 4);
                this.drawCard2(matrix, right, 144, true, this.playerPos, (this.playerPos + 3) % 4);
                break;
            }
            case 5: {
                this.drawCard2(matrix, 128, 193, false, this.playerPos, this.playerPos);
                this.drawCard2(matrix, left, 128, true, this.playerPos, (this.playerPos + 1) % 5);
                this.drawCard2(matrix, 48, 7, false, this.playerPos, (this.playerPos + 2) % 5);
                this.drawCard2(matrix, 208, 7, false, this.playerPos, (this.playerPos + 3) % 5);
                this.drawCard2(matrix, right, 128, true, this.playerPos, (this.playerPos + 4) % 5);
                break;
            }
            case 6: {
                this.drawCard2(matrix, 32, 193, false, this.playerPos, this.playerPos);
                this.drawCard2(matrix, left, 128, true, this.playerPos, (this.playerPos + 1) % 6);
                this.drawCard2(matrix, 48, 7, false, this.playerPos, (this.playerPos + 2) % 6);
                this.drawCard2(matrix, 208, 7, false, this.playerPos, (this.playerPos + 3) % 6);
                this.drawCard2(matrix, right, 128, true, this.playerPos, (this.playerPos + 4) % 6);
                this.drawCard2(matrix, 208, 201, false, this.playerPos, (this.playerPos + 5) % 6);
            }
        }
    }

    private void drawCard2(PoseStack matrix, int posX, int posY, boolean sideways, int playerPos, int cardPos) {
        if (playerPos < 0) {
            return;
        }
        int i = 0;
        for (Card card : this.logic().getCards(cardPos)) {
            if (card.suit != -1 && card.idletimer == 0) {
                boolean hidden = this.logic().turnstate > 3 ? false : playerPos != cardPos;
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.getCardsTexture(hidden || card.suit >= 2));
                int texX = card.suit == -1 || hidden ? cardPos + 1 : card.number % 8;
                int texY = card.suit == -1 || hidden ? 4 : card.suit % 2 * 2 + card.number / 8;
                if (((Boolean)Config.ConfigMachine.config_animated_cards.get()).booleanValue() && !hidden && card.number >= 10 && this.logic().frame == card.suit * 12 + (card.number - 10) * 3) {
                    texX += 3;
                }
                if (sideways) {
                    ScreenCardGreen.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX + card.shiftX), (int)(this.f_97736_ + posY - this.logic().getCards(cardPos).size() * 12 + i * 20 + card.shiftY), (int)(texX * 32), (int)(texY * 48), (int)32, (int)(48 - card.deathtimer));
                } else {
                    ScreenCardGreen.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX + card.shiftX - this.logic().getCards(cardPos).size() * 16 + i * 32), (int)(this.f_97736_ + posY + card.shiftY), (int)(texX * 32), (int)(texY * 48), (int)32, (int)(48 - card.deathtimer));
                }
            }
            ++i;
        }
    }
}

