/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.forge;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.Nullable;

public class ClientHelperImpl {
    public static void registerRenderType(Block block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
    }

    public static void registerFluidRenderType(Fluid fluid, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
    }

    public static void addParticleRegistration(Consumer<ClientHelper.ParticleEvent> eventListener) {
        Consumer<RegisterParticleProvidersEvent> eventConsumer = event -> {
            W w = new W((RegisterParticleProvidersEvent)event);
            eventListener.accept(w::register);
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addEntityRenderersRegistration(Consumer<ClientHelper.EntityRendererEvent> eventListener) {
        Consumer<EntityRenderersEvent.RegisterRenderers> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addBlockEntityRenderersRegistration(Consumer<ClientHelper.BlockEntityRendererEvent> eventListener) {
        Consumer<EntityRenderersEvent.RegisterRenderers> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addBlockColorsRegistration(Consumer<ClientHelper.BlockColorEvent> eventListener) {
        Consumer<RegisterColorHandlersEvent.Block> eventConsumer = event -> eventListener.accept(new ClientHelper.BlockColorEvent((RegisterColorHandlersEvent.Block)event){
            final /* synthetic */ RegisterColorHandlersEvent.Block val$event;
            {
                this.val$event = block;
            }

            @Override
            public void register(BlockColor color, Block ... block) {
                this.val$event.register(color, block);
            }

            @Override
            public int getColor(BlockState block, BlockAndTintGetter level, BlockPos pos, int tint) {
                return this.val$event.getBlockColors().m_92577_(block, level, pos, tint);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addItemColorsRegistration(Consumer<ClientHelper.ItemColorEvent> eventListener) {
        Consumer<RegisterColorHandlersEvent.Item> eventConsumer = event -> eventListener.accept(new ClientHelper.ItemColorEvent((RegisterColorHandlersEvent.Item)event){
            final /* synthetic */ RegisterColorHandlersEvent.Item val$event;
            {
                this.val$event = item;
            }

            @Override
            public void register(ItemColor color, ItemLike ... items) {
                this.val$event.register(color, items);
            }

            @Override
            public int getColor(ItemStack stack, int tint) {
                return this.val$event.getItemColors().m_92676_(stack, tint);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addClientReloadListener(Supplier<PreparableReloadListener> listener, ResourceLocation location) {
        Consumer<RegisterClientReloadListenersEvent> eventConsumer = event -> event.registerReloadListener((PreparableReloadListener)listener.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addModelLayerRegistration(Consumer<ClientHelper.ModelLayerEvent> eventListener) {
        Consumer<EntityRenderersEvent.RegisterLayerDefinitions> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addSpecialModelRegistration(Consumer<ClientHelper.SpecialModelEvent> eventListener) {
        Consumer<ModelEvent.RegisterAdditional> eventConsumer = event -> eventListener.accept(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addTooltipComponentRegistration(Consumer<ClientHelper.TooltipComponentEvent> eventListener) {
        Consumer<RegisterClientTooltipComponentFactoriesEvent> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)event).register(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addModelLoaderRegistration(Consumer<ClientHelper.ModelLoaderEvent> eventListener) {
        Consumer<ModelEvent.RegisterGeometryLoaders> eventConsumer = event -> eventListener.accept((i, l) -> event.register(i.m_135815_(), (IGeometryLoader)l));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addItemDecoratorsRegistration(Consumer<ClientHelper.ItemDecoratorEvent> eventListener) {
        Consumer<RegisterItemDecorationsEvent> eventConsumer = event -> eventListener.accept((i, l) -> {
            IItemDecorator deco = new IItemDecorator(){

                public boolean render(PoseStack poseStack, Font font, ItemStack stack, int xOffset, int yOffset) {
                    return l.render(poseStack, font, stack, xOffset, yOffset);
                }
            };
            event.register(i, deco);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addKeyBindRegistration(Consumer<ClientHelper.KeyBindEvent> eventListener) {
        Consumer<RegisterKeyMappingsEvent> eventConsumer = event -> eventListener.accept(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static int getPixelRGBA(TextureAtlasSprite sprite, int frameIndex, int x, int y) {
        return sprite.getPixelRGBA(frameIndex, x, y);
    }

    public static BakedModel getModel(ModelManager modelManager, ResourceLocation modelLocation) {
        return modelManager.getModel(modelLocation);
    }

    @Nullable
    public static Path getModIcon(String modId) {
        Optional m = ModList.get().getModContainerById(modId);
        if (m.isPresent()) {
            Path logoPath;
            IModInfo mod = ((ModContainer)m.get()).getModInfo();
            IModFile file = mod.getOwningFile().getFile();
            String logo = mod.getLogoFile().orElse(null);
            if (logo != null && file != null && Files.exists(logoPath = file.findResource(new String[]{logo}), new LinkOption[0])) {
                return logoPath;
            }
        }
        return null;
    }

    public static BlockModel parseBlockModel(JsonElement json) {
        return (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.getAdapter(BlockModel.class).fromJsonTree(json);
    }

    public static void addClientSetup(Runnable clientSetup) {
        Consumer<FMLClientSetupEvent> eventConsumer = event -> event.enqueueWork(clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void registerOptionalTexturePack(ResourceLocation folderName, Component displayName, boolean defaultEnabled) {
        PlatHelper.registerResourcePack(PackType.CLIENT_RESOURCES, () -> {
            Pack pack;
            IModFile file = ModList.get().getModFileById(folderName.m_135827_()).getFile();
            PathPackResources pack2 = new PathPackResources(folderName.toString(), true, file.findResource(new String[]{"resourcepacks/" + folderName.m_135815_()}));
            try {
                PackMetadataSection metadata = Objects.requireNonNull((PackMetadataSection)pack2.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_));
                pack = Pack.m_245512_((String)folderName.toString(), (Component)displayName, (boolean)defaultEnabled, s -> pack2, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.m_10374_(), FeatureFlagSet.m_246902_()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        pack2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ee) {
                    if (!DatagenModLoader.isRunningDataGen()) {
                        ee.printStackTrace();
                    }
                    return null;
                }
            }
            pack2.close();
            return pack;
        });
    }

    private record W(RegisterParticleProvidersEvent event) {
        public <T extends ParticleOptions> void register(ParticleType<T> type, ClientHelper.ParticleFactory<T> provider) {
            this.event.registerSpriteSet(type, provider::create);
        }
    }
}

