/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class BlockSetInternalImpl {
    private static final Map<String, List<Runnable>> LATE_REGISTRATION_QUEUE = new ConcurrentHashMap<String, List<Runnable>>();
    private static boolean hasFilledBlockSets = false;

    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, Registry<E> registry) {
        if (registry == BuiltInRegistries.f_256975_) {
            BlockSetInternalImpl.addDynamicBlockRegistration(registrationFunction, blockType);
        } else {
            if (registry == BuiltInRegistries.f_257020_ || registry == BuiltInRegistries.f_256894_) {
                throw new IllegalArgumentException("Fluid and Sound Events registry not supported here");
            }
            RegHelper.registerInBatch(registry, e -> registrationFunction.accept((Registrator)e, BlockSetAPI.getBlockSet(blockType).getValues()));
        }
    }

    public static <T extends BlockType> void addDynamicBlockRegistration(BlockSetAPI.BlockTypeRegistryCallback<Block, T> registrationFunction, Class<T> blockType) {
        List<Runnable> registrationQueues = BlockSetInternalImpl.getOrAddQueue();
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals((Object)ForgeRegistries.BLOCKS.getRegistryKey())) {
                Runnable lateRegistration = () -> {
                    IForgeRegistry registry = e.getForgeRegistry();
                    if (registry instanceof ForgeRegistry) {
                        ForgeRegistry fr = (ForgeRegistry)registry;
                        boolean frozen = fr.isLocked();
                        fr.unfreeze();
                        registrationFunction.accept((arg_0, arg_1) -> ((IForgeRegistry)registry).register(arg_0, arg_1), BlockSetAPI.getBlockSet(blockType).getValues());
                        if (frozen) {
                            fr.freeze();
                        }
                    }
                };
                registrationQueues.add(lateRegistration);
            }
        };
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.HIGHEST, eventConsumer);
    }

    @NotNull
    private static List<Runnable> getOrAddQueue() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        return LATE_REGISTRATION_QUEUE.computeIfAbsent(modId, s -> {
            bus.addListener(EventPriority.HIGHEST, BlockSetInternalImpl::registerLateBlockAndItems);
            return new ArrayList();
        });
    }

    protected static void registerLateBlockAndItems(RegisterEvent event) {
        String modId;
        List<Runnable> registrationQueues;
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.ATTRIBUTES.getRegistryKey())) {
            return;
        }
        if (!hasFilledBlockSets) {
            BlockSetInternal.initializeBlockSets();
            hasFilledBlockSets = true;
        }
        if ((registrationQueues = LATE_REGISTRATION_QUEUE.get(modId = ModLoadingContext.get().getActiveContainer().getModId())) != null) {
            registrationQueues.forEach(Runnable::run);
        }
        LATE_REGISTRATION_QUEUE.remove(modId);
    }

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    static {
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals((Object)ForgeRegistries.ENCHANTMENTS.getRegistryKey())) {
                BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }
}

