/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.entities.ChiseledPrinterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledPrinterBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> BUTTON_VS_MAP = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)Block.m_49796_((double)7.0, (double)1.0, (double)-0.5, (double)12.0, (double)4.0, (double)0.0)).put((Object)Direction.EAST, (Object)Block.m_49796_((double)16.0, (double)1.0, (double)7.0, (double)16.5, (double)4.0, (double)12.0)).put((Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)1.0, (double)16.0, (double)9.0, (double)4.0, (double)16.5)).put((Object)Direction.WEST, (Object)Block.m_49796_((double)-0.5, (double)1.0, (double)4.0, (double)0.0, (double)4.0, (double)9.0)).build();
    private static final VoxelShape VS_NORTH = ChiseledPrinterBlock.createForDirection(Direction.NORTH);
    private static final VoxelShape VS_EAST = ChiseledPrinterBlock.createForDirection(Direction.EAST);
    private static final VoxelShape VS_SOUTH = ChiseledPrinterBlock.createForDirection(Direction.SOUTH);
    private static final VoxelShape VS_WEST = ChiseledPrinterBlock.createForDirection(Direction.WEST);
    private static final Map<Direction, VoxelShape> VS_MAP = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)VS_NORTH).put((Object)Direction.EAST, (Object)VS_EAST).put((Object)Direction.SOUTH, (Object)VS_SOUTH).put((Object)Direction.WEST, (Object)VS_WEST).build();

    private static VoxelShape createForDirection(Direction direction) {
        return Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Stream.of(Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.m_49796_((double)14.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)5.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)5.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_()), (VoxelShape)Stream.of(Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.m_49796_((double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Stream.of(Block.m_49796_((double)2.0, (double)14.0, (double)7.0, (double)14.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)13.99, (double)2.0, (double)9.0, (double)15.98, (double)14.0), Block.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.m_49796_((double)7.5, (double)10.0, (double)7.5, (double)8.5, (double)11.0, (double)8.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_())).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_()), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape)BUTTON_VS_MAP.getOrDefault(direction, Shapes.m_83040_()), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_);
    }

    public ChiseledPrinterBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return VS_MAP.getOrDefault(state.m_61143_((Property)FACING), Shapes.m_83040_());
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ChiseledPrinterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (world1, pos, state1, tileEntity) -> {
            if (tileEntity instanceof ChiseledPrinterBlockEntity) {
                ChiseledPrinterBlockEntity entity = (ChiseledPrinterBlockEntity)tileEntity;
                entity.m_142339_(world1);
                entity.tick();
            }
        };
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_((MenuProvider)worldIn.m_7702_(pos));
        return InteractionResult.CONSUME;
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.ChiselStationHelp, tooltip, new Object[0]);
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof ChiseledPrinterBlockEntity) {
                ((ChiseledPrinterBlockEntity)tileentity).dropInventoryItems(worldIn, pos);
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }
}

