/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.bit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.client.model.baked.bit.BitBlockBakedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.client.time.TickHandler;
import mod.chiselsandbits.registrars.ModCreativeTabs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BitBlockBakedModelManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BitBlockBakedModelManager INSTANCE = new BitBlockBakedModelManager();
    private final Cache<IBlockInformation, BakedModel> modelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<IBlockInformation, BakedModel> largeModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final NonNullList<ItemStack> alternativeStacks = NonNullList.m_122779_();

    private BitBlockBakedModelManager() {
    }

    public static BitBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.modelCache.asMap().clear();
        this.largeModelCache.asMap().clear();
    }

    public BakedModel get(ItemStack stack, Level world, LivingEntity entity) {
        return this.get(stack, world, entity, !Minecraft.m_91087_().f_91066_.f_92090_.m_90862_() && Minecraft.m_91087_().f_91066_.f_92090_.m_90857_() || Minecraft.m_91087_().m_91268_() != null && Screen.m_96638_());
    }

    public BakedModel get(ItemStack stack, Level world, LivingEntity entity, boolean large) {
        if (!(stack.m_41720_() instanceof IBitItem)) {
            LOGGER.warn("Tried to get bit item model for non bit item");
            return NullBakedModel.instance;
        }
        BakedModel model = this.get(large, ((IBitItem)stack.m_41720_()).getBlockInformation(stack), world, entity);
        return model.m_7343_().m_173464_(model, stack, null, null, 0);
    }

    public BakedModel get(boolean large, IBlockInformation blockInformation, Level level, LivingEntity entity) {
        if (blockInformation.isAir() || blockInformation == null) {
            int alternativeIndex;
            ItemStack alternativeStack;
            if (this.alternativeStacks.isEmpty()) {
                ModCreativeTabs.BITS.get().m_269498_(new CreativeModeTab.ItemDisplayParameters(FeatureFlags.f_244377_, false, (HolderLookup.Provider)level.m_9598_()));
                this.alternativeStacks.addAll(ModCreativeTabs.BITS.get().m_260957_());
            }
            if (!((alternativeStack = (ItemStack)this.alternativeStacks.get(alternativeIndex = (int)(Math.floor((double)TickHandler.getClientTicks() / 20.0) % (double)this.alternativeStacks.size()))).m_41720_() instanceof IBitItem)) {
                throw new IllegalStateException("BitItem returned none bit item stack!");
            }
            blockInformation = ((IBitItem)alternativeStack.m_41720_()).getBlockInformation(alternativeStack);
        }
        Cache<IBlockInformation, BakedModel> target = large ? this.largeModelCache : this.modelCache;
        IBlockInformation workingState = blockInformation;
        try {
            return (BakedModel)target.get((Object)blockInformation, () -> {
                if (large) {
                    ItemStack lookupStack = IStateVariantManager.getInstance().getItemStack(workingState).orElseGet(() -> new ItemStack((ItemLike)workingState.getBlockState().m_60734_()));
                    if (workingState.getBlockState().m_60734_() instanceof LiquidBlock) {
                        lookupStack = new ItemStack((ItemLike)workingState.getBlockState().m_60819_().m_76152_().m_6859_());
                    }
                    return Minecraft.m_91087_().m_91291_().m_174264_(lookupStack, level, entity, 0);
                }
                return new BitBlockBakedModel(workingState);
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to get a model for a bit: " + blockInformation + " the model calculation got aborted.", (Throwable)e);
            return NullBakedModel.instance;
        }
    }
}

