/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.client.screen.widget.AbstractChiselsAndBitsWidget;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.withmode.IRenderableMode;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RadialSelectionWidget
extends AbstractChiselsAndBitsWidget {
    private static final float DRAWS = 720.0f;
    private final Supplier<IRenderableMode> currentlySelectedModeSupplier;
    private final Consumer<IRenderableMode> currentlyHoveredModeCallback;
    private final Consumer<IRenderableMode> currentlyClickedModeCallback;
    private final List<? extends IRenderableMode> modes;
    private final float sectionArcAngle;
    private final float sectionStartAngle;
    private final float innerSelectionRadius;
    private final float outerSelectionRadius;
    private final boolean keepSelectionWhenBeyondOuterSelectionRadius;
    private final float innerRadius;
    private final float outerRadius;
    private final float iconSize;
    private final float iconScaleFactor;
    private final int iconTextSpacer;
    private final Font fontRenderer;
    private final float centerX;
    private final float centerY;

    public RadialSelectionWidget(Screen screen, int width, int height, Component message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, Font fontRenderer) {
        this((int)((float)screen.f_96543_ / 2.0f - (float)width / 2.0f), (int)((float)screen.f_96544_ / 2.0f - (float)height / 2.0f), width, height, message, currentlySelectedModeSupplier, currentlyHoveredModeCallback, currentlyClickedModeCallback, modes, sectionArcAngle, sectionStartAngle, hideInactiveIcons, innerSelectionRadius, outerSelectionRadius, keepSelectionWhenBeyondOuterSelectionRadius, innerRadius, outerRadius, iconSize, iconScaleFactor, iconTextSpacer, fontRenderer);
    }

    public RadialSelectionWidget(int x, int y, int width, int height, Component message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<? extends IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, Font fontRenderer) {
        super(x, y, width, height, message);
        this.currentlySelectedModeSupplier = currentlySelectedModeSupplier;
        this.currentlyHoveredModeCallback = currentlyHoveredModeCallback;
        this.currentlyClickedModeCallback = currentlyClickedModeCallback;
        this.keepSelectionWhenBeyondOuterSelectionRadius = keepSelectionWhenBeyondOuterSelectionRadius;
        this.modes = modes.stream().filter(mode -> !hideInactiveIcons || mode.isActive()).collect(Collectors.toList());
        this.sectionArcAngle = sectionArcAngle;
        this.sectionStartAngle = sectionStartAngle;
        this.innerSelectionRadius = innerSelectionRadius;
        this.outerSelectionRadius = outerSelectionRadius;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.iconSize = iconSize;
        this.iconScaleFactor = iconScaleFactor;
        this.iconTextSpacer = iconTextSpacer;
        this.fontRenderer = fontRenderer;
        this.centerX = (float)x + (float)width / 2.0f;
        this.centerY = (float)y + (float)height / 2.0f;
    }

    public <G extends IToolModeGroup> RadialSelectionWidget(AbstractChiselsAndBitsWidget widget, int width, int height, Component message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<? extends IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, Font fontRenderer) {
        this((int)((float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f - (float)width / 2.0f), (int)((float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f - (float)height / 2.0f), width, height, message, currentlySelectedModeSupplier, currentlyHoveredModeCallback, currentlyClickedModeCallback, modes, sectionArcAngle, sectionStartAngle, hideInactiveIcons, innerSelectionRadius, outerSelectionRadius, keepSelectionWhenBeyondOuterSelectionRadius, innerRadius, outerRadius, iconSize, iconScaleFactor, iconTextSpacer, fontRenderer);
    }

    public void m_86412_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int hoveredItemIndex;
        IRenderableMode current = this.currentlySelectedModeSupplier.get();
        int selectableItemCount = this.modes.size();
        if (selectableItemCount == 0) {
            return;
        }
        float centerX = (float)this.m_252754_() + (float)this.f_93618_ / 2.0f;
        float centerY = (float)this.m_252907_() + (float)this.f_93619_ / 2.0f;
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        poseStack.m_252880_(centerX, centerY, 0.0f);
        float itemArcAngle = this.sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialSelectionWidget.calculateMouseAngle(mouseX, mouseY, centerX, centerY);
        float mouseRadius = RadialSelectionWidget.calculateMouseRadius(mouseX, mouseY, centerX, centerY);
        float inSectionMouseAngle = mouseAngle - this.sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= this.sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius && mouseRadius <= this.outerSelectionRadius;
        int n = hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        if (!isMouseInSection && current != null && this.modes.contains(current) && this.keepSelectionWhenBeyondOuterSelectionRadius && mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius) {
            isMouseInSection = true;
            hoveredItemIndex = this.modes.indexOf(current);
        }
        RenderSystem.m_69478_();
        int renderableHoveredItemIndex = hoveredItemIndex;
        this.modes.forEach(mode -> {
            int modeIndex = this.modes.indexOf(mode);
            boolean isSelected = current != null && mode == current;
            boolean isHovered = renderableHoveredItemIndex == modeIndex;
            float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + this.sectionStartAngle;
            if (mode.isActive()) {
                RadialSelectionWidget.drawSelectableSection(poseStack, this.sectionArcAngle, this.innerRadius, this.outerRadius, selectableItemCount, itemTargetAngle, isSelected, isHovered);
            } else {
                RadialSelectionWidget.drawDeactivatedSection(poseStack, this.sectionArcAngle, this.innerRadius, this.outerRadius, selectableItemCount, itemTargetAngle);
            }
        });
        RenderSystem.m_69461_();
        if (isMouseInSection && hoveredItemIndex >= 0 && hoveredItemIndex < this.modes.size() && this.modes.get(hoveredItemIndex).isActive()) {
            if (IClientConfiguration.getInstance().getEnableMouseIndicatorInRadialMenu().get().booleanValue()) {
                float startOfMouseArcAngle = mouseAngle - itemArcAngle / 2.0f;
                float mouseArcAngle = itemArcAngle;
                if (this.sectionArcAngle != 360.0f) {
                    if (startOfMouseArcAngle < this.sectionStartAngle) {
                        mouseArcAngle -= this.sectionStartAngle - startOfMouseArcAngle;
                        startOfMouseArcAngle = this.sectionStartAngle;
                    }
                    if (startOfMouseArcAngle + mouseArcAngle > this.sectionStartAngle + this.sectionArcAngle) {
                        mouseArcAngle = this.sectionStartAngle + this.sectionArcAngle - startOfMouseArcAngle;
                    }
                }
                RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
                RadialSelectionWidget.drawTorus(poseStack, startOfMouseArcAngle - 90.0f, mouseArcAngle, this.innerRadius, this.outerRadius);
            }
            if (hoveredItemIndex >= 0 && this.modes.get(hoveredItemIndex) != current) {
                this.currentlyHoveredModeCallback.accept(this.modes.get(hoveredItemIndex));
            }
        } else if (current != null) {
            this.currentlyHoveredModeCallback.accept(null);
        }
        this.modes.forEach(mode -> {
            if (mode.isActive()) {
                int modeIndex = this.modes.indexOf(mode);
                float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + this.sectionStartAngle;
                this.renderModeIcon(poseStack, this.innerRadius, this.outerRadius, itemTargetAngle, this.iconScaleFactor, this.iconTextSpacer, (IRenderableMode)mode, this.fontRenderer);
            }
        });
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public void m_87963_(@NotNull PoseStack p_268228_, int p_268034_, int p_268009_, float p_268085_) {
    }

    private static float calculateMouseAngle(float mouseX, float mouseY, float centerX, float centerY) {
        float mouseAngle;
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        for (mouseAngle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff)) - 270.0f; mouseAngle < 0.0f; mouseAngle += 360.0f) {
        }
        return mouseAngle;
    }

    private static float calculateMouseRadius(float mouseX, float mouseY, float centerX, float centerY) {
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private static void drawSelectableSection(@NotNull PoseStack stack, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle, boolean isSelected, boolean isHovered) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.m_157429_((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
        RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        if (isSelected) {
            RenderSystem.m_157429_((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
        if (isHovered) {
            RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
            RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
    }

    private static void drawDeactivatedSection(@NotNull PoseStack stack, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.m_157429_((float)0.1f, (float)0.1f, (float)0.1f, (float)0.1f);
        RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
    }

    private static void drawTorus(PoseStack matrix, float startAngle, float sizeAngle, float inner, float outer) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        vertexBuffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        float draws = 720.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float angle = (float)Math.toRadians(startAngle + (float)i / 720.0f * 360.0f);
            vertexBuffer.m_252986_(matrix4f, (float)((double)outer * Math.cos(angle)), (float)((double)outer * Math.sin(angle)), 0.0f).m_5752_();
            vertexBuffer.m_252986_(matrix4f, (float)((double)inner * Math.cos(angle)), (float)((double)inner * Math.sin(angle)), 0.0f).m_5752_();
            ++i;
        }
        BufferBuilder.RenderedBuffer buffer = vertexBuffer.m_231175_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer);
    }

    private void renderModeIcon(@NotNull PoseStack stack, float innerRadius, float outerRadius, float itemTargetAngle, float iconScaleFactor, int iconTextSpacer, @NotNull IRenderableMode mode, Font fontRenderer) {
        int n;
        float workingAngle;
        for (workingAngle = itemTargetAngle - 90.0f; workingAngle < 0.0f; workingAngle += 360.0f) {
        }
        float itemCenterX = (float)Math.cos(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        float itemCenterY = (float)Math.sin(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        Component name = mode.getMultiLineDisplayName();
        List lines = fontRenderer.m_92923_((FormattedText)name, 75);
        if (mode.shouldRenderDisplayNameInMenu()) {
            float f = this.iconSize * iconScaleFactor + (float)iconTextSpacer;
            Objects.requireNonNull(fontRenderer);
            n = (int)(f + (float)(9 * lines.size()));
        } else {
            n = (int)(this.iconSize * iconScaleFactor);
        }
        int itemHeight = n;
        float iconStartX = itemCenterX - this.iconSize * iconScaleFactor / 2.0f;
        float iconStartY = itemCenterY - (float)itemHeight / 2.0f;
        stack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)((float)mode.getColorVector().m_7096_()), (float)((float)mode.getColorVector().m_7098_()), (float)((float)mode.getColorVector().m_7094_()), (float)((float)mode.getAlphaChannel()));
        RenderSystem.m_157456_((int)0, (ResourceLocation)mode.getIcon());
        RadialSelectionWidget.m_93160_((PoseStack)stack, (int)((int)iconStartX), (int)((int)iconStartY), (int)((int)(this.iconSize * iconScaleFactor)), (int)((int)(this.iconSize * iconScaleFactor)), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        stack.m_85836_();
        if (mode.shouldRenderDisplayNameInMenu()) {
            stack.m_252880_(itemCenterX, itemCenterY, 0.0f);
            stack.m_85841_(0.6f * iconScaleFactor, 0.6f * iconScaleFactor, 0.6f * iconScaleFactor);
            int offset = 0;
            for (FormattedCharSequence line : lines) {
                fontRenderer.m_92877_(stack, line, (float)fontRenderer.m_92724_(line) / -2.0f, (float)(iconTextSpacer + offset), -855638017);
                Objects.requireNonNull(fontRenderer);
                offset += 9;
            }
        }
        stack.m_85849_();
        stack.m_85849_();
    }

    protected boolean m_7972_(int usedButton) {
        return usedButton == 0;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        int hoveredItemIndex;
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        int selectableItemCount = this.modes.size();
        if (selectableItemCount == 0) {
            return false;
        }
        float itemArcAngle = this.sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialSelectionWidget.calculateMouseAngle((float)mouseX, (float)mouseY, this.centerX, this.centerY);
        float mouseRadius = RadialSelectionWidget.calculateMouseRadius((float)mouseX, (float)mouseY, this.centerX, this.centerY);
        float inSectionMouseAngle = mouseAngle - this.sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= this.sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius && mouseRadius <= this.outerSelectionRadius;
        int n = hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        if (hoveredItemIndex == -1) {
            return false;
        }
        this.currentlyClickedModeCallback.accept(this.modes.get(hoveredItemIndex));
        return true;
    }
}

