/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import mod.chiselsandbits.storage.IMultiThreadedStorageEngine;
import mod.chiselsandbits.storage.IStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.IThreadAwareStorageEngine;
import mod.chiselsandbits.storage.MultiThreadAwareStorageEngine;
import mod.chiselsandbits.storage.VersionedStorageEngine;

public class StorageEngineBuilder {
    private final LinkedList<IStorageHandler<?>> storageHandlers = new LinkedList();
    private int minimalVersion = 0;

    private StorageEngineBuilder() {
    }

    public static StorageEngineBuilder create() {
        return new StorageEngineBuilder();
    }

    public StorageEngineBuilder minimalVersion(int version) {
        this.minimalVersion = version;
        return this;
    }

    public StorageEngineBuilder with(IStorageHandler<?> handler) {
        this.storageHandlers.add(handler);
        return this;
    }

    public IStorageEngine build() {
        return new VersionedStorageEngine(this.minimalVersion, this.storageHandlers);
    }

    public IThreadAwareStorageEngine buildThreadAware() {
        return new VersionedStorageEngine(this.minimalVersion, this.storageHandlers);
    }

    public IMultiThreadedStorageEngine buildMultiThreaded(Executor gameExecutor) {
        return new MultiThreadAwareStorageEngine(this.buildThreadAware(), gameExecutor);
    }
}

