/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.util.IWorldObject;
import net.minecraft.world.phys.Vec3;

public class WorldObjectUtils {
    private WorldObjectUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: WorldObjectUtils. This is a utility class");
    }

    public static boolean isInsideOrCoveredBy(IWorldObject a, IWorldObject b) {
        return WorldObjectUtils.isAInsideOrCoveredByB(a, b) || WorldObjectUtils.isAInsideOrCoveredByB(b, a);
    }

    public static boolean isAInsideOrCoveredByB(IWorldObject a, IWorldObject b) {
        return WorldObjectUtils.isAInsideB(a, b) || WorldObjectUtils.isACoveringB(a, b);
    }

    public static boolean isAInsideB(IWorldObject a, IWorldObject b) {
        Vec3 aStart = a.getInWorldStartPoint();
        Vec3 aEnd = a.getInWorldEndPoint();
        Vec3 bStart = b.getInWorldStartPoint();
        Vec3 bEnd = b.getInWorldEndPoint();
        return bStart.m_7096_() <= aStart.m_7096_() && aEnd.m_7096_() <= bEnd.m_7096_() && bStart.m_7098_() <= aStart.m_7098_() && aEnd.m_7098_() <= bEnd.m_7098_() && bStart.m_7094_() <= aStart.m_7094_() && aEnd.m_7094_() <= bEnd.m_7094_();
    }

    public static boolean isACoveringB(IWorldObject a, IWorldObject b) {
        Vec3 bLowerLeftFront = b.getInWorldStartPoint();
        Vec3 bUpperRightBack = b.getInWorldEndPoint();
        Vec3 bLowerLeftBack = new Vec3(bLowerLeftFront.m_7096_(), bLowerLeftFront.m_7098_(), bUpperRightBack.m_7094_());
        Vec3 bUpperLeftFront = new Vec3(bLowerLeftFront.m_7096_(), bUpperRightBack.m_7098_(), bLowerLeftFront.m_7094_());
        Vec3 bLowerRightFront = new Vec3(bUpperRightBack.m_7096_(), bLowerLeftFront.m_7098_(), bLowerLeftFront.m_7094_());
        Vec3 bUpperLeftBack = new Vec3(bLowerLeftFront.m_7096_(), bUpperRightBack.m_7098_(), bUpperRightBack.m_7094_());
        Vec3 bLowerRightBack = new Vec3(bUpperRightBack.m_7096_(), bLowerLeftFront.m_7098_(), bUpperRightBack.m_7094_());
        Vec3 bUpperRightFront = new Vec3(bUpperRightBack.m_7096_(), bUpperRightBack.m_7098_(), bLowerLeftFront.m_7094_());
        return WorldObjectUtils.isPointInside(a, bLowerLeftFront) || WorldObjectUtils.isPointInside(a, bUpperRightBack) || WorldObjectUtils.isPointInside(a, bLowerLeftBack) || WorldObjectUtils.isPointInside(a, bLowerRightFront) || WorldObjectUtils.isPointInside(a, bUpperLeftFront) || WorldObjectUtils.isPointInside(a, bLowerRightBack) || WorldObjectUtils.isPointInside(a, bUpperLeftBack) || WorldObjectUtils.isPointInside(a, bUpperRightFront);
    }

    public static boolean isPointInside(IWorldObject a, Vec3 point) {
        Vec3 aStart = a.getInWorldStartPoint();
        Vec3 aEnd = a.getInWorldEndPoint();
        return aStart.m_7096_() <= point.m_7096_() && point.m_7096_() <= aEnd.m_7096_() && aStart.m_7098_() <= point.m_7098_() && point.m_7098_() <= aEnd.m_7098_() && aStart.m_7094_() <= point.m_7094_() && point.m_7094_() <= aEnd.m_7094_();
    }
}

