/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.common.TagHelper;
import shetiphian.endertanks.Values;

public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_COMMON = new ForgeConfigSpec.Builder();
    public static final Menu_General GENERAL = new Menu_General(BUILDER_CLIENT, BUILDER_COMMON);
    private static final Menu_Upgrade UPGRADE_ITEMS = new Menu_Upgrade(BUILDER_COMMON);
    public static final Menu_Settings UPGRADE_SETTINGS = new Menu_Settings(BUILDER_COMMON);
    public static final Menu_Access ACCESS_SETTINGS = new Menu_Access(BUILDER_COMMON);
    public static final Menu_Integration INTEGRATION = new Menu_Integration(BUILDER_COMMON);
    private static final Menu_Color COLOR_VALUES = new Menu_Color(BUILDER_CLIENT);
    static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    static final ForgeConfigSpec SPEC_COMMON = BUILDER_COMMON.build();
    public static boolean CAN_PROCESS_TAGS = false;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.process_client();
        }
        if (config.getType() == ModConfig.Type.COMMON && Configuration.process(config.getConfigData())) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.process_client();
        }
        if (config.getType() == ModConfig.Type.COMMON && Configuration.process(config.getConfigData())) {
            config.save();
        }
    }

    private static void process_client() {
        Values.colorValues[0] = (Integer)Configuration.COLOR_VALUES.white.get();
        Values.colorValues[1] = (Integer)Configuration.COLOR_VALUES.orange.get();
        Values.colorValues[2] = (Integer)Configuration.COLOR_VALUES.magenta.get();
        Values.colorValues[3] = (Integer)Configuration.COLOR_VALUES.light_blue.get();
        Values.colorValues[4] = (Integer)Configuration.COLOR_VALUES.yellow.get();
        Values.colorValues[5] = (Integer)Configuration.COLOR_VALUES.lime.get();
        Values.colorValues[6] = (Integer)Configuration.COLOR_VALUES.pink.get();
        Values.colorValues[7] = (Integer)Configuration.COLOR_VALUES.gray.get();
        Values.colorValues[8] = (Integer)Configuration.COLOR_VALUES.light_gray.get();
        Values.colorValues[9] = (Integer)Configuration.COLOR_VALUES.cyan.get();
        Values.colorValues[10] = (Integer)Configuration.COLOR_VALUES.purple.get();
        Values.colorValues[11] = (Integer)Configuration.COLOR_VALUES.blue.get();
        Values.colorValues[12] = (Integer)Configuration.COLOR_VALUES.brown.get();
        Values.colorValues[13] = (Integer)Configuration.COLOR_VALUES.green.get();
        Values.colorValues[14] = (Integer)Configuration.COLOR_VALUES.red.get();
        Values.colorValues[15] = (Integer)Configuration.COLOR_VALUES.black.get();
    }

    private static boolean process(CommentedConfig config) {
        int capMax;
        int capMin;
        int tankMax;
        boolean save = false;
        int tankMin = (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMin.get();
        if (tankMin > (tankMax = ((Integer)Configuration.UPGRADE_SETTINGS.tankSizeMax.get()).intValue())) {
            config.set("capacity_settings.tank_size_min", (Object)tankMax);
            config.set("capacity_settings.tank_size_max", (Object)tankMin);
            save = true;
        }
        if ((capMin = ((Integer)Configuration.UPGRADE_SETTINGS.smallCapacity.get()).intValue()) > (capMax = ((Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get()).intValue())) {
            config.set("capacity_settings.small_capacity_upgrade", (Object)capMax);
            config.set("capacity_settings.large_capacity_upgrade", (Object)capMin);
            save = true;
        }
        if (CAN_PROCESS_TAGS) {
            Configuration.processTagLists();
        }
        return save;
    }

    public static void processTagLists() {
        Configuration.process((List)Configuration.UPGRADE_ITEMS.personal.get(), Values.listPersonal, Items.f_42415_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.team.get(), Values.listTeam, Items.f_42616_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.sCapacity_multi.get(), Values.listSmallCap_Multi, Items.f_42584_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.lCapacity_multi.get(), Values.listLargeCap_Multi, Items.f_42545_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.pump_multi.get(), Values.listPump_Multi, Items.f_41869_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.sCapacity_single.get(), Values.listSmallCap_Single, null);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.lCapacity_single.get(), Values.listLargeCap_Single, null);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.pump_single.get(), Values.listPump_Single, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void process(List<? extends String> names, ArrayList<Item> list, Item basic) {
        list.clear();
        for (String string : names) {
            void var4_4;
            if (Strings.isNullOrEmpty((String)string)) continue;
            boolean isTag = false;
            if (string.toLowerCase().startsWith("tag|")) {
                isTag = true;
                String string2 = string.substring(4);
            }
            if (isTag) {
                TagHelper.getItems((String)var4_4).forEach(item -> Configuration.addToList(item, list));
                continue;
            }
            Configuration.addToList((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)var4_4)), list);
        }
        if (list.isEmpty() && basic != null) {
            list.add(basic);
        }
    }

    private static void addToList(Item item, ArrayList<Item> list) {
        if (list != null && item != null && !list.contains(item)) {
            list.add(item);
        }
    }

    private static class Menu_Color {
        ForgeConfigSpec.IntValue white;
        ForgeConfigSpec.IntValue orange;
        ForgeConfigSpec.IntValue magenta;
        ForgeConfigSpec.IntValue light_blue;
        ForgeConfigSpec.IntValue yellow;
        ForgeConfigSpec.IntValue lime;
        ForgeConfigSpec.IntValue pink;
        ForgeConfigSpec.IntValue gray;
        ForgeConfigSpec.IntValue light_gray;
        ForgeConfigSpec.IntValue cyan;
        ForgeConfigSpec.IntValue purple;
        ForgeConfigSpec.IntValue blue;
        ForgeConfigSpec.IntValue brown;
        ForgeConfigSpec.IntValue green;
        ForgeConfigSpec.IntValue red;
        ForgeConfigSpec.IntValue black;

        Menu_Color(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Color Values for Bands,", "Format: Decimal Values (0 to 16,777,215)", "You can use this website to get the decimal value of any color:", "http://www.colorhexa.com", "Or by using the Color Mixer from this website:", "http://www.mathsisfun.com/hexadecimal-decimal-colors.html"}).push("color_values");
            this.white = builder.defineInRange("white", 0xFFFFFF, 0, 0xFFFFFF);
            this.orange = builder.defineInRange("orange", 14517579, 0, 0xFFFFFF);
            this.magenta = builder.defineInRange("magenta", 12411333, 0, 0xFFFFFF);
            this.light_blue = builder.defineInRange("light_blue", 8296912, 0, 0xFFFFFF);
            this.yellow = builder.defineInRange("yellow", 12892206, 0, 0xFFFFFF);
            this.lime = builder.defineInRange("lime", 4832573, 0, 0xFFFFFF);
            this.pink = builder.defineInRange("pink", 14195370, 0, 0xFFFFFF);
            this.gray = builder.defineInRange("gray", 0x464646, 0, 0xFFFFFF);
            this.light_gray = builder.defineInRange("light_gray", 0xA9AFAF, 0, 0xFFFFFF);
            this.cyan = builder.defineInRange("cyan", 3373205, 0, 0xFFFFFF);
            this.purple = builder.defineInRange("purple", 8996546, 0, 0xFFFFFF);
            this.blue = builder.defineInRange("blue", 3292826, 0, 0xFFFFFF);
            this.brown = builder.defineInRange("brown", 5650466, 0, 0xFFFFFF);
            this.green = builder.defineInRange("green", 3821086, 0, 0xFFFFFF);
            this.red = builder.defineInRange("red", 0xA53A35, 0, 0xFFFFFF);
            this.black = builder.defineInRange("black", 0x262626, 0, 0xFFFFFF);
            builder.pop();
        }
    }

    public static class Menu_Settings {
        public ForgeConfigSpec.IntValue tankPumpMax;
        public ForgeConfigSpec.IntValue tankSizeMin;
        public ForgeConfigSpec.IntValue tankSizeMax;
        public ForgeConfigSpec.IntValue smallCapacity;
        public ForgeConfigSpec.IntValue largeCapacity;

        Menu_Settings(ForgeConfigSpec.Builder builder) {
            builder.comment("Set the number of buckets a tank holds, how many pump upgrades can be applied, and the value of a storage upgrade").push("capacity_settings");
            this.tankPumpMax = builder.comment(new String[]{"How many internal transfer pump upgrades can a tank have?", " default is only 1/4 bucket, upgrades make it a bucket per upgrade"}).defineInRange("tank_pump_max", 4, 0, 8);
            this.tankSizeMin = builder.comment("Minimum capacity an EnderTank holds").defineInRange("tank_size_min", 32, 4, 128);
            this.tankSizeMax = builder.comment("Maximum capacity an EnderTank holds").defineInRange("tank_size_max", 256, 4, 512);
            this.smallCapacity = builder.comment("Capacity increased by small capacity upgrade items").defineInRange("small_capacity_upgrade", 8, 2, 16);
            this.largeCapacity = builder.comment("Capacity increased by large capacity upgrade items").defineInRange("large_capacity_upgrade", 16, 4, 32);
            builder.pop();
        }
    }

    private static class Menu_Upgrade {
        ForgeConfigSpec.ConfigValue<List<? extends String>> personal;
        ForgeConfigSpec.ConfigValue<List<? extends String>> team;
        ForgeConfigSpec.ConfigValue<List<? extends String>> sCapacity_multi;
        ForgeConfigSpec.ConfigValue<List<? extends String>> lCapacity_multi;
        ForgeConfigSpec.ConfigValue<List<? extends String>> pump_multi;
        ForgeConfigSpec.ConfigValue<List<? extends String>> sCapacity_single;
        ForgeConfigSpec.ConfigValue<List<? extends String>> lCapacity_single;
        ForgeConfigSpec.ConfigValue<List<? extends String>> pump_single;
        private Predicate<Object> validator = object -> {
            if (object instanceof String) {
                String string = (String)object;
                return Strings.isNullOrEmpty((String)string) || string.split(":").length == 2;
            }
            return false;
        };

        Menu_Upgrade(ForgeConfigSpec.Builder builder) {
            builder.comment("Items used to upgrade the EnderTanks").push("upgrade_items");
            this.personal = builder.comment("Items used to make the tanks personal").defineList("personal", this.getListOf("tag|forge:gems/diamond"), this.validator);
            this.team = builder.comment("Items used to make the tanks team tanks").defineList("team", this.getListOf("tag|forge:gems/emerald"), this.validator);
            this.sCapacity_multi = builder.comment("Items that apply a small storage capacity upgrade").defineList("small_capacity", this.getListOf("minecraft:ender_pearl"), this.validator);
            this.lCapacity_multi = builder.comment("Items that apply a large storage capacity upgrade").defineList("large_capacity", this.getListOf("minecraft:ender_eye"), this.validator);
            this.pump_multi = builder.comment("Items that are used to increase the tanks internal transfer pump").defineList("pump", this.getListOf("minecraft:piston"), this.validator);
            this.sCapacity_single = builder.comment(new String[]{"Items that apply a small storage capacity upgrade", "Each item can only be use once per tank"}).defineList("small_capacity_singleuse", new ArrayList(), this.validator);
            this.lCapacity_single = builder.comment(new String[]{"Items that apply a large storage capacity upgrade", "Each item can only be use once per tank"}).defineList("large_capacity_singleuse", new ArrayList(), this.validator);
            this.pump_single = builder.comment(new String[]{"Items that are used to increase the tanks internal transfer pump", "Each item can only be use once per tank"}).defineList("pump_singleuse", new ArrayList(), this.validator);
            builder.pop();
        }

        private List<String> getListOf(String ... values) {
            return new ArrayList<String>(Arrays.asList(values));
        }
    }

    public static class Menu_General {
        public ForgeConfigSpec.IntValue lineChangeDelay;
        public ForgeConfigSpec.BooleanValue enableInWorldRecoloring;

        Menu_General(ForgeConfigSpec.Builder client_builder, ForgeConfigSpec.Builder common_builder) {
            this.lineChangeDelay = client_builder.comment("Delay, in milliseconds, before a multi-line tank info request will display the next line").defineInRange("info_line_change_delay", 1500, 250, 10000);
            this.enableInWorldRecoloring = common_builder.comment("With this disabled tanks are essentially locked to the crafted color as dyes will no longer work").define("enable_in_world_coloring", true);
        }
    }

    public static class Menu_Access {
        public ForgeConfigSpec.BooleanValue allowPublicTanks;
        public ForgeConfigSpec.BooleanValue allowPersonalTanks;
        public ForgeConfigSpec.BooleanValue allowTeamTanks;
        public ForgeConfigSpec.BooleanValue allowPublicBuckets;
        public ForgeConfigSpec.BooleanValue allowPersonalBuckets;
        public ForgeConfigSpec.BooleanValue allowTeamBuckets;
        public ForgeConfigSpec.BooleanValue enableAutomationPublic;
        public ForgeConfigSpec.BooleanValue enableAutomationPersonal;
        public ForgeConfigSpec.BooleanValue enableAutomationTeam;
        public ForgeConfigSpec.BooleanValue lockPersonalEdit;
        public ForgeConfigSpec.BooleanValue lockTeamEdit;
        public ForgeConfigSpec.BooleanValue lockPersonalLink;
        public ForgeConfigSpec.BooleanValue lockTeamLink;
        public ForgeConfigSpec.BooleanValue lockPersonalUse;
        public ForgeConfigSpec.BooleanValue lockTeamUse;

        Menu_Access(ForgeConfigSpec.Builder builder) {
            builder.push("access_settings");
            this.allowPublicTanks = builder.comment("Enables the usage of public tanks, if disabled tanks must be upgraded before use").define("public_tanks", true);
            this.allowPersonalTanks = builder.comment(new String[]{"Enables the creation of personal tanks, if disabled tanks can not set personal.", "Does not effect tanks that are already set as personal"}).define("personal_tanks", true);
            this.allowTeamTanks = builder.comment(new String[]{"Enables the creation of team tanks, if disabled tanks can not be set team.", "Does not effect tanks that are already set as team"}).define("team_tanks", true);
            this.allowPublicBuckets = builder.comment("Enables the usage of public buckets, if disabled buckets must be linked to an upgraded tank before use").define("public_buckets", true);
            this.allowPersonalBuckets = builder.comment(new String[]{"Enables the linking of buckets to personal tanks.", "Does not effect buckets that are already linked to personal tanks"}).define("personal_buckets", true);
            this.allowTeamBuckets = builder.comment(new String[]{"Enables the linking of buckets to team tanks.", "Does not effect buckets that are already linked to team tanks"}).define("team_buckets", true);
            this.enableAutomationPublic = builder.comment(new String[]{"Public tanks can be used with automation.", "The internal pump is unaffected by this setting"}).define("public_automation", true);
            this.enableAutomationPersonal = builder.comment(new String[]{"Personal tanks can be used with automation.", "The internal pump is unaffected by this setting"}).define("personal_automation", true);
            this.enableAutomationTeam = builder.comment(new String[]{"Team tanks can be used with automation.", "The internal pump is unaffected by this setting"}).define("team_automation", true);
            this.lockPersonalEdit = builder.comment("While true a Personal tank can only be edited (upgrade, move, etc) by the owner").define("personal_edit_lock", true);
            this.lockTeamEdit = builder.comment("While true a Team tank can only be edited (upgrade, move, etc) by a team member").define("team_edit_lock", true);
            this.lockPersonalLink = builder.comment("While true only the owner can link a bucket to their tanks").define("personal_link_lock", true);
            this.lockTeamLink = builder.comment("While true only a team member can link a bucket to team tanks").define("team_link_lock", true);
            this.lockPersonalUse = builder.comment("While true only the owner can use the tank").define("personal_use_lock", false);
            this.lockTeamUse = builder.comment("While true only a team member can use the tank").define("team_use_lock", false);
            builder.pop();
        }
    }

    public static class Menu_Integration {
        public ForgeConfigSpec.BooleanValue storeMekanismGas;
        public ForgeConfigSpec.BooleanValue storeMekanismInfusion;
        public ForgeConfigSpec.BooleanValue storeMekanismPigment;
        public ForgeConfigSpec.BooleanValue storeMekanismSlurry;

        Menu_Integration(ForgeConfigSpec.Builder builder) {
            builder.comment("Mod integration can be disabled to solve compatibility issues, remove unwanted/unneeded features, etc.").push("integration");
            this.storeMekanismGas = builder.define("store_mekanism_gas", true);
            this.storeMekanismInfusion = builder.define("store_mekanism_infusion", true);
            this.storeMekanismPigment = builder.define("store_mekanism_pigment", true);
            this.storeMekanismSlurry = builder.define("store_mekanism_slurry", true);
            builder.pop();
        }
    }
}

