/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.api;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.capabilities.Capability;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;

public class HandlerRegistry {
    private static final HashMap<String, ITankHandlerProvider<?>> PROVIDERS = new HashMap();
    private static final HashMap<String, Capability<?>> LOOKUP = new HashMap();
    private static String DEFAULT_KEY;

    public static <T> boolean register(Capability<T> capability, ITankHandlerProvider<T> provider) {
        String name = HandlerRegistry.getKey(capability);
        if (Strings.isNullOrEmpty((String)DEFAULT_KEY)) {
            DEFAULT_KEY = name;
        }
        if (!PROVIDERS.containsKey(name)) {
            PROVIDERS.put(name, provider);
            LOOKUP.put(name, capability);
            return true;
        }
        return false;
    }

    public static Map<String, ITankHandlerProvider<?>> getProviders() {
        return Collections.unmodifiableMap(PROVIDERS);
    }

    public static String getDefaultKey() {
        return DEFAULT_KEY;
    }

    public static Capability<?> getCapabilityFor(String name) {
        return LOOKUP.get(name);
    }

    public static ITankHandler<?> createHandlerFor(Capability<?> capability, IEnderTankInfo tank) {
        return HandlerRegistry.createHandlerFor(HandlerRegistry.getKey(capability), tank);
    }

    public static ITankHandler<?> createHandlerFor(Class<?> type, IEnderTankInfo tank) {
        return HandlerRegistry.createHandlerFor(HandlerRegistry.getKey(type), tank);
    }

    public static ITankHandler<?> createHandlerFor(String name, IEnderTankInfo tank) {
        ITankHandlerProvider<?> provider = PROVIDERS.get(name);
        return provider != null ? provider.create(tank) : null;
    }

    public static String getKey(Capability<?> capability) {
        return capability.getName().replace("/", ".");
    }

    public static String getKey(Class<?> type) {
        return type.getName().intern();
    }

    public static interface ITankHandlerProvider<Type> {
        public ITankHandler<Type> create(IEnderTankInfo var1);
    }
}

