/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.item.IToolMode;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.client.render.RenderRegistry;
import shetiphian.endertanks.common.item.EnderFluidHandlerItemStack;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemEnderBucket
extends Item
implements ITabFiller,
IColored,
IToolMode {
    public ItemEnderBucket(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)((Object)this), (Object)"type", (stack, world, entity, number) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f))));
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.m_246342_(ItemEnderBucket.setMode(StackHelper.create(this, code, null), EnumMode.NORMAL));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBuckets.get()).booleanValue() && StackHelper.isPublic(stack)) {
            if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBuckets.get()).booleanValue()) {
                String teamID = Function.getPlayerTeamID((Player)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.m_20148_().toString());
            }
        }
        ItemEnderBucket.setMode(stack, EnumMode.NORMAL);
    }

    @Nonnull
    private static CompoundTag getTag(@Nonnull ItemStack stack) {
        CompoundTag nbtTag = stack.m_41784_();
        if (!nbtTag.m_128441_("mode")) {
            nbtTag.m_128359_("mode", EnumMode.NORMAL.toString());
        }
        return nbtTag;
    }

    public static EnumMode getMode(ItemStack stack) {
        return EnumMode.byName(ItemEnderBucket.getTag(stack).m_128461_("mode"));
    }

    private static ItemStack setMode(ItemStack stack, EnumMode type) {
        ItemEnderBucket.getTag(stack).m_128359_("mode", type.toString());
        return stack;
    }

    public boolean changeMode(Player player, ItemStack stack, boolean reverse) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemEnderBucket) {
            EnumMode mode = ItemEnderBucket.getMode(stack).next(reverse);
            ItemEnderBucket.setMode(stack, mode);
            if (player != null) {
                TankInfoHelper.sendInfo(player, Component.m_237115_((String)mode.getTooltip()));
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_()) {
            boolean placeFluid = ItemEnderBucket.getMode(stack).preformPlace(player.m_6144_());
            BlockPos pos = null;
            boolean hitTypeBlock = false;
            Direction facing = Direction.m_235672_((RandomSource)world.f_46441_);
            BlockHitResult mop = ItemEnderBucket.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(!placeFluid ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
            if (mop != null && mop.m_6662_() != HitResult.Type.MISS) {
                hitTypeBlock = true;
                pos = mop.m_82425_();
                facing = mop.m_82434_();
            }
            if (pos != null && world.m_8055_(pos).m_60734_() == Roster.Blocks.ENDERTANK.get()) {
                BlockEntity tile;
                if (placeFluid && (tile = world.m_7702_(pos)) instanceof TileEntityEnderTank) {
                    TileEntityEnderTank tankTile = (TileEntityEnderTank)tile;
                    if (tankTile.hasError()) {
                        TankInfoHelper.sendLinkError(player, 2);
                    } else {
                        if (tankTile.canLink(player)) {
                            return InteractionResultHolder.m_19090_((Object)StackHelper.create(this, tankTile.getCode(), tankTile.getOwnerID()));
                        }
                        TankInfoHelper.sendLinkError(player, tankTile.isTeam() ? 3 : 1);
                    }
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (!StackHelper.isPublic(stack) || ((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBuckets.get()).booleanValue()) {
                boolean showInfo = true;
                if (pos != null) {
                    showInfo = placeFluid ? this.placeLiquid(stack, player, hand, world, pos, facing, hitTypeBlock) : this.pickupLiquid(stack, player, hand, world, pos, facing);
                }
                if (showInfo) {
                    String[] network = new String[]{StackHelper.getOwnerID(stack), StackHelper.getCode(stack)};
                    TankInfoHelper.sendTankInfo(player, StackHelper.getOwnerName(stack), network[0], network[1], player.m_6144_());
                }
            } else {
                TankInfoHelper.sendError(player, "endertanks.bucket.public.disabled");
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private boolean pickupLiquid(ItemStack stack, Player player, InteractionHand hand, Level world, BlockPos pos, Direction facing) {
        if (player.m_36204_(pos, facing, stack)) {
            FlowingFluid fluid;
            BlockState state;
            int getAmount;
            IFluidHandler bucketTank = TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(IFluidHandler.class);
            if (bucketTank == null) {
                return false;
            }
            IFluidHandler fromHandler = CapabilityHelper.FLUIDS.getHandler((LevelAccessor)world, pos, facing);
            FluidStack bucketLiquid = bucketTank.getFluidInTank(0);
            int n = getAmount = !bucketLiquid.isEmpty() ? Math.min(1000, bucketTank.getTankCapacity(0) - bucketLiquid.getAmount()) : 1000;
            if (fromHandler != null) {
                FluidStack getLiquid = FluidUtil.tryFluidTransfer((IFluidHandler)bucketTank, (IFluidHandler)fromHandler, (int)getAmount, (boolean)true);
                if (!getLiquid.isEmpty()) {
                    world.m_5594_(player, pos, getLiquid.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        bucketTank.drain(getLiquid, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return true;
                }
            } else if (getAmount >= 1000 && (state = world.m_8055_(pos)).m_60734_() instanceof LiquidBlock && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0 && (fluid = ((LiquidBlock)state.m_60734_()).getFluid()) != null && (bucketLiquid.isEmpty() || bucketLiquid.getFluid().equals(fluid))) {
                ((LiquidBlock)state.m_60734_()).m_142598_((LevelAccessor)world, pos, state);
                world.m_5594_(player, pos, fluid.getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    bucketTank.fill(new FluidStack((Fluid)fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        }
        return false;
    }

    private boolean placeLiquid(ItemStack stack, Player player, InteractionHand hand, Level world, BlockPos pos, Direction facing, boolean hitTypeBlock) {
        FluidStack placeLiquid;
        BlockPos sPos;
        IFluidHandler bucketTank = TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(IFluidHandler.class);
        if (bucketTank == null) {
            return false;
        }
        FluidStack bucketLiquid = bucketTank.getFluidInTank(0);
        int putAmount = !bucketLiquid.isEmpty() ? Math.min(1000, bucketLiquid.getAmount()) : 0;
        IFluidHandler toHandler = CapabilityHelper.FLUIDS.getHandler((LevelAccessor)world, pos, facing);
        if (toHandler != null) {
            FluidStack putLiquid;
            if (player.m_36204_(pos, facing, stack) && !(putLiquid = FluidUtil.tryFluidTransfer((IFluidHandler)toHandler, (IFluidHandler)bucketTank, (int)putAmount, (boolean)true)).isEmpty()) {
                world.m_5594_(player, pos, putLiquid.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player.m_150110_().f_35937_) {
                    bucketTank.fill(putLiquid, IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        } else if (putAmount >= 1000 && hitTypeBlock && player.m_36204_(sPos = pos.m_121945_(facing), facing, stack) && FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)sPos, (ItemStack)stack, (FluidStack)(placeLiquid = bucketTank.drain(1000, IFluidHandler.FluidAction.SIMULATE))).isSuccess()) {
            world.m_46586_(sPos, Blocks.f_50016_, sPos);
            if (player.m_150110_().f_35937_) {
                bucketTank.fill(placeLiquid, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return stack.m_41619_() ? null : new EnderFluidHandlerItemStack(stack);
    }

    public String m_5671_(ItemStack stack) {
        return "item.endertanks.bucket." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.code")).m_7220_((Component)Component.m_237113_((String)(" " + StackHelper.getCode(stack)))));
        Component owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
        tooltip.add((Component)Component.m_237115_((String)ItemEnderBucket.getMode(stack).getTooltip()));
        ADD_CHANGE_INSTRUCTIONS.accept(tooltip, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.m_41619_()) {
            int value = Mth.m_14045_((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    private static enum EnumMode {
        NORMAL("info.endertanks.bucket.mode.normal"),
        INVERT("info.endertanks.bucket.mode.invert"),
        PICKUP("info.endertanks.bucket.mode.pickup"),
        PLACE("info.endertanks.bucket.mode.place");

        private final String tooltip;

        private EnumMode(String tooltip) {
            this.tooltip = tooltip;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static EnumMode byName(String name) {
            for (EnumMode entry : EnumMode.values()) {
                if (!entry.toString().equalsIgnoreCase(name)) continue;
                return entry;
            }
            return NORMAL;
        }

        private EnumMode next(boolean reverse) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> {
                    if (reverse) {
                        yield PLACE;
                    }
                    yield INVERT;
                }
                case INVERT -> {
                    if (reverse) {
                        yield NORMAL;
                    }
                    yield PICKUP;
                }
                case PICKUP -> {
                    if (reverse) {
                        yield INVERT;
                    }
                    yield PLACE;
                }
                case PLACE -> reverse ? PICKUP : NORMAL;
            };
        }

        private boolean preformPlace(boolean isSneaking) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> isSneaking;
                case INVERT -> {
                    if (!isSneaking) {
                        yield true;
                    }
                    yield false;
                }
                case PICKUP -> false;
                case PLACE -> true;
            };
        }
    }
}

