/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.util.ExpandNewLineTextAcceptor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class StringUtil {
    private StringUtil() {
    }

    public static Component stripStyling(Component textComponent) {
        MutableComponent text = textComponent.m_6879_();
        for (Component sibling : textComponent.m_7360_()) {
            text.m_7220_(StringUtil.stripStyling(sibling));
        }
        return text;
    }

    public static Component truncateStringToWidth(Component text, int width, Font fontRenderer) {
        int ellipsisWidth = fontRenderer.m_92895_("...");
        FormattedText truncatedText = fontRenderer.m_92854_((FormattedText)text, width - ellipsisWidth);
        String truncatedTextString = truncatedText.getString();
        return Component.m_237113_((String)(truncatedTextString + "..."));
    }

    public static List<FormattedText> splitLines(List<FormattedText> lines, int width) {
        if (width <= 0) {
            return List.copyOf(lines);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        StringSplitter splitter = font.m_92865_();
        return lines.stream().flatMap(text -> splitter.m_92414_(text, width, Style.f_131099_).stream()).toList();
    }

    public static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.m_7451_((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.f_131099_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    public static String intsToString(Collection<Integer> indexes) {
        return indexes.stream().sorted().map(i -> Integer.toString(i)).collect(Collectors.joining(", "));
    }
}

