/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.forge.platform.BrewingRecipeMaker;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.LegacyUpgradeRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class RecipeHelper
implements IPlatformRecipeHelper {
    @Override
    public <T extends CraftingRecipe> int getWidth(T recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return shapedRecipe.getRecipeWidth();
        }
        return 0;
    }

    @Override
    public <T extends CraftingRecipe> int getHeight(T recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return shapedRecipe.getRecipeHeight();
        }
        return 0;
    }

    @Override
    public Ingredient getBase(SmithingRecipe recipe) {
        if (recipe instanceof LegacyUpgradeRecipe) {
            LegacyUpgradeRecipe legacyRecipe = (LegacyUpgradeRecipe)recipe;
            return legacyRecipe.f_265911_;
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return transformRecipe.f_265888_;
        }
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return trimRecipe.f_266040_;
        }
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient getAddition(SmithingRecipe recipe) {
        if (recipe instanceof LegacyUpgradeRecipe) {
            LegacyUpgradeRecipe legacyRecipe = (LegacyUpgradeRecipe)recipe;
            return legacyRecipe.f_265910_;
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return transformRecipe.f_265907_;
        }
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return trimRecipe.f_266053_;
        }
        return Ingredient.f_43901_;
    }

    @Override
    public boolean isHandled(SmithingRecipe recipe) {
        if (recipe.m_142505_()) {
            return false;
        }
        return recipe instanceof LegacyUpgradeRecipe || recipe instanceof SmithingTransformRecipe || recipe instanceof SmithingTrimRecipe;
    }

    @Override
    public Optional<ResourceLocation> getRegistryNameForRecipe(Recipe<?> recipe) {
        ResourceLocation id = recipe.m_6423_();
        return Optional.ofNullable(id);
    }

    @Override
    public List<IJeiBrewingRecipe> getBrewingRecipes(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory) {
        return BrewingRecipeMaker.getBrewingRecipes(ingredientManager, vanillaRecipeFactory);
    }
}

