/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Constants;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class SmithingRecipeCategory
implements IRecipeCategory<SmithingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public SmithingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50625_));
    }

    @Override
    public RecipeType<SmithingRecipe> getRecipeType() {
        return RecipeTypes.SMITHING;
    }

    @Override
    public Component getTitle() {
        return Blocks.f_50625_.m_49954_();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, SmithingRecipe recipe, IFocusGroup focuses) {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipeHelper.getBase(recipe));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(recipeHelper.getAddition(recipe));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(RecipeUtil.getResultItem(recipe));
    }

    @Override
    public boolean isHandled(SmithingRecipe recipe) {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        return recipeHelper.isHandled(recipe);
    }
}

