/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.integration.jei.extension;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.api.dye.DyeableItem;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.u_team_core.util.RGB;
import info.u_team.useful_backpacks.recipe.BackpackCraftingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BackpackCraftingRecipeCategoryExtension
implements ICraftingCategoryExtension {
    private final BackpackCraftingRecipe recipe;

    public BackpackCraftingRecipeCategoryExtension(BackpackCraftingRecipe recipe) {
        this.recipe = recipe;
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }

    public int getWidth() {
        return this.recipe.getRecipeWidth();
    }

    public int getHeight() {
        return this.recipe.getRecipeHeight();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        List inputs = this.recipe.m_7527_().stream().map(ingredient -> Lists.newArrayList((Object[])ingredient.m_43908_())).collect(Collectors.toCollection(ArrayList::new));
        ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{this.recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())});
        AtomicBoolean changed = new AtomicBoolean(false);
        focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).findFirst().ifPresent(outputStack -> {
            Item patt2368$temp = outputStack.m_41720_();
            if (patt2368$temp instanceof DyeableItem) {
                DyeableItem dyeable = (DyeableItem)patt2368$temp;
                int dyeableColor = dyeable.getColor(outputStack);
                DyeColor color = ColorUtil.findClosestDyeColor((RGB)new RGB(dyeableColor));
                Block wool = ColorUtil.getWoolFromColor((DyeColor)color);
                for (int index = 0; index < inputs.size(); ++index) {
                    List list = (List)inputs.get(index);
                    if (!list.stream().allMatch(stack -> stack.m_204117_(ItemTags.f_13167_))) continue;
                    if (dyeableColor != dyeable.getDefaultColor()) {
                        inputs.set(index, List.of(new ItemStack((ItemLike)wool)));
                        continue;
                    }
                    inputs.set(index, List.of(new ItemStack((ItemLike)Blocks.f_50041_)));
                }
                outputs.set(0, DyeableItem.colorStack((ItemStack)((ItemStack)outputs.get(0)), List.of(color)));
                changed.set(true);
            }
        });
        focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).findFirst().ifPresent(inputStack -> {
            if (inputStack.m_204117_(ItemTags.f_13167_)) {
                DyeColor color = ColorUtil.getColorFromWool((Item)inputStack.m_41720_());
                if (color != null && color != DyeColor.WHITE) {
                    outputs.set(0, DyeableItem.colorStack((ItemStack)((ItemStack)outputs.get(0)), List.of(color)));
                }
                changed.set(true);
            }
        });
        if (!changed.get()) {
            Stream.of(DyeColor.values()).map(color -> {
                if (color == DyeColor.WHITE) {
                    return (ItemStack)outputs.get(0);
                }
                return DyeableItem.colorStack((ItemStack)((ItemStack)outputs.get(0)), List.of(color));
            }).forEach(outputs::add);
            outputs.remove(0);
        }
        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, this.getWidth(), this.getHeight());
        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, (List)outputs);
    }
}

