/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.api.dye.DyeableItem;
import info.u_team.u_team_core.item.UItem;
import info.u_team.useful_backpacks.config.ServerConfig;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.item.AutoPickupBackpack;
import info.u_team.useful_backpacks.menu.BackpackMenu;
import info.u_team.useful_backpacks.type.BackpackType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class BackpackItem
extends UItem
implements AutoPickupBackpack,
DyeableItem {
    private final BackpackType backpack;

    public BackpackItem(BackpackType backpack) {
        super(new Item.Properties().m_41487_(1).m_41497_(backpack.getRarity()));
        this.backpack = backpack;
        this.addColoredItem((Item)this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            this.open((ServerPlayer)player, stack, hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : -1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public void open(ServerPlayer player, ItemStack backpackStack, int selectedSlot) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> new BackpackMenu(id, playerInventory, this.getInventory(player, backpackStack), this.backpack, selectedSlot), backpackStack.m_41786_()), buffer -> {
            buffer.m_130068_((Enum)this.backpack);
            buffer.m_130130_(selectedSlot);
        });
    }

    @Override
    public Container getInventory(ServerPlayer player, ItemStack backpackStack) {
        return new BackpackInventory(backpackStack, this.backpack.getInventorySize());
    }

    @Override
    public void saveInventory(Container inventory, ItemStack backpackStack) {
        if (inventory instanceof BackpackInventory) {
            ((BackpackInventory)inventory).writeItemStack();
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        this.addTooltip(stack, level, tooltip, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public BackpackType getBackpack() {
        return this.backpack;
    }

    public int getDefaultColor() {
        return 8478784;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        if (((Boolean)ServerConfig.getInstance().shareAllNBTData.get()).booleanValue()) {
            return super.getShareTag(stack);
        }
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag compound = stack.m_41783_().m_6426_();
        compound.m_128473_("Items");
        if (compound.m_128456_()) {
            return null;
        }
        return compound;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return !(player.f_36096_ instanceof BackpackMenu);
    }
}

