/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import xaero.common.IXaeroMinimap;
import xaero.common.message.MinimapMessage;
import xaero.common.message.PacketConsumerForge;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class MinimapMessageHandler {
    public static final int NETWORK_COMPATIBILITY = 2;
    private final IXaeroMinimap modMain;

    public MinimapMessageHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public <T extends MinimapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, FriendlyByteBuf> encoder) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            this.modMain.getNetwork().registerMessage(index, type, encoder, decoder, consumer, Optional.of(clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT));
            return;
        }
        this.modMain.getNetwork().registerMessage(index, type, encoder, decoder, consumer);
    }

    public void sendToPlayer(ServerPlayer player, MinimapMessage<?> message) {
        this.modMain.getNetwork().send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public void sendToServer(MinimapMessage<?> message) {
        this.modMain.getNetwork().sendToServer(message);
    }
}

