/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.data.TypedTreeCache;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.query.EmptyRoot;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.parser.CachingParser;
import io.github.douira.glsl_transformer.parser.EnhancedParser;
import io.github.douira.glsl_transformer.parser.ParserInterface;
import io.github.douira.glsl_transformer.token_filter.TokenFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import repack.antlr.v4.runtime.ParserRuleContext;
import repack.antlr.v4.runtime.RecognitionException;

public class ASTParser
implements ParserInterface {
    private static ASTParser INSTANCE;
    private EnhancedParser parser = new CachingParser();
    private TypedTreeCache<ASTNode> buildCache = new TypedTreeCache();
    private ASTCacheStrategy astCacheStrategy = ASTCacheStrategy.ALL_EXCLUDING_TRANSLATION_UNIT;
    private boolean parseLineDirectives = false;

    public static ASTParser getInternalInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ASTParser();
        }
        return INSTANCE;
    }

    public void setBuildCacheSizeAndClear(int size) {
        this.buildCache = new TypedTreeCache(size);
    }

    public void setParseCacheSizeAndClear(int size) {
        EnhancedParser enhancedParser = this.parser;
        if (enhancedParser instanceof CachingParser) {
            CachingParser cachingParser = (CachingParser)enhancedParser;
            cachingParser.setParseCacheSizeAndClear(size);
        }
    }

    public void setASTCacheStrategy(ASTCacheStrategy astCacheStrategy) {
        this.astCacheStrategy = astCacheStrategy;
    }

    public void setParsingCacheStrategy(ParsingCacheStrategy parsingCacheStrategy) {
        this.parser = parsingCacheStrategy == ParsingCacheStrategy.ALL ? new CachingParser() : new EnhancedParser();
    }

    public void setParseLineDirectives(boolean parseLineDirectives) {
        this.parseLineDirectives = parseLineDirectives;
    }

    @Override
    public GLSLLexer getLexer() {
        return this.parser.getLexer();
    }

    @Override
    public GLSLParser getParser() {
        return this.parser.getParser();
    }

    @Override
    public void setThrowParseErrors(boolean throwParseErrors) {
        this.parser.setThrowParseErrors(throwParseErrors);
    }

    @Override
    public void setParsingStrategy(EnhancedParser.ParsingStrategy parsingStrategy) {
        this.parser.setParsingStrategy(parsingStrategy);
    }

    @Override
    public void setSLLOnly() {
        this.parser.setSLLOnly();
    }

    @Override
    public void setLLOnly() {
        this.parser.setLLOnly();
    }

    @Override
    public void setTokenFilter(TokenFilter<?> setTokenFilter) {
        this.parser.setTokenFilter(setTokenFilter);
    }

    private void setBuilderTokenStream() {
        if (this.parseLineDirectives) {
            ASTBuilder.setTokenStream(this.parser.getTokenStream());
        }
    }

    private void unsetBuilderTokenStream() {
        if (this.parseLineDirectives) {
            ASTBuilder.unsetTokenStream();
        }
    }

    private <C extends ParserRuleContext, N extends ASTNode> N parseNodeCachedUncloned(String input, Class<C> ruleType, Function<GLSLParser, C> parseMethod, BiFunction<ASTBuilder, C, N> visitMethod) {
        return (N)this.buildCache.cachedGet(input, ruleType, () -> {
            try {
                this.setBuilderTokenStream();
                Object n = ASTBuilder.build(new EmptyRoot(), this.parser.parse(input, ruleType, parseMethod), visitMethod);
                return n;
            }
            finally {
                this.unsetBuilderTokenStream();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends ParserRuleContext, N extends ASTNode> N parseNode(String input, ASTNode parentTreeMember, Class<C> ruleType, Function<GLSLParser, C> parseMethod, BiFunction<ASTBuilder, C, N> visitMethod) throws RecognitionException {
        if (ruleType == GLSLParser.TranslationUnitContext.class) {
            throw new IllegalArgumentException("Translation units may not be parsed into another node, that makes no sense.");
        }
        if (this.astCacheStrategy == ASTCacheStrategy.NONE) {
            try {
                this.setBuilderTokenStream();
                N n = ASTBuilder.buildSubtree(parentTreeMember, this.parser.parse(input, ruleType, parseMethod), visitMethod);
                return n;
            }
            finally {
                this.unsetBuilderTokenStream();
            }
        }
        return (N)((ASTNode)this.parseNodeCachedUncloned(input, ruleType, parseMethod, visitMethod)).cloneInto(parentTreeMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends ParserRuleContext, N extends ASTNode> N parseNodeSeparate(String input, Class<C> ruleType, Function<GLSLParser, C> parseMethod, BiFunction<ASTBuilder, C, N> visitMethod) throws RecognitionException {
        if (this.astCacheStrategy == ASTCacheStrategy.NONE || this.astCacheStrategy == ASTCacheStrategy.ALL_EXCLUDING_TRANSLATION_UNIT && ruleType == GLSLParser.TranslationUnitContext.class) {
            try {
                this.setBuilderTokenStream();
                N n = ASTBuilder.build(this.parser.parse(input, ruleType, parseMethod), visitMethod);
                return n;
            }
            finally {
                this.unsetBuilderTokenStream();
            }
        }
        return (N)((ASTNode)this.parseNodeCachedUncloned(input, ruleType, parseMethod, visitMethod)).cloneSeparate();
    }

    public TranslationUnit parseTranslationUnit(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.TranslationUnitContext.class, GLSLParser::translationUnit, ASTBuilder::visitTranslationUnit);
    }

    public ExternalDeclaration parseExternalDeclaration(ASTNode treeMember, String input) throws RecognitionException {
        return this.parseNode(input, treeMember, GLSLParser.ExternalDeclarationContext.class, GLSLParser::externalDeclaration, ASTBuilder::visitExternalDeclaration);
    }

    public Expression parseExpression(ASTNode treeMember, String input) throws RecognitionException {
        return this.parseNode(input, treeMember, GLSLParser.ExpressionContext.class, GLSLParser::expression, ASTBuilder::visitExpression);
    }

    public Statement parseStatement(ASTNode treeMember, String input) throws RecognitionException {
        return this.parseNode(input, treeMember, GLSLParser.StatementContext.class, GLSLParser::statement, ASTBuilder::visitStatement);
    }

    public ExternalDeclaration parseSeparateExternalDeclaration(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.ExternalDeclarationContext.class, GLSLParser::externalDeclaration, ASTBuilder::visitExternalDeclaration);
    }

    public Expression parseSeparateExpression(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.ExpressionContext.class, GLSLParser::expression, ASTBuilder::visitExpression);
    }

    public Statement parseSeparateStatement(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.StatementContext.class, GLSLParser::statement, ASTBuilder::visitStatement);
    }

    public List<ExternalDeclaration> parseExternalDeclarations(ASTNode treeMember, String ... inputs) {
        ArrayList<ExternalDeclaration> nodes = new ArrayList<ExternalDeclaration>(inputs.length);
        for (String input : inputs) {
            nodes.add(this.parseExternalDeclaration(treeMember, input));
        }
        return nodes;
    }

    public List<Expression> parseExpression(ASTNode treeMember, String ... inputs) {
        ArrayList<Expression> nodes = new ArrayList<Expression>(inputs.length);
        for (String input : inputs) {
            nodes.add(this.parseExpression(treeMember, input));
        }
        return nodes;
    }

    public List<Statement> parseStatements(ASTNode treeMember, String ... inputs) {
        ArrayList<Statement> nodes = new ArrayList<Statement>(inputs.length);
        for (String input : inputs) {
            nodes.add(this.parseStatement(treeMember, input));
        }
        return nodes;
    }

    public static enum ASTCacheStrategy {
        ALL,
        ALL_EXCLUDING_TRANSLATION_UNIT,
        NONE;

    }

    public static enum ParsingCacheStrategy {
        ALL,
        NONE;

    }
}

