/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.render.RenderGlobal;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatDescription;
import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatRegistry;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.common.util.MatrixHelper;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class EntityVertex {
    public static final VertexFormatDescription FORMAT = VertexFormatRegistry.get((VertexFormat)IrisVertexFormats.ENTITY);
    public static final int STRIDE = IrisVertexFormats.ENTITY.m_86020_();
    private static final int OFFSET_POSITION = 0;
    private static final int OFFSET_COLOR = 12;
    private static final int OFFSET_TEXTURE = 16;
    private static final int OFFSET_MID_TEXTURE = 36;
    private static final int OFFSET_OVERLAY = 24;
    private static final int OFFSET_LIGHT = 28;
    private static final int OFFSET_NORMAL = 32;
    private static final int OFFSET_TANGENT = 44;
    private static Vector3f lastNormal = new Vector3f();
    private static QuadViewEntity.QuadViewEntityUnsafe quadView = new QuadViewEntity.QuadViewEntityUnsafe();

    public static void write(long ptr, float x, float y, float z, int color, float u, float v, float midU, float midV, int light, int overlay, int normal, int tangent) {
        MemoryUtil.memPutFloat((long)(ptr + 0L + 0L), (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 0L + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 0L + 8L), (float)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)color);
        MemoryUtil.memPutFloat((long)(ptr + 16L + 0L), (float)u);
        MemoryUtil.memPutFloat((long)(ptr + 16L + 4L), (float)v);
        MemoryUtil.memPutInt((long)(ptr + 28L), (int)light);
        MemoryUtil.memPutInt((long)(ptr + 24L), (int)overlay);
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)normal);
        MemoryUtil.memPutInt((long)(ptr + 44L), (int)tangent);
        MemoryUtil.memPutFloat((long)(ptr + 36L), (float)midU);
        MemoryUtil.memPutFloat((long)(ptr + 36L + 4L), (float)midV);
    }

    public static void write2(long ptr, float x, float y, float z, int color, float u, float v, float midU, float midV, int light, int overlay, int normal) {
        MemoryUtil.memPutFloat((long)(ptr + 0L + 0L), (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 0L + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 0L + 8L), (float)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)color);
        MemoryUtil.memPutFloat((long)(ptr + 16L + 0L), (float)u);
        MemoryUtil.memPutFloat((long)(ptr + 16L + 4L), (float)v);
        MemoryUtil.memPutInt((long)(ptr + 28L), (int)light);
        MemoryUtil.memPutInt((long)(ptr + 24L), (int)overlay);
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)normal);
        MemoryUtil.memPutFloat((long)(ptr + 36L), (float)midU);
        MemoryUtil.memPutFloat((long)(ptr + 36L + 4L), (float)midV);
    }

    public static void writeQuadVertices(VertexBufferWriter writer, PoseStack.Pose matrices, ModelQuadView quad, int light, int overlay, int color) {
        Matrix3f matNormal = matrices.m_252943_();
        Matrix4f matPosition = matrices.m_252922_();
        try (MemoryStack stack = RenderGlobal.VERTEX_DATA.push();){
            long buffer;
            long ptr = buffer = stack.nmalloc(4 * STRIDE);
            int n = quad.getNormal();
            float nx = Norm3b.unpackX((int)n);
            float ny = Norm3b.unpackY((int)n);
            float nz = Norm3b.unpackZ((int)n);
            float midU = (quad.getTexU(0) + quad.getTexU(1) + quad.getTexU(2) + quad.getTexU(3)) * 0.25f;
            float midV = (quad.getTexV(0) + quad.getTexV(1) + quad.getTexV(2) + quad.getTexV(3)) * 0.25f;
            float nxt = MatrixHelper.transformNormalX((Matrix3f)matNormal, (float)nx, (float)ny, (float)nz);
            float nyt = MatrixHelper.transformNormalY((Matrix3f)matNormal, (float)nx, (float)ny, (float)nz);
            float nzt = MatrixHelper.transformNormalZ((Matrix3f)matNormal, (float)nx, (float)ny, (float)nz);
            int nt = Norm3b.pack((float)nxt, (float)nyt, (float)nzt);
            for (int i = 0; i < 4; ++i) {
                float x = quad.getX(i);
                float y = quad.getY(i);
                float z = quad.getZ(i);
                float xt = MatrixHelper.transformPositionX((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float yt = MatrixHelper.transformPositionY((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float zt = MatrixHelper.transformPositionZ((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                EntityVertex.write2(ptr, xt, yt, zt, color, quad.getTexU(i), quad.getTexV(i), midU, midV, light, overlay, nt);
                ptr += (long)STRIDE;
            }
            EntityVertex.endQuad(ptr - (long)STRIDE, nxt, nyt, nzt);
            writer.push(stack, buffer, 4, FORMAT);
        }
    }

    private static void endQuad(long ptr, float normalX, float normalY, float normalZ) {
        quadView.setup(ptr, STRIDE);
        int tangent = NormalHelper.computeTangent(normalX, normalY, normalZ, quadView);
        for (long vertex = 0L; vertex < 4L; ++vertex) {
            MemoryUtil.memPutInt((long)(ptr + 44L - (long)STRIDE * vertex), (int)tangent);
        }
    }
}

