/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.jellysquid.mods.sodium.client.render.immediate.CloudRenderer;
import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatDescription;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ColorVertex;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.CloudVertex;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CloudRenderer.class})
public abstract class MixinCloudRenderer {
    @Shadow
    private ShaderInstance clouds;
    @Shadow
    @Final
    private FogRenderer.FogData fogData;
    @Unique
    private VertexBuffer vertexBufferWithNormals;
    @Unique
    private int prevCenterCellXIris;
    @Unique
    private int prevCenterCellYIris;
    @Unique
    private int cachedRenderDistanceIris;

    @Shadow
    protected abstract void rebuildGeometry(BufferBuilder var1, int var2, int var3, int var4);

    @Shadow
    protected abstract void applyFogModifiers(ClientLevel var1, FogRenderer.FogData var2, LocalPlayer var3, int var4, float var5);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void buildIrisVertexBuffer(ClientLevel world, LocalPlayer player, PoseStack matrices, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            ci.cancel();
            this.renderIris(world, player, matrices, projectionMatrix, ticks, tickDelta, cameraX, cameraY, cameraZ);
        }
    }

    public void renderIris(@Nullable ClientLevel world, LocalPlayer player, PoseStack matrices, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ) {
        boolean insideClouds;
        if (world == null) {
            return;
        }
        Vec3 color = world.m_104808_(tickDelta);
        float cloudHeight = world.m_104583_().m_108871_();
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = cameraX + cloudTime;
        double cloudCenterZ = cameraZ + 0.33;
        int renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
        int cloudDistance = Math.max(32, renderDistance * 2 + 9);
        int centerCellX = (int)Math.floor(cloudCenterX / 12.0);
        int centerCellZ = (int)Math.floor(cloudCenterZ / 12.0);
        if (this.vertexBufferWithNormals == null || this.prevCenterCellXIris != centerCellX || this.prevCenterCellYIris != centerCellZ || this.cachedRenderDistanceIris != renderDistance) {
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, IrisVertexFormats.CLOUDS);
            this.rebuildGeometry(bufferBuilder, cloudDistance + 4, centerCellX, centerCellZ);
            if (this.vertexBufferWithNormals == null) {
                this.vertexBufferWithNormals = new VertexBuffer();
            }
            this.vertexBufferWithNormals.m_85921_();
            this.vertexBufferWithNormals.m_231221_(bufferBuilder.m_231175_());
            VertexBuffer.m_85931_();
            this.prevCenterCellXIris = centerCellX;
            this.prevCenterCellYIris = centerCellZ;
            this.cachedRenderDistanceIris = renderDistance;
        }
        float previousEnd = RenderSystem.m_157199_();
        float previousStart = RenderSystem.m_157200_();
        this.fogData.f_234201_ = cloudDistance * 8;
        this.fogData.f_234200_ = cloudDistance * 8 - 16;
        this.applyFogModifiers(world, this.fogData, player, cloudDistance * 8, tickDelta);
        RenderSystem.m_157443_((float)this.fogData.f_234201_);
        RenderSystem.m_157445_((float)this.fogData.f_234200_);
        float translateX = (float)(cloudCenterX - (double)(centerCellX * 12));
        float translateZ = (float)(cloudCenterZ - (double)(centerCellZ * 12));
        RenderSystem.m_69482_();
        this.vertexBufferWithNormals.m_85921_();
        boolean bl = insideClouds = cameraY < (double)(cloudHeight + 4.5f) && cameraY > (double)(cloudHeight - 0.5f);
        if (insideClouds) {
            RenderSystem.m_69464_();
        } else {
            RenderSystem.m_69481_();
        }
        RenderSystem.m_157429_((float)((float)color.f_82479_), (float)((float)color.f_82480_), (float)((float)color.f_82481_), (float)0.8f);
        matrices.m_85836_();
        Matrix4f modelViewMatrix = matrices.m_85850_().m_252922_();
        modelViewMatrix.translate(-translateX, cloudHeight - (float)cameraY + 0.33f, -translateZ);
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.vertexBufferWithNormals.m_253207_(modelViewMatrix, projectionMatrix, this.getClouds());
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)514);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.vertexBufferWithNormals.m_253207_(modelViewMatrix, projectionMatrix, this.getClouds());
        matrices.m_85849_();
        VertexBuffer.m_85931_();
        RenderSystem.m_69461_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69481_();
        RenderSystem.m_157443_((float)previousEnd);
        RenderSystem.m_157445_((float)previousStart);
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryStack;nmalloc(I)J"), remap=false)
    private int allocateNewSize(int size) {
        return IrisApi.getInstance().isShaderPackInUse() ? 480 : size;
    }

    @Inject(method={"writeVertex"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void writeIrisVertex(long buffer, float x, float y, float z, int color, CallbackInfoReturnable<Long> cir) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            CloudVertex.write(buffer, x, y, z, color);
            cir.setReturnValue((Object)(buffer + 20L));
        }
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/vertex/VertexBufferWriter;push(Lorg/lwjgl/system/MemoryStack;JILme/jellysquid/mods/sodium/client/render/vertex/VertexFormatDescription;)V"), index=3, remap=false)
    private VertexFormatDescription modifyArgIris(VertexFormatDescription vertexFormatDescription) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return CloudVertex.FORMAT;
        }
        return ColorVertex.FORMAT;
    }

    private ShaderInstance getClouds() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof CoreWorldRenderingPipeline) {
            return ((CoreWorldRenderingPipeline)pipeline).getShaderMap().getShader(ShaderKey.CLOUDS_SODIUM);
        }
        return this.clouds;
    }
}

