/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.fast_render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.model.ModelCuboidAccessor;
import me.jellysquid.mods.sodium.client.render.RenderGlobal;
import me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ModelVertex;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.EntityVertex;
import net.coderbot.iris.vertices.ImmediateState;
import net.coderbot.iris.vertices.NormalHelper;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class MixinModelPart {
    private ModelCuboid[] sodium$cuboids;

    private static float rsqrt(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(value));
    }

    private static boolean shouldExtend() {
        return IrisApi.getInstance().isShaderPackInUse() && ImmediateState.renderWithExtendedVertexFormat;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children, CallbackInfo ci) {
        ModelCuboid[] copies = new ModelCuboid[cuboids.size()];
        for (int i = 0; i < cuboids.size(); ++i) {
            ModelCuboidAccessor accessor = (ModelCuboidAccessor)cuboids.get(i);
            copies[i] = accessor.copy();
        }
        this.sodium$cuboids = copies;
    }

    @Overwrite
    private void m_104290_(PoseStack.Pose matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)vertexConsumer);
        int color = ColorABGR.pack((float)red, (float)green, (float)blue, (float)alpha);
        boolean extend = MixinModelPart.shouldExtend();
        for (ModelCuboid cuboid : this.sodium$cuboids) {
            cuboid.updateVertices(matrices.m_252922_());
            try (MemoryStack stack = RenderGlobal.VERTEX_DATA.push();){
                long buffer;
                long ptr = buffer = stack.nmalloc(24 * (extend ? EntityVertex.STRIDE : 36));
                for (ModelCuboid.Quad quad : cuboid.quads) {
                    int i;
                    if (quad == null) continue;
                    int normal = quad.getNormal(matrices.m_252943_());
                    float midU = 0.0f;
                    float midV = 0.0f;
                    int tangent = 0;
                    if (extend) {
                        for (i = 0; i < 4; ++i) {
                            midU += quad.textures[i].x;
                            midV += quad.textures[i].y;
                        }
                        midU = (float)((double)midU * 0.25);
                        midV = (float)((double)midV * 0.25);
                        tangent = this.getTangent(normal, quad.positions[0].x, quad.positions[0].y, quad.positions[0].z, quad.textures[0].x, quad.textures[0].y, quad.positions[1].x, quad.positions[1].y, quad.positions[1].z, quad.textures[1].x, quad.textures[1].y, quad.positions[2].x, quad.positions[2].y, quad.positions[2].z, quad.textures[2].x, quad.textures[2].y);
                    }
                    for (i = 0; i < 4; ++i) {
                        Vector3f pos = quad.positions[i];
                        Vector2f tex = quad.textures[i];
                        if (extend) {
                            EntityVertex.write(ptr, pos.x, pos.y, pos.z, color, tex.x, tex.y, midU, midV, light, overlay, normal, tangent);
                        } else {
                            ModelVertex.write((long)ptr, (float)pos.x, (float)pos.y, (float)pos.z, (int)color, (float)tex.x, (float)tex.y, (int)light, (int)overlay, (int)normal);
                        }
                        ptr += extend ? (long)EntityVertex.STRIDE : 36L;
                    }
                }
                writer.push(stack, buffer, 24, extend ? EntityVertex.FORMAT : ModelVertex.FORMAT);
            }
        }
    }

    private int getTangent(int normal, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2) {
        float normalX = Norm3b.unpackX((int)normal);
        float normalY = Norm3b.unpackY((int)normal);
        float normalZ = Norm3b.unpackZ((int)normal);
        float edge1x = x1 - x0;
        float edge1y = y1 - y0;
        float edge1z = z1 - z0;
        float edge2x = x2 - x0;
        float edge2y = y2 - y0;
        float edge2z = z2 - z0;
        float deltaU1 = u1 - u0;
        float deltaV2 = v2 - v0;
        float deltaU2 = u2 - u0;
        float deltaV1 = v1 - v0;
        float fdenom = deltaU1 * deltaV2 - deltaU2 * deltaV1;
        float f = (double)fdenom == 0.0 ? 1.0f : 1.0f / fdenom;
        float tangentx = f * (deltaV2 * edge1x - deltaV1 * edge2x);
        float tangenty = f * (deltaV2 * edge1y - deltaV1 * edge2y);
        float tangentz = f * (deltaV2 * edge1z - deltaV1 * edge2z);
        float tcoeff = MixinModelPart.rsqrt(tangentx * tangentx + tangenty * tangenty + tangentz * tangentz);
        tangentx *= tcoeff;
        tangenty *= tcoeff;
        float bitangentx = f * (-deltaU2 * edge1x + deltaU1 * edge2x);
        float bitangenty = f * (-deltaU2 * edge1y + deltaU1 * edge2y);
        float bitangentz = f * (-deltaU2 * edge1z + deltaU1 * edge2z);
        float bitcoeff = MixinModelPart.rsqrt(bitangentx * bitangentx + bitangenty * bitangenty + bitangentz * bitangentz);
        float pbitangentx = tangenty * normalZ - (tangentz *= tcoeff) * normalY;
        float pbitangenty = tangentz * normalX - tangentx * normalZ;
        float pbitangentz = tangentx * normalY - tangenty * normalX;
        float dot = (bitangentx *= bitcoeff) * pbitangentx + (bitangenty *= bitcoeff) * pbitangenty + (bitangentz *= bitcoeff) * pbitangentz;
        float tangentW = dot < 0.0f ? -1.0f : 1.0f;
        return NormalHelper.packNormal(tangentx, tangenty, tangentz, tangentW);
    }
}

