/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.nio.ByteBuffer;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.BufferBuilderPolygonView;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.ExtendingBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
implements BufferVertexConsumer,
BlockSensitiveBufferBuilder,
ExtendingBufferBuilder {
    @Unique
    private boolean extending;
    @Unique
    private boolean iris$shouldNotExtend = false;
    @Unique
    private boolean iris$isTerrain = false;
    @Unique
    private int vertexCount;
    @Unique
    private final BufferBuilderPolygonView polygon = new BufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Unique
    private boolean injectNormal;
    @Unique
    private short currentBlock;
    @Unique
    private short currentRenderType;
    @Unique
    private int currentLocalPosX;
    @Unique
    private int currentLocalPosY;
    @Unique
    private int currentLocalPosZ;
    @Shadow
    private boolean f_85659_;
    @Shadow
    private boolean f_85660_;
    @Shadow
    private ByteBuffer f_85648_;
    @Shadow
    private VertexFormat.Mode f_85657_;
    @Shadow
    private VertexFormat f_85658_;
    @Shadow
    private int f_85652_;
    @Shadow
    @Nullable
    private VertexFormatElement f_85655_;

    @Shadow
    public abstract void m_166779_(VertexFormat.Mode var1, VertexFormat var2);

    @Shadow
    public abstract void m_5586_(int var1, short var2);

    @Shadow
    protected abstract void m_85704_(VertexFormat var1);

    @Override
    public void iris$beginWithoutExtending(VertexFormat.Mode drawMode, VertexFormat vertexFormat) {
        this.iris$shouldNotExtend = true;
        this.m_166779_(drawMode, vertexFormat);
        this.iris$shouldNotExtend = false;
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")})
    private void iris$onBegin(VertexFormat.Mode drawMode, VertexFormat format, CallbackInfo ci) {
        boolean shouldExtend = !this.iris$shouldNotExtend && BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat();
        this.extending = shouldExtend && (format == DefaultVertexFormat.f_85811_ || format == DefaultVertexFormat.f_85812_ || format == DefaultVertexFormat.f_85820_);
        this.vertexCount = 0;
        if (this.extending) {
            this.injectNormal = format == DefaultVertexFormat.f_85820_;
        }
    }

    @Inject(method={"begin"}, at={@At(value="RETURN")})
    private void iris$afterBegin(VertexFormat.Mode drawMode, VertexFormat format, CallbackInfo ci) {
        if (this.extending) {
            if (format == DefaultVertexFormat.f_85812_) {
                this.m_85704_(IrisVertexFormats.ENTITY);
                this.iris$isTerrain = false;
            } else {
                this.m_85704_(IrisVertexFormats.TERRAIN);
                this.iris$isTerrain = true;
            }
            this.f_85655_ = (VertexFormatElement)this.f_85658_.m_86023_().get(0);
        }
    }

    @ModifyArg(method={"begin"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferBuilder;switchFormat(Lcom/mojang/blaze3d/vertex/VertexFormat;)V"))
    private VertexFormat iris$afterBeginSwitchFormat(VertexFormat arg) {
        if (this.extending) {
            if (this.f_85658_ == DefaultVertexFormat.f_85812_) {
                return IrisVertexFormats.ENTITY;
            }
            return IrisVertexFormats.TERRAIN;
        }
        return arg;
    }

    @Inject(method={"discard()V"}, at={@At(value="HEAD")})
    private void iris$onDiscard(CallbackInfo ci) {
        this.extending = false;
        this.vertexCount = 0;
    }

    @Inject(method={"switchFormat"}, at={@At(value="RETURN")})
    private void iris$preventHardcodedVertexWriting(VertexFormat format, CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        this.f_85659_ = false;
        this.f_85660_ = false;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        if (this.injectNormal && this.f_85655_ == DefaultVertexFormat.f_85809_) {
            this.putInt(0, 0);
            this.m_5751_();
        }
        if (this.iris$isTerrain) {
            this.m_5586_(0, this.currentBlock);
            this.m_5586_(2, this.currentRenderType);
            this.m_5751_();
        }
        this.m_5832_(0, 0.0f);
        this.m_5832_(4, 0.0f);
        this.m_5751_();
        this.putInt(0, 0);
        this.m_5751_();
        if (this.iris$isTerrain) {
            int posIndex = this.f_85652_ - 48;
            float x = this.f_85648_.getFloat(posIndex);
            float y = this.f_85648_.getFloat(posIndex + 4);
            float z = this.f_85648_.getFloat(posIndex + 8);
            this.putInt(0, ExtendedDataHelper.computeMidBlock(x, y, z, this.currentLocalPosX, this.currentLocalPosY, this.currentLocalPosZ));
            this.m_5751_();
        }
        ++this.vertexCount;
        if (this.f_85657_ == VertexFormat.Mode.QUADS && this.vertexCount == 4 || this.f_85657_ == VertexFormat.Mode.TRIANGLES && this.vertexCount == 3) {
            this.fillExtendedData(this.vertexCount);
        }
    }

    @Unique
    private void fillExtendedData(int vertexAmount) {
        int tangentOffset;
        int normalOffset;
        int midVOffset;
        int midUOffset;
        this.vertexCount = 0;
        int stride = this.f_85658_.m_86020_();
        this.polygon.setup(this.f_85648_, this.f_85652_, stride, vertexAmount);
        float midU = 0.0f;
        float midV = 0.0f;
        for (int vertex = 0; vertex < vertexAmount; ++vertex) {
            midU += this.polygon.u(vertex);
            midV += this.polygon.v(vertex);
        }
        midU /= (float)vertexAmount;
        midV /= (float)vertexAmount;
        if (vertexAmount == 3) {
            NormalHelper.computeFaceNormalTri(this.normal, this.polygon);
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
        }
        int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
        int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
        if (this.iris$isTerrain) {
            midUOffset = 16;
            midVOffset = 12;
            normalOffset = 24;
            tangentOffset = 8;
        } else {
            midUOffset = 12;
            midVOffset = 8;
            normalOffset = 16;
            tangentOffset = 4;
        }
        for (int vertex = 0; vertex < vertexAmount; ++vertex) {
            this.f_85648_.putFloat(this.f_85652_ - midUOffset - stride * vertex, midU);
            this.f_85648_.putFloat(this.f_85652_ - midVOffset - stride * vertex, midV);
            this.f_85648_.putInt(this.f_85652_ - normalOffset - stride * vertex, packedNormal);
            this.f_85648_.putInt(this.f_85652_ - tangentOffset - stride * vertex, tangent);
        }
    }

    @Override
    public void beginBlock(short block, short renderType, int localPosX, int localPosY, int localPosZ) {
        this.currentBlock = block;
        this.currentRenderType = renderType;
        this.currentLocalPosX = localPosX;
        this.currentLocalPosY = localPosY;
        this.currentLocalPosZ = localPosZ;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
        this.currentLocalPosX = 0;
        this.currentLocalPosY = 0;
        this.currentLocalPosZ = 0;
    }

    @Unique
    private void putInt(int i, int value) {
        this.f_85648_.putInt(this.f_85652_ + i, value);
    }
}

