/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FakeChainedJsonException;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewShaderTests;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.ShaderMap;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowCompositeRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector4f;

public class NewWorldRenderingPipeline
implements WorldRenderingPipeline,
CoreWorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    private final ShaderMap shaderMap;
    private final CustomUniforms customUniforms;
    private final ShadowCompositeRenderer shadowCompositeRenderer;
    private final Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> customTextureMap;
    private ShadowRenderTargets shadowRenderTargets;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private final Set<ShaderInstance> loadedShaders;
    private ImmutableList<ClearPass> clearPassesFull;
    private ImmutableList<ClearPass> clearPasses;
    private ImmutableList<ClearPass> shadowClearPasses;
    private ImmutableList<ClearPass> shadowClearPassesFull;
    private final GlFramebuffer baseline;
    private final CompositeRenderer prepareRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final DynamicTexture whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    public boolean isBeforeTranslucent;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    @Nullable
    private ComputeProgram[] shadowComputes;
    private final float sunPathRotation;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private boolean destroyed = false;
    private boolean isRenderingWorld;
    private boolean isMainBound;
    private final CloudSetting cloudSetting;
    private final boolean shouldRenderSun;
    private final boolean shouldRenderMoon;
    private final boolean prepareBeforeShadow;
    private final boolean allowConcurrentCompute;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;
    private boolean shouldBindPBR;
    private int currentNormalTexture;
    private int currentSpecularTexture;
    private ParticleRenderingSettings particleRenderingSettings;
    private PackDirectives packDirectives;

    public NewWorldRenderingPipeline(ProgramSet programSet) throws IOException {
        PatchedShaderPrinter.resetPrintState();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.packDirectives = programSet.getPackDirectives();
        this.customTextureMap = programSet.getPackDirectives().getTextureMap();
        this.cloudSetting = programSet.getPackDirectives().getCloudSetting();
        this.shouldRenderSun = programSet.getPackDirectives().shouldRenderSun();
        this.shouldRenderMoon = programSet.getPackDirectives().shouldRenderMoon();
        this.prepareBeforeShadow = programSet.getPackDirectives().isPrepareBeforeShadow();
        this.allowConcurrentCompute = programSet.getPackDirectives().getConcurrentCompute();
        ProgramFallbackResolver resolver = new ProgramFallbackResolver(programSet);
        this.particleRenderingSettings = programSet.getPackDirectives().getParticleRenderingSettings().orElseGet(() -> {
            if (programSet.getDeferred().length > 0) {
                return ParticleRenderingSettings.AFTER;
            }
            return ParticleRenderingSettings.MIXED;
        });
        this.shadowComputes = this.createShadowComputes(programSet.getShadowCompute(), programSet);
        RenderTarget main = Minecraft.m_91087_().m_91385_();
        int depthTextureId = main.m_83980_();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets = new RenderTargets(main.f_83915_, main.f_83916_, depthTextureId, ((Blaze3dRenderTargetExt)main).iris$getDepthBufferVersion(), depthBufferFormat, programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings(), programSet.getPackDirectives());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        this.customUniforms = programSet.getPack().customUniforms.build(holder -> CommonUniforms.addNonDynamicUniforms(holder, programSet.getPack().getIdMap(), programSet.getPackDirectives(), this.updateNotifier));
        GlStateManager.m_84538_((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getIrisCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager.m_84538_((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(() -> this.renderTargets.getDepthTexture(), programSet.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programSet.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, shadowDirectives);
            }
            return this.shadowRenderTargets;
        };
        this.prepareRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getPrepare(), programSet.getPrepareCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, TextureStage.PREPARE, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.PREPARE, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), programSet.getPackDirectives().getExplicitFlips("prepare_pre"), this.customUniforms);
        this.flippedAfterPrepare = flipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getDeferred(), programSet.getDeferredCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, TextureStage.DEFERRED, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), programSet.getPackDirectives().getExplicitFlips("deferred_pre"), this.customUniforms);
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getComposite(), programSet.getCompositeCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, TextureStage.COMPOSITE_AND_FINAL, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), programSet.getPackDirectives().getExplicitFlips("composite_pre"), this.customUniforms);
        this.finalPassRenderer = new FinalPassRenderer(this, programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), this.compositeRenderer.getFlippedAtLeastOnceFinal(), this.customUniforms);
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
            if (!this.shouldBindPBR) {
                this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
            }
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, (AbstractTexture)this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.prepareBeforeShadow ? this.flippedAfterPrepare : this.flippedBeforeShadow, this.renderTargets, false);
            IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
            if (!this.shouldBindPBR) {
                this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
            }
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, (AbstractTexture)this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createShadowTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, () -> this.prepareBeforeShadow ? this.flippedAfterPrepare : this.flippedBeforeShadow, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.loadedShaders = new HashSet<ShaderInstance>();
        this.shaderMap = new ShaderMap(key -> {
            try {
                if (key.isShadow()) {
                    if (this.shadowRenderTargets != null) {
                        return this.createShadowShader(key.getName(), resolver.resolve(key.getProgram()), (ShaderKey)((Object)key));
                    }
                    return null;
                }
                return this.createShader(key.getName(), resolver.resolve(key.getProgram()), (ShaderKey)((Object)key));
            }
            catch (FakeChainedJsonException e) {
                this.destroyShaders();
                throw e.getTrueException();
            }
            catch (IOException e) {
                this.destroyShaders();
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                this.destroyShaders();
                throw e;
            }
        });
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programSet.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        if (this.shadowRenderTargets == null && shadowDirectives.isShadowEnabled() == OptionalBoolean.TRUE) {
            this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, shadowDirectives);
        }
        if (this.shadowRenderTargets != null) {
            ShaderInstance shader = this.shaderMap.getShader(ShaderKey.SHADOW_TERRAIN_CUTOUT);
            boolean shadowUsesImages = false;
            if (shader instanceof ExtendedShader) {
                ExtendedShader shader2 = (ExtendedShader)shader;
                shadowUsesImages = shader2.hasActiveImages();
            }
            this.shadowClearPasses = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, false, shadowDirectives);
            this.shadowClearPassesFull = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, true, shadowDirectives);
            this.shadowCompositeRenderer = new ShadowCompositeRenderer(this, programSet.getPackDirectives(), programSet.getShadowComposite(), programSet.getShadowCompCompute(), this.shadowRenderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.customTextureManager.getCustomTextureIdMap(TextureStage.SHADOWCOMP), programSet.getPackDirectives().getExplicitFlips("shadowcomp_pre"), this.customTextureManager.getIrisCustomTextures(), this.customUniforms);
            this.shadowRenderer = programSet.getPackDirectives().getShadowDirectives().isShadowEnabled().orElse(true) ? new ShadowRenderer(programSet.getShadow().orElse(null), programSet.getPackDirectives(), this.shadowRenderTargets, this.shadowCompositeRenderer, this.customUniforms) : null;
        } else {
            this.shadowClearPasses = ImmutableList.of();
            this.shadowClearPassesFull = ImmutableList.of();
            this.shadowCompositeRenderer = null;
            this.shadowRenderer = null;
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, createTerrainSamplers, this.shadowRenderTargets == null ? null : createShadowTerrainSamplers, createTerrainImages, createShadowTerrainImages, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.getMainRenderBuffer() : null, this.customUniforms);
        this.customUniforms.optimise();
    }

    private ComputeProgram[] createShadowComputes(ComputeSource[] compute, ProgramSet programSet) {
        ComputeProgram[] programs = new ComputeProgram[compute.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = compute[i];
            if (source == null || !source.getSource().isPresent()) continue;
            try {
                builder = ProgramBuilder.beginCompute(source.getName(), TransformPatcher.patchCompute(source.getSource().orElse(null), TextureStage.GBUFFERS_AND_SHADOW, this.customTextureMap), IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            }
            catch (ShaderCompileException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Shader compilation failed!", e);
            }
            CommonUniforms.addCommonUniforms(builder, programSet.getPack().getIdMap(), programSet.getPackDirectives(), this.updateNotifier, FogMode.OFF);
            Supplier<ImmutableSet<Integer>> flipped = () -> this.flippedBeforeShadow;
            TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(textureStage));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, (AbstractTexture)this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets, null);
            }
            programs[i] = builder.buildCompute();
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups());
        }
        return programs;
    }

    private ShaderInstance createShader(String name, Optional<ProgramSource> source, ShaderKey key) throws IOException {
        if (!source.isPresent()) {
            return this.createFallbackShader(name, key);
        }
        return this.createShader(name, source.get(), key.getProgram(), key.getAlphaTest(), key.getVertexFormat(), key.getFogMode(), key.isIntensity(), key.shouldIgnoreLightmap(), key.isGlint());
    }

    @Override
    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.customTextureMap;
    }

    private ShaderInstance createShader(String name, ProgramSource source, ProgramId programId, AlphaTest fallbackAlpha, VertexFormat vertexFormat, FogMode fogMode, boolean isIntensity, boolean isFullbright, boolean isGlint) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, source.getDirectives().getDrawBuffers());
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, source.getDirectives().getDrawBuffers());
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat, isFullbright, isGlint);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        ExtendedShader extendedShader = NewShaderTests.create(this, name, source, programId, beforeTranslucent, afterTranslucent, this.baseline, fallbackAlpha, vertexFormat, inputs, this.updateNotifier, this, flipped, fogMode, isIntensity, isFullbright, false, this.customUniforms);
        this.loadedShaders.add(extendedShader);
        return extendedShader;
    }

    private ShaderInstance createFallbackShader(String name, ShaderKey key) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        FallbackShader shader = NewShaderTests.createFallback(name, beforeTranslucent, afterTranslucent, key.getAlphaTest(), key.getVertexFormat(), null, this, key.getFogMode(), key.hasDiffuseLighting(), key.isIntensity(), key.shouldIgnoreLightmap());
        this.loadedShaders.add(shader);
        return shader;
    }

    private ShaderInstance createShadowShader(String name, Optional<ProgramSource> source, ShaderKey key) throws IOException {
        if (!source.isPresent()) {
            return this.createFallbackShadowShader(name, key);
        }
        return this.createShadowShader(name, source.get(), key.getProgram(), key.getAlphaTest(), key.getVertexFormat(), key.isIntensity(), key.shouldIgnoreLightmap());
    }

    private ShaderInstance createFallbackShadowShader(String name, ShaderKey key) throws IOException {
        GlFramebuffer framebuffer = this.shadowRenderTargets.getMainRenderBuffer();
        FallbackShader shader = NewShaderTests.createFallback(name, framebuffer, framebuffer, key.getAlphaTest(), key.getVertexFormat(), BlendModeOverride.OFF, this, key.getFogMode(), key.hasDiffuseLighting(), key.isIntensity(), key.shouldIgnoreLightmap());
        this.loadedShaders.add(shader);
        return shader;
    }

    private ShaderInstance createShadowShader(String name, ProgramSource source, ProgramId programId, AlphaTest fallbackAlpha, VertexFormat vertexFormat, boolean isIntensity, boolean isFullbright) throws IOException {
        GlFramebuffer framebuffer = this.shadowRenderTargets.getMainRenderBuffer();
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat, isFullbright, false);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.prepareBeforeShadow ? this.flippedAfterPrepare : this.flippedBeforeShadow;
        ExtendedShader extendedShader = NewShaderTests.create(this, name, source, programId, framebuffer, framebuffer, this.baseline, fallbackAlpha, vertexFormat, inputs, this.updateNotifier, this, flipped, FogMode.PER_VERTEX, isIntensity, isFullbright, true, this.customUniforms);
        this.loadedShaders.add(extendedShader);
        return extendedShader;
    }

    public void addGbufferOrShadowSamplers(SamplerHolder samplers, ImageHolder images, Supplier<ImmutableSet<Integer>> flipped, boolean isShadowPass, InputAvailability availability) {
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor samplerHolder = ProgramSamplers.customTextureSamplerInterceptor(samplers, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()));
        IrisSamplers.addRenderTargetSamplers(samplerHolder, flipped, this.renderTargets, false);
        IrisSamplers.addCustomTextures(samplerHolder, this.customTextureManager.getIrisCustomTextures());
        IrisImages.addRenderTargetImages(images, flipped, this.renderTargets);
        if (!this.shouldBindPBR) {
            this.shouldBindPBR = IrisSamplers.hasPBRSamplers(samplerHolder);
        }
        IrisSamplers.addLevelSamplers(samplers, this, (AbstractTexture)this.whitePixel, availability);
        IrisSamplers.addWorldDepthSamplers(samplerHolder, this.renderTargets);
        IrisSamplers.addNoiseSampler(samplerHolder, this.customTextureManager.getNoiseTexture());
        if (isShadowPass || IrisSamplers.hasShadowSamplers(samplerHolder)) {
            if (!isShadowPass) {
                this.shadowTargetsSupplier.get();
            }
            IrisSamplers.addShadowSamplers(samplerHolder, Objects.requireNonNull(this.shadowRenderTargets), null);
        }
        if (isShadowPass || IrisImages.hasShadowImages(images)) {
            IrisImages.addShadowColorImages(images, Objects.requireNonNull(this.shadowRenderTargets), null);
        }
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    @Override
    public void beginSodiumTerrainRendering() {
    }

    @Override
    public void endSodiumTerrainRendering() {
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase phase) {
        this.overridePhase = phase;
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
    }

    @Override
    public void setSpecialCondition(SpecialCondition special) {
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public int getCurrentNormalTexture() {
        return this.currentNormalTexture;
    }

    @Override
    public int getCurrentSpecularTexture() {
        return this.currentSpecularTexture;
    }

    @Override
    public void onSetShaderTexture(int id) {
        if (this.shouldBindPBR && this.isRenderingWorld) {
            PBRTextureHolder pbrHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(id);
            this.currentNormalTexture = pbrHolder.getNormalTexture().m_117963_();
            this.currentSpecularTexture = pbrHolder.getSpecularTexture().m_117963_();
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null) {
                int previousBinding = GlStateManagerAccessor.getTEXTURES()[GlStateManagerAccessor.getActiveTexture()].f_84801_;
                textureFormat.setupTextureParameters(PBRType.NORMAL, pbrHolder.getNormalTexture());
                textureFormat.setupTextureParameters(PBRType.SPECULAR, pbrHolder.getSpecularTexture());
                GlStateManager.m_84544_((int)previousBinding);
            }
            PBRTextureManager.notifyPBRTexturesChanged();
        }
    }

    @Override
    public void beginLevelRendering() {
        ImmutableList<ClearPass> passes;
        this.isRenderingWorld = true;
        RenderSystem.m_69388_((int)33984);
        Vector4f emptyClearColor = new Vector4f(1.0f);
        if (this.shadowRenderTargets != null) {
            if (this.packDirectives.getShadowDirectives().isShadowEnabled() == OptionalBoolean.FALSE) {
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    this.shadowRenderTargets.onFullClear();
                    for (Object clearPass2 : this.shadowClearPassesFull) {
                        ((ClearPass)clearPass2).execute(emptyClearColor);
                    }
                }
            } else {
                ImmutableList<ClearPass> passes2;
                this.shadowRenderTargets.getDepthSourceFb().bind();
                RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
                for (ComputeProgram computeProgram : this.shadowComputes) {
                    if (computeProgram == null) continue;
                    computeProgram.use();
                    this.customUniforms.push(computeProgram);
                    computeProgram.dispatch(this.shadowMapResolution, this.shadowMapResolution);
                }
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    passes2 = this.shadowClearPassesFull;
                    this.shadowRenderTargets.onFullClear();
                } else {
                    passes2 = this.shadowClearPasses;
                }
                for (ClearPass clearPass3 : passes2) {
                    clearPass3.execute(emptyClearColor);
                }
            }
        }
        this.updateNotifier.onNewFrame();
        this.customUniforms.update();
        RenderTarget main = Minecraft.m_91087_().m_91385_();
        int depthTextureId = main.m_83980_();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        boolean changed = this.renderTargets.resizeIfNeeded(((Blaze3dRenderTargetExt)main).iris$getDepthBufferVersion(), depthTextureId, main.f_83915_, main.f_83916_, depthBufferFormat, this.packDirectives);
        if (changed) {
            this.prepareRenderer.recalculateSizes();
            this.deferredRenderer.recalculateSizes();
            this.compositeRenderer.recalculateSizes();
            this.finalPassRenderer.recalculateSwapPassSize();
            this.clearPassesFull.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPasses.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, this.packDirectives.getRenderTargetDirectives());
            this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, this.packDirectives.getRenderTargetDirectives());
        }
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        Vector3d fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.x, (float)fogColor3.y, (float)fogColor3.z, 1.0f);
        for (ClearPass clearPass4 : passes) {
            clearPass4.execute(fogColor);
        }
        main.m_83947_(true);
        this.isMainBound = true;
        this.isBeforeTranslucent = true;
        this.setPhase(WorldRenderingPhase.SKY);
        DimensionSpecialEffects.SkyType skyType = Minecraft.m_91087_().f_91073_.m_104583_().m_108883_();
        if (skyType == DimensionSpecialEffects.SkyType.NORMAL) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)fogColor.x, (float)fogColor.y, (float)fogColor.z, (float)fogColor.w);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), GameRenderer.m_172808_());
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void renderShadows(LevelRendererAccessor worldRenderer, Camera playerCamera) {
        if (this.prepareBeforeShadow) {
            this.prepareRenderer.renderAll();
        }
        if (this.shadowRenderer != null) {
            this.shadowRenderer.renderShadows(worldRenderer, playerCamera);
        }
        if (!this.prepareBeforeShadow) {
            this.prepareRenderer.renderAll();
        }
    }

    @Override
    public void addDebugText(List<String> messages) {
        if (this.shadowRenderer != null) {
            messages.add("");
            this.shadowRenderer.addDebugText(messages);
        } else {
            messages.add("");
            messages.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use a destroyed world rendering pipeline");
        }
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.deferredRenderer.renderAll();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
    }

    @Override
    public void finalizeLevelRendering() {
        this.isRenderingWorld = false;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldRenderSun() {
        return this.shouldRenderSun;
    }

    @Override
    public boolean shouldRenderMoon() {
        return this.shouldRenderMoon;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public ParticleRenderingSettings getParticleRenderingSettings() {
        return this.particleRenderingSettings;
    }

    @Override
    public boolean allowConcurrentCompute() {
        return this.allowConcurrentCompute;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Override
    public ShaderMap getShaderMap() {
        return this.shaderMap;
    }

    private void destroyShaders() {
        this.loadedShaders.forEach(shader -> {
            shader.m_173362_();
            shader.close();
        });
    }

    @Override
    public void destroy() {
        int i;
        this.destroyed = true;
        this.destroyShaders();
        for (i = 0; i < 16; ++i) {
            GlStateManager.m_84514_((int)(33984 + i));
            GlStateManager.m_84544_((int)0);
        }
        GlStateManager.m_84514_((int)33984);
        for (i = 0; i < 12; ++i) {
            RenderSystem.m_157453_((int)i, (int)0);
        }
        if (this.shadowCompositeRenderer != null) {
            this.shadowCompositeRenderer.destroy();
        }
        this.prepareRenderer.destroy();
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        this.customTextureManager.destroy();
        this.whitePixel.close();
        this.horizonRenderer.destroy();
        GlStateManager.m_84486_((int)36008, (int)0);
        GlStateManager.m_84486_((int)36009, (int)0);
        GlStateManager.m_84486_((int)36160, (int)0);
        Minecraft.m_91087_().m_91385_().m_83947_(false);
        this.renderTargets.destroy();
        if (this.shadowRenderer != null) {
            this.shadowRenderer.destroy();
        }
    }

    @Override
    public boolean shouldOverrideShaders() {
        return this.isRenderingWorld && this.isMainBound;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    protected AbstractTexture getWhitePixel() {
        return this.whitePixel;
    }

    @Override
    public void beginPostChain() {
    }

    @Override
    public void endPostChain() {
    }

    @Override
    public void setIsMainBound(boolean bound) {
        this.isMainBound = bound;
    }
}

