/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.minecraft.client.renderer.texture.AbstractTexture;

public class IrisSamplers {
    public static final int ALBEDO_TEXTURE_UNIT = 0;
    public static final int OVERLAY_TEXTURE_UNIT = 1;
    public static final int LIGHTMAP_TEXTURE_UNIT = 2;
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)1, (Object)2);

    private IrisSamplers() {
    }

    public static void addRenderTargetSamplers(SamplerHolder samplers, Supplier<ImmutableSet<Integer>> flipped, RenderTargets renderTargets, boolean isFullscreenPass) {
        int startIndex;
        for (int i = startIndex = isFullscreenPass ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int index = i;
            IntSupplier sampler = () -> {
                ImmutableSet flippedBuffers = (ImmutableSet)flipped.get();
                RenderTarget target = renderTargets.get(index);
                if (flippedBuffers.contains((Object)index)) {
                    return target.getAltTexture();
                }
                return target.getMainTexture();
            };
            String name = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String legacyName = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (i == 0 && isFullscreenPass) {
                    samplers.addDefaultSampler(sampler, name, legacyName);
                    continue;
                }
                samplers.addDynamicSampler(sampler, name, legacyName);
                continue;
            }
            samplers.addDynamicSampler(sampler, name);
        }
    }

    public static void addNoiseSampler(SamplerHolder samplers, TextureAccess sampler) {
        samplers.addDynamicSampler(sampler.getTextureId(), "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplers) {
        ImmutableList.Builder shadowSamplers = ImmutableList.builder().add((Object[])new String[]{"shadowtex0", "shadowtex0HW", "shadowtex1", "shadowtex1HW", "shadow", "watershadow", "shadowcolor"});
        for (int i = 0; i < 2; ++i) {
            shadowSamplers.add((Object)("shadowcolor" + i));
            shadowSamplers.add((Object)("shadowcolorimg" + i));
        }
        for (String samplerName : shadowSamplers.build()) {
            if (!samplers.hasSampler(samplerName)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplers, ShadowRenderTargets shadowRenderTargets, ImmutableSet<Integer> flipped) {
        boolean usesShadows;
        boolean waterShadowEnabled = samplers.hasSampler("watershadow");
        if (waterShadowEnabled) {
            usesShadows = true;
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0", "watershadow");
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1", "shadow");
        } else {
            usesShadows = samplers.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0", "shadow");
            usesShadows |= samplers.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1");
        }
        if (flipped == null) {
            samplers.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(0), "shadowcolor");
            for (int i = 0; i < 2; ++i) {
                int finalI = i;
                samplers.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(finalI), "shadowcolor" + i);
            }
        } else {
            samplers.addDynamicSampler(() -> flipped.contains((Object)0) ? shadowRenderTargets.get(0).getAltTexture() : shadowRenderTargets.get(0).getMainTexture(), "shadowcolor");
            for (int i = 0; i < 2; ++i) {
                int finalI = i;
                samplers.addDynamicSampler(() -> flipped.contains((Object)finalI) ? shadowRenderTargets.get(finalI).getAltTexture() : shadowRenderTargets.get(finalI).getMainTexture(), "shadowcolor" + i);
            }
        }
        if (shadowRenderTargets.isHardwareFiltered(0)) {
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0HW");
        }
        if (shadowRenderTargets.isHardwareFiltered(1)) {
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1HW");
        }
        return usesShadows;
    }

    public static boolean hasPBRSamplers(SamplerHolder samplers) {
        return samplers.hasSampler("normals") || samplers.hasSampler("specular");
    }

    public static void addLevelSamplers(SamplerHolder samplers, WorldRenderingPipeline pipeline, AbstractTexture whitePixel, InputAvailability availability) {
        if (availability.texture) {
            samplers.addExternalSampler(0, "tex", "texture", "gtexture");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).m_117963_(), "tex", "texture", "gtexture", "gcolor", "colortex0");
        }
        if (availability.lightmap) {
            samplers.addExternalSampler(2, "lightmap");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).m_117963_(), "lightmap");
        }
        if (availability.overlay) {
            samplers.addExternalSampler(1, "iris_overlay");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).m_117963_(), "iris_overlay");
        }
        samplers.addDynamicSampler(pipeline::getCurrentNormalTexture, StateUpdateNotifiers.normalTextureChangeNotifier, "normals");
        samplers.addDynamicSampler(pipeline::getCurrentSpecularTexture, StateUpdateNotifiers.specularTextureChangeNotifier, "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets::getDepthTexture, "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets::getDepthTexture, "gdepthtex", "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }

    public static void addCustomTextures(SamplerHolder samplers, Object2ObjectMap<String, TextureAccess> irisCustomTextures) {
        irisCustomTextures.forEach((name, texture) -> samplers.addDynamicSampler(texture.getType(), texture.getTextureId(), (String)name));
    }
}

