/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vertices;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.coderbot.iris.vertices.QuadView;
import net.irisshaders.iris.api.v0.IrisTextVertexSink;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class IrisTextVertexSinkImpl
implements IrisTextVertexSink {
    static VertexFormat format = IrisVertexFormats.TERRAIN;
    private final ByteBuffer buffer;
    private final TextQuadView quad = new TextQuadView();
    private final Vector3f saveNormal = new Vector3f();
    private static final int STRIDE = IrisVertexFormats.TERRAIN.m_86020_();
    private int vertexCount;
    private long elementOffset;
    private float uSum;
    private float vSum;

    public IrisTextVertexSinkImpl(int maxQuadCount, IntFunction<ByteBuffer> buffer) {
        this.buffer = buffer.apply(format.m_86020_() * 4 * maxQuadCount);
        this.elementOffset = MemoryUtil.memAddress((ByteBuffer)this.buffer);
    }

    @Override
    public VertexFormat getUnderlyingVertexFormat() {
        return format;
    }

    @Override
    public ByteBuffer getUnderlyingByteBuffer() {
        return this.buffer;
    }

    @Override
    public void quad(float minX, float minY, float maxX, float maxY, float z, int color, float minU, float minV, float maxU, float maxV, int light) {
        this.vertex(minX, minY, z, color, minU, minV, light);
        this.vertex(minX, maxY, z, color, minU, maxV, light);
        this.vertex(maxX, maxY, z, color, maxU, maxV, light);
        this.vertex(maxX, minY, z, color, maxU, minV, light);
    }

    private void vertex(float x, float y, float z, int color, float u, float v, int light) {
        ++this.vertexCount;
        this.uSum += u;
        this.vSum += v;
        long i = this.elementOffset;
        MemoryUtil.memPutFloat((long)i, (float)x);
        MemoryUtil.memPutFloat((long)(i + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(i + 8L), (float)z);
        MemoryUtil.memPutInt((long)(i + 12L), (int)color);
        MemoryUtil.memPutFloat((long)(i + 16L), (float)u);
        MemoryUtil.memPutFloat((long)(i + 20L), (float)v);
        MemoryUtil.memPutInt((long)(i + 24L), (int)light);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum = (float)((double)this.uSum * 0.25);
            this.vSum = (float)((double)this.vSum * 0.25);
            this.quad.setup(this.elementOffset, IrisVertexFormats.TERRAIN.m_86020_());
            NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
            float normalX = this.saveNormal.x;
            float normalY = this.saveNormal.y;
            float normalZ = this.saveNormal.z;
            int normal = NormalHelper.packNormal(this.saveNormal, 0.0f);
            int tangent = NormalHelper.computeTangent(normalX, normalY, normalZ, this.quad);
            for (long vertex = 0L; vertex < 4L; ++vertex) {
                MemoryUtil.memPutFloat((long)(i + 36L - (long)STRIDE * vertex), (float)this.uSum);
                MemoryUtil.memPutFloat((long)(i + 40L - (long)STRIDE * vertex), (float)this.vSum);
                MemoryUtil.memPutInt((long)(i + 28L - (long)STRIDE * vertex), (int)normal);
                MemoryUtil.memPutInt((long)(i + 44L - (long)STRIDE * vertex), (int)tangent);
            }
            this.uSum = 0.0f;
            this.vSum = 0.0f;
        }
        this.buffer.position(this.buffer.position() + STRIDE);
        this.elementOffset += (long)STRIDE;
    }

    static class TextQuadView
    implements QuadView {
        long writePointer;
        int stride;

        public void setup(long writePointer, int stride) {
            this.writePointer = writePointer;
            this.stride = stride;
        }

        @Override
        public float x(int index) {
            return MemoryUtil.memGetFloat((long)(this.writePointer - (long)this.stride * (3L - (long)index)));
        }

        @Override
        public float y(int index) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 4L - (long)this.stride * (3L - (long)index)));
        }

        @Override
        public float z(int index) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 8L - (long)this.stride * (3L - (long)index)));
        }

        @Override
        public float u(int index) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 16L - (long)this.stride * (3L - (long)index)));
        }

        @Override
        public float v(int index) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 20L - (long)this.stride * (3L - (long)index)));
        }
    }
}

