/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiCreativePictureFrame;
import team.creative.littleframes.common.block.BECreativePictureFrame;

public class BlockCreativePictureFrame
extends BaseEntityBlock
implements BlockGuiCreator {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final float frameThickness = 0.031f;

    public static AlignedBox box(Direction direction) {
        Facing facing = Facing.get((Direction)direction);
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMax(facing.axis, 0.031f);
        } else {
            box.setMin(facing.axis, 0.969f);
        }
        return box;
    }

    public BlockCreativePictureFrame() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155956_(2.5f).m_155954_(2.0f).m_60955_());
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BlockCreativePictureFrame.box((Direction)state.m_61143_((Property)FACING)).voxelShape();
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return BlockCreativePictureFrame.box((Direction)state.m_61143_((Property)FACING)).voxelShape();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && LittleFrames.CONFIG.canInteract(player, level)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BECreativePictureFrame::tick;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BECreativePictureFrame(pos, state);
    }

    public GuiLayer create(CompoundTag nbt, Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BECreativePictureFrame) {
            BECreativePictureFrame frame = (BECreativePictureFrame)be;
            return new GuiCreativePictureFrame(frame);
        }
        return null;
    }
}

