/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky77.system;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SystemTrades {
    public static void addTradeToProfession(VillagerProfession profession, int level, VillagerTrades.ItemListing[] newTrades) {
        int i;
        Int2ObjectMap listing = (Int2ObjectMap)VillagerTrades.f_35627_.get(profession);
        VillagerTrades.ItemListing[] oldTrades = (VillagerTrades.ItemListing[])listing.get(level);
        VillagerTrades.ItemListing[] temp = new VillagerTrades.ItemListing[oldTrades.length + newTrades.length];
        for (i = 0; i < oldTrades.length; ++i) {
            temp[i] = oldTrades[i];
        }
        for (i = 0; i < newTrades.length; ++i) {
            temp[i + oldTrades.length] = newTrades[i];
        }
        listing.put(1, (Object)temp);
        VillagerTrades.f_35627_.put(profession, listing);
    }

    public static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> p_35631_) {
        return new Int2ObjectOpenHashMap(p_35631_);
    }

    public static class ItemsForGems
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final Item gem;
        private final int gemCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForGems(Block block, int gemCost, int numberOfItems, int maxUses, int villagerXp) {
            this(new ItemStack((ItemLike)block), gemCost, numberOfItems, maxUses, villagerXp);
        }

        public ItemsForGems(Block block, int gemCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier) {
            this(new ItemStack((ItemLike)block), gemCost, numberOfItems, maxUses, villagerXp, priceMultiplier);
        }

        public ItemsForGems(Item item, int gemCost, int numberOfItems, int maxUses, int villagerXp) {
            this(new ItemStack((ItemLike)item), gemCost, numberOfItems, maxUses, villagerXp);
        }

        public ItemsForGems(Item item, int gemCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier) {
            this(new ItemStack((ItemLike)item), gemCost, numberOfItems, maxUses, villagerXp, priceMultiplier);
        }

        public ItemsForGems(ItemStack itemstack, int emeraldCost, int numberOfItems, int maxUses, int villagerXp) {
            this(itemstack, emeraldCost, numberOfItems, maxUses, villagerXp, 0.05f, Items.f_42616_);
        }

        public ItemsForGems(ItemStack itemstack, int emeraldCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier) {
            this(itemstack, emeraldCost, numberOfItems, maxUses, villagerXp, priceMultiplier, Items.f_42616_);
        }

        public ItemsForGems(ItemStack itemStack, int gemCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier, Item gem) {
            this.itemStack = itemStack;
            this.gemCost = gemCost;
            this.numberOfItems = numberOfItems;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
            this.gem = gem;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)this.gem, this.gemCost), new ItemStack((ItemLike)this.itemStack.m_41720_(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class GemsForItems
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final Item gem;
        private final int cost;
        private final int amount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public GemsForItems(Block block, int cost, int maxUses, int villagerXP) {
            this((ItemLike)block, cost, (ItemLike)Items.f_42616_, 1, maxUses, villagerXP, 0.05f);
        }

        public GemsForItems(Block block, int cost, int maxUses, int villagerXP, float priceMultiplier) {
            this((ItemLike)block, cost, (ItemLike)Items.f_42616_, 1, maxUses, villagerXP, priceMultiplier);
        }

        public GemsForItems(Item item, int cost, int maxUses, int villagerXP) {
            this((ItemLike)item, cost, (ItemLike)Items.f_42616_, 1, maxUses, villagerXP, 0.05f);
        }

        public GemsForItems(Item item, int cost, int maxUses, int villagerXP, float priceMultiplier) {
            this((ItemLike)item, cost, (ItemLike)Items.f_42616_, 1, maxUses, villagerXP, priceMultiplier);
        }

        public GemsForItems(ItemLike item, int cost, ItemLike gem, int amount, int maxUses, int villagerXP, float priceMultiplier) {
            this.item = item.m_5456_();
            this.gem = gem.m_5456_();
            this.cost = cost;
            this.amount = amount;
            this.maxUses = maxUses;
            this.villagerXp = villagerXP;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)this.item, this.cost), new ItemStack((ItemLike)this.gem, this.amount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

