/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.factory.discovery.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lib720.caprica.vlcj.factory.discovery.provider.ConfigDirConfigFileDiscoveryDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.CustomDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.JnaLibraryPathDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.LinuxWellKnownDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.MacOsWellKnownDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.SystemPathDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.UserDirConfigFileDiscoveryDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.UserDirDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.provider.WindowsInstallDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.strategy.BaseNativeDiscoveryStrategy;

public abstract class DirectoryProviderDiscoveryStrategy
extends BaseNativeDiscoveryStrategy {
    private final List<DiscoveryDirectoryProvider> directoryProviders = Arrays.asList(new CustomDirectoryProvider(), new UserDirDirectoryProvider(), new ConfigDirConfigFileDiscoveryDirectoryProvider(), new UserDirConfigFileDiscoveryDirectoryProvider(), new JnaLibraryPathDirectoryProvider(), new LinuxWellKnownDirectoryProvider(), new MacOsWellKnownDirectoryProvider(), new SystemPathDirectoryProvider(), new UserDirDirectoryProvider(), new WindowsInstallDirectoryProvider());

    public DirectoryProviderDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        super(filenamePatterns, pluginPathFormats);
    }

    @Override
    public final List<String> discoveryDirectories() {
        ArrayList<String> directories = new ArrayList<String>();
        for (DiscoveryDirectoryProvider provider : this.getSupportedProviders()) {
            directories.addAll(Arrays.asList(provider.directories()));
        }
        return directories;
    }

    private List<DiscoveryDirectoryProvider> getSupportedProviders() {
        ArrayList<DiscoveryDirectoryProvider> result = new ArrayList<DiscoveryDirectoryProvider>();
        for (DiscoveryDirectoryProvider service : this.directoryProviders) {
            if (!service.supported()) continue;
            result.add(service);
        }
        return this.sort(result);
    }

    private List<DiscoveryDirectoryProvider> sort(List<DiscoveryDirectoryProvider> providers) {
        providers.sort((a1, a2) -> a2.priority() - a1.priority());
        return providers;
    }
}

