/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.log;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.lib720.caprica.vlcj.binding.internal.libvlc_instance_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_log_cb;
import me.lib720.caprica.vlcj.binding.internal.libvlc_log_t;
import me.lib720.caprica.vlcj.binding.lib.LibC;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.binding.support.strings.NativeString;
import me.lib720.caprica.vlcj.log.LogEventListener;
import me.lib720.caprica.vlcj.log.LogLevel;

public final class NativeLog {
    private static final int BUFFER_SIZE = 201;
    private final List<LogEventListener> eventListenerList = new CopyOnWriteArrayList<LogEventListener>();
    private final libvlc_instance_t instance;
    private NativeLogCallback callback = new NativeLogCallback();
    private LogLevel logLevel = LogLevel.NOTICE;

    public NativeLog(libvlc_instance_t instance) {
        this.instance = instance;
        LibVlc.libvlc_log_set(instance, this.callback, null);
    }

    public final void addLogListener(LogEventListener listener) {
        this.eventListenerList.add(listener);
    }

    public final void removeLogListener(LogEventListener listener) {
        this.eventListenerList.remove(listener);
    }

    public final void setLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public final LogLevel getLevel() {
        return this.logLevel;
    }

    public final void release() {
        this.eventListenerList.clear();
        LibVlc.libvlc_log_unset(this.instance);
    }

    private String getString(PointerByReference pointer) {
        Pointer value = pointer.getValue();
        return value != null ? NativeString.copyNativeString(value) : null;
    }

    private void raiseLogEvent(LogLevel level, String module, String file, Integer line, String name, String header, Integer id, String message) {
        for (LogEventListener listener : this.eventListenerList) {
            try {
                listener.log(level, module, file, line, name, header, id, message);
            }
            catch (Exception exception) {}
        }
    }

    private final class NativeLogCallback
    implements libvlc_log_cb {
        private NativeLogCallback() {
            Native.setCallbackThreadInitializer((Callback)this, (CallbackThreadInitializer)new CallbackThreadInitializer(true, false, "log-events"));
        }

        @Override
        public void log(Pointer data, int level, libvlc_log_t ctx, String format, Pointer args) {
            if (NativeLog.this.logLevel != null && level >= NativeLog.this.logLevel.intValue()) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(201);
                int size = LibC.INSTANCE.vsnprintf(byteBuffer, byteBuffer.capacity(), format, args);
                if (size >= 0) {
                    size = Math.min(size, 201);
                    byte[] bytes = new byte[size];
                    byteBuffer.get(bytes);
                    String message = new String(bytes);
                    if (message.length() > 0) {
                        PointerByReference modulePointer = new PointerByReference();
                        PointerByReference filePointer = new PointerByReference();
                        IntByReference linePointer = new IntByReference();
                        LibVlc.libvlc_log_get_context(ctx, modulePointer, filePointer, linePointer);
                        PointerByReference namePointer = new PointerByReference();
                        PointerByReference headerPointer = new PointerByReference();
                        IntByReference idPointer = new IntByReference();
                        LibVlc.libvlc_log_get_object(ctx, namePointer, headerPointer, idPointer);
                        String module = NativeLog.this.getString(modulePointer);
                        String file = NativeLog.this.getString(filePointer);
                        Integer line = linePointer.getValue();
                        String name = NativeLog.this.getString(namePointer);
                        String header = NativeLog.this.getString(headerPointer);
                        Integer id = idPointer.getValue();
                        NativeLog.this.raiseLogEvent(LogLevel.level(level), module, file, line, name, header, id, message);
                    }
                } else {
                    NativeLog.this.raiseLogEvent(LogLevel.ERROR, null, null, null, null, null, null, "Failed to format native log message");
                }
            }
        }
    }
}

