/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.embedded.videosurface;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class ByteBufferFactory {
    private static final long addressOffset = ByteBufferFactory.getAddressOffset();
    private static final int LIBVLC_ALIGNMENT = 32;

    static ByteBuffer allocateAlignedBuffer(int capacity) {
        return ByteBufferFactory.allocateAlignedBuffer(capacity, 32);
    }

    static long getAddress(ByteBuffer buffer) {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        return UnsafeAccess.UNSAFE.getLong(buffer, addressOffset);
    }

    private static long getAddressOffset() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        try {
            return UnsafeAccess.UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ByteBuffer allocateAlignedBuffer(int capacity, int alignment) {
        ByteBuffer result;
        ByteBuffer buffer;
        long address;
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        if (((address = ByteBufferFactory.getAddress(buffer = ByteBuffer.allocateDirect(capacity + alignment))) & (long)(alignment - 1)) == 0L) {
            ((Buffer)buffer).limit(capacity);
            result = buffer.slice().order(ByteOrder.nativeOrder());
        } else {
            int newPosition = (int)((long)alignment - (address & (long)(alignment - 1)));
            ((Buffer)buffer).position(newPosition);
            ((Buffer)buffer).limit(newPosition + capacity);
            result = buffer.slice().order(ByteOrder.nativeOrder());
        }
        return result;
    }

    private ByteBufferFactory() {
    }

    private static class UnsafeAccess {
        private static final Unsafe UNSAFE;

        private UnsafeAccess() {
        }

        static {
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            }
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                UNSAFE = (Unsafe)field.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

